/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.recipe;

import gnu.trove.iterator.TIntIterator;
import gnu.trove.list.TIntList;
import ic2.core.item.recipe.AdvRecipe;
import ic2.core.item.recipe.AdvRecipeBase;
import ic2.core.item.recipe.AdvShapelessRecipe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import wanion.lib.recipe.RecipeAttributes;
import wanion.lib.recipe.RecipeHelper;
import wanion.unidict.common.Util;
import wanion.unidict.recipe.AbstractRecipeResearcher;
import wanion.unidict.resource.ResourceHandler;
import wanion.unidict.resource.UniResourceContainer;

public class IC2CRecipeResearcher
extends AbstractRecipeResearcher<AdvRecipe, AdvShapelessRecipe> {
    public int getShapedRecipeKey(@Nonnull AdvRecipe advRecipe) {
        if (advRecipe.isInvisible()) {
            return 0;
        }
        TIntList recipeKeys = Util.getList(advRecipe.func_192400_c(), this.resourceHandler);
        int recipeKey = 0;
        recipeKeys.sort();
        TIntIterator recipeKeysIterator = recipeKeys.iterator();
        while (recipeKeysIterator.hasNext()) {
            recipeKey += 31 * recipeKeysIterator.next();
        }
        return recipeKey;
    }

    public int getShapelessRecipeKey(@Nonnull AdvShapelessRecipe advShapelessRecipe) {
        if (advShapelessRecipe.isInvisible()) {
            return 0;
        }
        TIntList recipeKeys = Util.getList(advShapelessRecipe.func_192400_c(), this.resourceHandler);
        int recipeKey = 0;
        recipeKeys.sort();
        TIntIterator recipeKeysIterator = recipeKeys.iterator();
        while (recipeKeysIterator.hasNext()) {
            recipeKey += 31 * recipeKeysIterator.next();
        }
        return recipeKey;
    }

    @Nonnull
    public List<Class<? extends AdvRecipe>> getShapedRecipeClasses() {
        return Collections.singletonList(AdvRecipe.class);
    }

    @Nonnull
    public List<Class<? extends AdvShapelessRecipe>> getShapelessRecipeClasses() {
        return Collections.singletonList(AdvShapelessRecipe.class);
    }

    public ShapedOreRecipe getNewShapedRecipe(@Nonnull AdvRecipe advRecipe) {
        return IC2CRecipeResearcher.getNewShapedRecipe((AdvRecipeBase)advRecipe, this.resourceHandler);
    }

    public ShapedOreRecipe getNewShapedFromShapelessRecipe(@Nonnull AdvShapelessRecipe advShapelessRecipe) {
        return IC2CRecipeResearcher.getNewShapedRecipe((AdvRecipeBase)advShapelessRecipe, this.resourceHandler);
    }

    public ShapelessOreRecipe getNewShapelessRecipe(@Nonnull AdvShapelessRecipe advShapelessRecipe) {
        return IC2CRecipeResearcher.getNewShapelessRecipe((AdvRecipeBase)advShapelessRecipe, this.resourceHandler);
    }

    public ShapelessOreRecipe getNewShapelessFromShapedRecipe(@Nonnull AdvRecipe advRecipe) {
        return IC2CRecipeResearcher.getNewShapelessRecipe((AdvRecipeBase)advRecipe, this.resourceHandler);
    }

    public static ShapedOreRecipe getNewShapedRecipe(@Nonnull AdvRecipeBase advRecipeBase, @Nonnull ResourceHandler resourceHandler) {
        UniResourceContainer outputContainer = resourceHandler.getContainer(advRecipeBase.func_77571_b());
        if (outputContainer == null) {
            return null;
        }
        Object[] newRecipeInputs = IC2CRecipeResearcher.getNewShapedRecipeInputs(advRecipeBase, resourceHandler);
        int outputSize = advRecipeBase.func_77571_b().func_190916_E();
        ItemStack outputStack = outputContainer.getMainEntry(outputSize);
        RecipeAttributes newRecipeAttributes = RecipeHelper.rawShapeToShape((Object[])newRecipeInputs);
        return new ShapedOreRecipe(new ResourceLocation("unidict", outputContainer.name + "_x" + outputSize + "_shape." + newRecipeAttributes.shape), outputStack, newRecipeAttributes.actualShape);
    }

    public static Object[] getNewShapedRecipeInputs(@Nonnull AdvRecipeBase advRecipeBase, @Nonnull ResourceHandler resourceHandler) {
        int height;
        NonNullList recipeInputs = advRecipeBase.func_192400_c();
        int width = advRecipeBase.getRecipeLength();
        int root = width > (height = advRecipeBase.getRecipeHeight()) ? width : height;
        Object[] newRecipeInputs = new Object[root * root];
        int i = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                Ingredient ingredient;
                Ingredient ingredient2 = ingredient = i < recipeInputs.size() ? (Ingredient)recipeInputs.get(i) : null;
                if (ingredient != null && ingredient.func_193365_a().length > 0) {
                    ItemStack itemStack = ingredient.func_193365_a()[0];
                    UniResourceContainer container = resourceHandler.getContainer(itemStack);
                    newRecipeInputs[y * root + x] = container != null ? (itemStacksOnly ? container.getMainEntry(itemStack) : container.name) : itemStack;
                }
                ++x;
                ++i;
            }
        }
        return newRecipeInputs;
    }

    public static ShapelessOreRecipe getNewShapelessRecipe(@Nonnull AdvRecipeBase advRecipeBase, @Nonnull ResourceHandler resourceHandler) {
        UniResourceContainer outputContainer = resourceHandler.getContainer(advRecipeBase.func_77571_b());
        if (outputContainer == null) {
            return null;
        }
        List<Object> inputs = IC2CRecipeResearcher.getNewShapelessRecipeInputs(advRecipeBase, resourceHandler);
        int outputSize = advRecipeBase.func_77571_b().func_190916_E();
        ItemStack outputStack = outputContainer.getMainEntry(outputSize);
        return new ShapelessOreRecipe(new ResourceLocation("unidict", outputContainer.name + "_x" + outputSize + "_size." + inputs.size()), outputStack, inputs.toArray());
    }

    public static List<Object> getNewShapelessRecipeInputs(@Nonnull AdvRecipeBase advRecipeBase, @Nonnull ResourceHandler resourceHandler) {
        ArrayList<Object> inputs = new ArrayList<Object>();
        if (itemStacksOnly) {
            for (Ingredient ingredient : advRecipeBase.func_192400_c()) {
                if (ingredient == null || ingredient.func_193365_a().length <= 0) continue;
                inputs.add(resourceHandler.getMainItemStack(ingredient.func_193365_a()[0]));
            }
        } else {
            for (Ingredient ingredient : advRecipeBase.func_192400_c()) {
                if (ingredient == null || ingredient.func_193365_a().length <= 0) continue;
                ItemStack input = ingredient.func_193365_a()[0];
                UniResourceContainer container = resourceHandler.getContainer(input);
                inputs.add(container != null ? container.name : input);
            }
        }
        return inputs;
    }
}

