/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.plugin.crafttweaker.RemovalByKind;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import gnu.trove.list.TIntList;
import gnu.trove.map.TIntObjectMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.RegistryManager;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenExpansion;
import wanion.unidict.api.UniDictAPI;
import wanion.unidict.plugin.crafttweaker.RemovalByKind.RemovalByKind;
import wanion.unidict.resource.ResourceHandler;
import wanion.unidict.resource.UniAttributes;

@ZenExpansion(value="mods.unidict.removalByKind")
public final class Crafting
extends RemovalByKind {
    @Override
    public void remove(@Nonnull String kind, @Optional String[] resourceKindWhiteList) {
        CraftTweakerAPI.apply((IAction)new RemovalByKind.RemovalByKindAction(this, kind, resourceKindWhiteList));
    }

    @Override
    public void apply(@Nonnull UniDictAPI uniDictAPI) {
        TIntObjectMap<TIntList> kindsForRemoval = this.getKindsForRemovalHashMap();
        ResourceHandler uniDictApiResourceHandler = uniDictAPI.getResourceHandler();
        Set recipes = RegistryManager.ACTIVE.getRegistry(GameData.RECIPES).getEntries();
        ArrayList<ResourceLocation> recipesToRemove = new ArrayList<ResourceLocation>();
        for (Map.Entry recipeEntry : recipes) {
            TIntList resourceWhiteListedKinds;
            IRecipe recipe = (IRecipe)recipeEntry.getValue();
            UniAttributes uniAttributes = uniDictApiResourceHandler.get(recipe.func_77571_b());
            if (uniAttributes == null || (resourceWhiteListedKinds = (TIntList)kindsForRemoval.get(uniAttributes.kind)) == null || !resourceWhiteListedKinds.isEmpty() && !uniAttributes.resource.childrenExists(resourceWhiteListedKinds)) continue;
            recipesToRemove.add(recipe.getRegistryName());
        }
        ForgeRegistry recipeRegistry = RegistryManager.ACTIVE.getRegistry(GameData.RECIPES);
        recipesToRemove.forEach(arg_0 -> ((ForgeRegistry)recipeRegistry).remove(arg_0));
    }

    @Override
    @Nonnull
    protected String getName() {
        return "Crafting";
    }

    @Override
    @Nonnull
    protected String getDescription() {
        return "Trying to remove Crafting Table recipes for kind: ";
    }
}

