/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.integration;

import exter.foundry.api.recipe.IAlloyFurnaceRecipe;
import exter.foundry.api.recipe.IAtomizerRecipe;
import exter.foundry.api.recipe.ICastingRecipe;
import exter.foundry.api.recipe.ICastingTableRecipe;
import exter.foundry.api.recipe.matcher.IItemMatcher;
import exter.foundry.api.recipe.matcher.ItemStackMatcher;
import exter.foundry.recipes.AlloyFurnaceRecipe;
import exter.foundry.recipes.AtomizerRecipe;
import exter.foundry.recipes.CastingRecipe;
import exter.foundry.recipes.CastingTableRecipe;
import exter.foundry.recipes.manager.AlloyFurnaceRecipeManager;
import exter.foundry.recipes.manager.AtomizerRecipeManager;
import exter.foundry.recipes.manager.CastingRecipeManager;
import exter.foundry.recipes.manager.CastingTableRecipeManager;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.item.ItemStack;
import wanion.unidict.UniDict;
import wanion.unidict.integration.AbstractIntegrationThread;

final class FoundryIntegration
extends AbstractIntegrationThread {
    FoundryIntegration() {
        super("Foundry");
    }

    public String call() {
        try {
            this.fixAlloyFurnaceRecipes();
            this.fixAtomizerRecipes();
            this.fixCastingRecipes();
            this.fixCastingTableRecipes();
        }
        catch (Exception e) {
            UniDict.getLogger().error(this.threadName + e);
        }
        return this.threadName + "Somethings that were made in casts had to change.";
    }

    private void fixAlloyFurnaceRecipes() {
        AlloyFurnaceRecipeManager alloyFurnaceRecipeManager = AlloyFurnaceRecipeManager.INSTANCE;
        ArrayList<IAlloyFurnaceRecipe> removalList = new ArrayList<IAlloyFurnaceRecipe>();
        ArrayList<AlloyFurnaceRecipe> newRecipes = new ArrayList<AlloyFurnaceRecipe>();
        for (IAlloyFurnaceRecipe atomizerRecipe : alloyFurnaceRecipeManager.getRecipes()) {
            ItemStack correctOutput;
            ItemStack output = atomizerRecipe.getOutput();
            if (output == (correctOutput = this.resourceHandler.getMainItemStack(output))) continue;
            newRecipes.add(new AlloyFurnaceRecipe(correctOutput, atomizerRecipe.getInputA(), atomizerRecipe.getInputB()));
            removalList.add(atomizerRecipe);
        }
        removalList.forEach(arg_0 -> ((AlloyFurnaceRecipeManager)alloyFurnaceRecipeManager).removeRecipe(arg_0));
        newRecipes.forEach(arg_0 -> ((AlloyFurnaceRecipeManager)alloyFurnaceRecipeManager).addRecipe(arg_0));
    }

    private void fixAtomizerRecipes() {
        AtomizerRecipeManager atomizerRecipeManager = AtomizerRecipeManager.INSTANCE;
        ArrayList<IAtomizerRecipe> removalList = new ArrayList<IAtomizerRecipe>();
        ArrayList<AtomizerRecipe> newRecipes = new ArrayList<AtomizerRecipe>();
        for (IAtomizerRecipe atomizerRecipe : atomizerRecipeManager.getRecipes()) {
            ItemStack correctOutput;
            ItemStack output = atomizerRecipe.getOutput();
            if (output == (correctOutput = this.resourceHandler.getMainItemStack(output))) continue;
            newRecipes.add(new AtomizerRecipe((IItemMatcher)new ItemStackMatcher(correctOutput), atomizerRecipe.getInput()));
            removalList.add(atomizerRecipe);
        }
        removalList.forEach(arg_0 -> ((AtomizerRecipeManager)atomizerRecipeManager).removeRecipe(arg_0));
        newRecipes.forEach(arg_0 -> ((AtomizerRecipeManager)atomizerRecipeManager).addRecipe(arg_0));
    }

    private void fixCastingRecipes() {
        CastingRecipeManager castingRecipeManager = CastingRecipeManager.INSTANCE;
        ArrayList<ICastingRecipe> removalList = new ArrayList<ICastingRecipe>();
        ArrayList<CastingRecipe> newRecipes = new ArrayList<CastingRecipe>();
        for (ICastingRecipe castingRecipe : castingRecipeManager.getRecipes()) {
            ItemStack correctOutput;
            ItemStack output = castingRecipe.getOutput();
            if (output == (correctOutput = this.resourceHandler.getMainItemStack(output))) continue;
            newRecipes.add(new CastingRecipe((IItemMatcher)new ItemStackMatcher(correctOutput), castingRecipe.getInput(), castingRecipe.getMold(), castingRecipe.getInputExtra(), castingRecipe.getCastingSpeed()));
            removalList.add(castingRecipe);
        }
        removalList.forEach(arg_0 -> ((CastingRecipeManager)castingRecipeManager).removeRecipe(arg_0));
        newRecipes.forEach(arg_0 -> ((CastingRecipeManager)castingRecipeManager).addRecipe(arg_0));
    }

    private void fixCastingTableRecipes() {
        Map castingTableRecipeMap = CastingTableRecipeManager.INSTANCE.getRecipesMap();
        castingTableRecipeMap.forEach((tableType, stringICastingTableRecipeMap) -> stringICastingTableRecipeMap.entrySet().forEach(entry -> {
            ICastingTableRecipe castingTableRecipe = (ICastingTableRecipe)entry.getValue();
            ItemStack correctOutput = this.resourceHandler.getMainItemStack(castingTableRecipe.getOutput());
            if (castingTableRecipe.getOutput() != correctOutput) {
                entry.setValue(new CastingTableRecipe((IItemMatcher)new ItemStackMatcher(correctOutput), castingTableRecipe.getInput(), castingTableRecipe.getTableType()));
            }
        }));
    }
}

