/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.renderer;

import java.util.Set;
import javax.vecmath.Matrix4f;
import net.malisis.core.renderer.DefaultRenderer;
import net.malisis.core.renderer.MalisisRenderer;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.RenderType;
import net.malisis.core.renderer.animation.AnimationRenderer;
import net.malisis.core.renderer.animation.transformation.ChainedTransformation;
import net.malisis.core.renderer.animation.transformation.ITransformable;
import net.malisis.core.renderer.animation.transformation.ParallelTransformation;
import net.malisis.core.renderer.animation.transformation.Rotation;
import net.malisis.core.renderer.animation.transformation.Transformation;
import net.malisis.core.renderer.animation.transformation.Translation;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.element.shape.Cube;
import net.malisis.core.util.EnumFacingUtils;
import net.malisis.core.util.TransformBuilder;
import net.malisis.doors.DoorState;
import net.malisis.doors.tileentity.GarageDoorTileEntity;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;

public class GarageDoorRenderer
extends MalisisRenderer<GarageDoorTileEntity> {
    protected EnumFacing direction;
    protected boolean opened;
    protected boolean topBlock;
    protected Shape shape;
    protected RenderParameters rp;
    protected AnimationRenderer ar = new AnimationRenderer();
    private Matrix4f firstPersonHand = new TransformBuilder().rotate(0.0f, 90.0f, 0.0f).scale(0.4f).get();

    public GarageDoorRenderer() {
        this.registerFor(GarageDoorTileEntity.class);
    }

    protected void initialize() {
        this.shape = new Cube().setBounds(0.0, 0.0, 0.40625, 1.0, 1.0, 0.59375);
        this.shape.storeState();
        this.rp = new RenderParameters();
        this.rp.renderAllFaces.set((Object)true);
        this.rp.calculateAOColor.set((Object)false);
        this.rp.useBlockBounds.set((Object)false);
        this.rp.useEnvironmentBrightness.set((Object)false);
        this.rp.calculateBrightness.set((Object)false);
        this.rp.interpolateUV.set((Object)false);
        this.rp.useWorldSensitiveIcon.set((Object)false);
    }

    public Matrix4f getTransform(Item item, ItemCameraTransforms.TransformType tranformType) {
        if (tranformType == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND || tranformType == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND) {
            return this.firstPersonHand;
        }
        return DefaultRenderer.block.getTransform(item, tranformType);
    }

    public void render() {
        if (this.renderType == RenderType.ITEM) {
            this.shape.resetState();
            this.drawShape(this.shape);
            return;
        }
        if (this.tileEntity == null || !((GarageDoorTileEntity)this.tileEntity).isTop()) {
            return;
        }
        this.direction = ((GarageDoorTileEntity)this.tileEntity).getDirection();
        this.enableBlending();
        this.renderTileEntity();
    }

    protected void renderTileEntity() {
        int t = 10;
        this.ar.setStartTime(((GarageDoorTileEntity)this.tileEntity).getTimer().getStart());
        Set<GarageDoorTileEntity> doors = ((GarageDoorTileEntity)this.tileEntity).getDoors();
        for (GarageDoorTileEntity te : doors) {
            this.shape.resetState();
            this.shape.rotate((float)(EnumFacingUtils.getRotationCount((EnumFacing)((GarageDoorTileEntity)this.tileEntity).getDirection()) * 90), 0.0f, 1.0f, 0.0f);
            this.pos = te.func_174877_v();
            this.set(this.world.func_180495_p(this.pos));
            int delta = ((GarageDoorTileEntity)this.tileEntity).func_174877_v().func_177956_o() - this.pos.func_177956_o();
            int delta2 = doors.size() - (delta + 1);
            Translation verticalAnim = (Translation)new Translation(0.0f, (float)(-delta), 0.0f, 0.0f, 0.0f, 0.0f).forTicks(t * delta, 0);
            ParallelTransformation topRotate = new ParallelTransformation(new Transformation[]{new Translation(0.0f, 1.0f, 0.0f).forTicks(t, 0), new Rotation(0.0f, -90.0f).aroundAxis(1.0f, 0.0f, 0.0f).offset(-0.5f, -0.5f, 0.0f).forTicks(t, 0)});
            Translation horizontalAnim = (Translation)new Translation(0.0f, 0.0f, 0.0f, 0.0f, (float)delta2, 0.0f).forTicks(t * delta2, 0);
            ChainedTransformation chained = new ChainedTransformation(new Transformation[]{verticalAnim, topRotate, horizontalAnim});
            if (((GarageDoorTileEntity)this.tileEntity).getState() == DoorState.CLOSING || ((GarageDoorTileEntity)this.tileEntity).getState() == DoorState.CLOSED) {
                chained.reversed(true);
            }
            this.rp.brightness.set((Object)this.blockState.func_185889_a(this.world, this.pos));
            this.rp.rotateIcon.set((Object)false);
            this.ar.animate((ITransformable)this.shape, (Transformation)chained);
            this.drawShape(this.shape, this.rp);
        }
        this.pos = ((GarageDoorTileEntity)this.tileEntity).func_174877_v();
    }
}

