/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.movement;

import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.animation.Animation;
import net.malisis.core.renderer.animation.transformation.ITransformable;
import net.malisis.core.renderer.animation.transformation.Rotation;
import net.malisis.core.renderer.animation.transformation.Transformation;
import net.malisis.core.renderer.model.MalisisModel;
import net.malisis.core.util.AABBUtils;
import net.malisis.doors.DoorState;
import net.malisis.doors.movement.IDoorMovement;
import net.malisis.doors.tileentity.DoorTileEntity;
import net.malisis.doors.tileentity.TrapDoorTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;

public class TrapDoorMovement
implements IDoorMovement {
    @Override
    public AxisAlignedBB getOpenBoundingBox(DoorTileEntity tileEntity, boolean topBlock, BoundingBoxType type) {
        AxisAlignedBB aabb = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.1875, 1.0);
        boolean top = ((TrapDoorTileEntity)tileEntity).isTop();
        if (top) {
            aabb = aabb.func_72317_d(0.0, 0.8125, 0.0);
        }
        if (tileEntity.isOpened()) {
            aabb = AABBUtils.rotate((AxisAlignedBB)aabb, (int)(top ? 1 : -1), (EnumFacing.Axis)EnumFacing.Axis.X);
        }
        return aabb;
    }

    private Rotation getTransformation(DoorTileEntity tileEntity) {
        float f = 0.40625f;
        float fromAngle = 0.0f;
        float toAngle = 90.0f;
        if (((TrapDoorTileEntity)tileEntity).isTop()) {
            toAngle = -toAngle;
        }
        if (tileEntity.getState() == DoorState.CLOSING || tileEntity.getState() == DoorState.CLOSED) {
            float tmp = toAngle;
            toAngle = fromAngle;
            fromAngle = tmp;
        }
        return (Rotation)new Rotation(fromAngle, toAngle).aroundAxis(1.0f, 0.0f, 0.0f).offset(0.0f, -f, f).forTicks(tileEntity.getDescriptor().getOpeningTime());
    }

    @Override
    public Animation<?>[] getAnimations(DoorTileEntity tileEntity, MalisisModel model, RenderParameters rp) {
        return new Animation[]{new Animation((ITransformable)model, (Transformation)this.getTransformation(tileEntity))};
    }

    @Override
    public boolean isSpecial() {
        return true;
    }
}

