/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.block;

import net.malisis.core.MalisisCore;
import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.block.IComponent;
import net.malisis.core.block.MalisisBlock;
import net.malisis.core.block.component.DirectionalComponent;
import net.malisis.core.block.component.PowerComponent;
import net.malisis.core.renderer.MalisisRendered;
import net.malisis.core.renderer.icon.Icon;
import net.malisis.core.renderer.icon.provider.IBlockIconProvider;
import net.malisis.core.util.TileEntityUtils;
import net.malisis.doors.DoorState;
import net.malisis.doors.MalisisDoors;
import net.malisis.doors.renderer.GarageDoorRenderer;
import net.malisis.doors.tileentity.GarageDoorTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@MalisisRendered(item=GarageDoorRenderer.class)
public class GarageDoor
extends MalisisBlock
implements ITileEntityProvider {
    public GarageDoor() {
        super(Material.field_151575_d);
        this.setName("garage_door");
        this.setCreativeTab((CreativeTabs)MalisisDoors.tab);
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.addComponent((IComponent)new DirectionalComponent());
        this.addComponent((IComponent)new PowerComponent(PowerComponent.InteractionType.REDSTONE, PowerComponent.ComponentType.RECEIVER));
        if (MalisisCore.isClient()) {
            this.addComponent((IComponent)GarageDoorIconProvider.get());
        }
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState neighborState = world.func_180495_p(pos.func_177984_a());
        if (neighborState.func_177230_c() == this) {
            return neighborState;
        }
        neighborState = world.func_180495_p(pos.func_177977_b());
        if (neighborState.func_177230_c() == this) {
            return neighborState;
        }
        return super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock, BlockPos fromPos) {
        boolean powered;
        GarageDoorTileEntity te = (GarageDoorTileEntity)((Object)TileEntityUtils.getTileEntity(GarageDoorTileEntity.class, (IBlockAccess)world, (BlockPos)pos));
        if (te == null || te.isMoving()) {
            return;
        }
        boolean bl = powered = world.func_175687_A(pos) != 0;
        if ((powered || neighborBlock.func_176223_P().func_185897_m()) && neighborBlock != this) {
            te.getTopDoor().setPowered(powered);
        }
    }

    public AxisAlignedBB getBoundingBox(IBlockAccess world, BlockPos pos, IBlockState state, BoundingBoxType type) {
        GarageDoorTileEntity te = (GarageDoorTileEntity)((Object)TileEntityUtils.getTileEntity(GarageDoorTileEntity.class, (IBlockAccess)world, (BlockPos)pos));
        if (te != null && (te.isMoving() || te.getState() != DoorState.CLOSED)) {
            return null;
        }
        float w = 0.09375f;
        return new AxisAlignedBB(0.0, 0.0, (double)(0.5f - w), 1.0, 1.0, (double)(0.5f + w));
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new GarageDoorTileEntity();
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static class GarageDoorIconProvider
    implements IBlockIconProvider {
        private Icon topIcon = Icon.from((String)"malisisdoors:blocks/garage_door_top");
        private Icon baseIcon = Icon.from((String)"malisisdoors:blocks/garage_door");

        public Icon getIcon() {
            return this.baseIcon;
        }

        public Icon getIcon(IBlockAccess world, BlockPos pos, IBlockState state, EnumFacing side) {
            GarageDoorTileEntity te = (GarageDoorTileEntity)((Object)TileEntityUtils.getTileEntity(GarageDoorTileEntity.class, (IBlockAccess)world, (BlockPos)pos));
            return te != null && te.isTop() ? this.getIcon(state, side) : this.baseIcon;
        }

        public Icon getIcon(IBlockState state, EnumFacing side) {
            return side == null || side.func_176740_k() == EnumFacing.Axis.Z ? this.topIcon : this.baseIcon;
        }

        public static GarageDoorIconProvider get() {
            return new GarageDoorIconProvider();
        }
    }
}

