/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialai.config;

import fathertoast.specialai.ai.elite.EliteAIHandler;
import fathertoast.specialai.ai.elite.IEliteAI;
import fathertoast.specialai.config.EntityListConfig;
import fathertoast.specialai.config.EntryEntity;
import fathertoast.specialai.config.TargetBlock;
import java.io.File;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockBrewingStand;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockEnchantmentTable;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockHugeMushroom;
import net.minecraft.block.BlockIce;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockMelon;
import net.minecraft.block.BlockMycelium;
import net.minecraft.block.BlockPackedIce;
import net.minecraft.block.BlockPumpkin;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockRedstoneDiode;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.BlockStone;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.BlockWorkbench;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntityPolarBear;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.Logger;

public class Config {
    static Logger log;
    private static Configuration configLoading;
    private static File DIRECTORY;
    private static String NAME;
    private static Config INSTANCE;
    public final GENERAL GENERAL = new GENERAL();
    public final DOOR_BREAKING DOOR_BREAKING = new DOOR_BREAKING();
    public final IDLE_AI IDLE_AI = new IDLE_AI();
    public final FIDDLING FIDDLING = new FIDDLING();
    public final GRIEFING GRIEFING = new GRIEFING();
    public final REACT_AI REACT_AI = new REACT_AI();
    public final JOCKEYS JOCKEYS = new JOCKEYS();
    public final ELITE_AI ELITE_AI = new ELITE_AI();
    public final VILLAGES VILLAGES = new VILLAGES();

    public static Config get() {
        return INSTANCE;
    }

    public static void init(Logger logger, String fileName, File configDir) {
        if (DIRECTORY != null) {
            throw new IllegalStateException("Config has already been initialized");
        }
        log = logger;
        NAME = fileName;
        DIRECTORY = configDir;
    }

    public static void load() {
        if (DIRECTORY == null) {
            throw new IllegalStateException("Config folder must be set before loading configs");
        }
        log.info("Loading configs...");
        long startTime = System.nanoTime();
        configLoading = new Configuration(new File(DIRECTORY, NAME + ".cfg"));
        configLoading.load();
        INSTANCE = new Config();
        configLoading.save();
        configLoading = null;
        long estimatedTime = System.nanoTime() - startTime;
        log.info("Loaded configs in {} ms", (Object)((double)estimatedTime / 1000000.0));
    }

    private Config() {
    }

    private static abstract class PropertyCategory {
        static final double[] R_DBL_ALL = new double[]{Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY};
        static final double[] R_DBL_POS = new double[]{0.0, Double.POSITIVE_INFINITY};
        static final double[] R_DBL_ONE = new double[]{0.0, 1.0};
        static final float[] R_FLT_ALL = new float[]{Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY};
        static final float[] R_FLT_POS = new float[]{0.0f, Float.POSITIVE_INFINITY};
        static final float[] R_FLT_ONE = new float[]{0.0f, 1.0f};
        static final int[] R_INT_ALL = new int[]{Integer.MIN_VALUE, Integer.MAX_VALUE};
        static final int[] R_INT_TOKEN_NEG = new int[]{-1, Integer.MAX_VALUE};
        static final int[] R_INT_POS0 = new int[]{0, Integer.MAX_VALUE};
        static final int[] R_INT_POS1 = new int[]{1, Integer.MAX_VALUE};
        static final int[] R_INT_SRT_POS = new int[]{0, Short.MAX_VALUE};
        static final int[] R_INT_BYT_UNS = new int[]{0, 255};
        static final int[] R_INT_BYT_POS = new int[]{0, 127};
        protected final String KEY;

        PropertyCategory(String key) {
            this.KEY = key;
            configLoading.addCustomCategoryComment(this.name(), this.comment());
        }

        PropertyCategory() {
            this(null);
        }

        abstract String name();

        abstract String comment();

        double[] defaultDblRange() {
            return R_DBL_POS;
        }

        float[] defaultFltRange() {
            return R_FLT_POS;
        }

        int[] defaultIntRange() {
            return R_INT_POS0;
        }

        IBlockState prop(String key, IBlockState defaultValue, String comment) {
            String[] pair;
            String target = this.cprop(key, defaultValue, comment).getString();
            IBlockState blockState = TargetBlock.parseStateForMatch(target);
            if (blockState.func_177230_c() == Blocks.field_150350_a && (pair = target.split(" ", 2)).length > 1) {
                Block block = TargetBlock.getStringAsBlock(pair[0]);
                return block.func_176203_a(Integer.parseInt(pair[1].trim()));
            }
            return blockState;
        }

        Property cprop(String key, IBlockState defaultValue, String comment) {
            String defaultId = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)defaultValue.func_177230_c())).toString() + " " + defaultValue.func_177230_c().func_176201_c(defaultValue);
            comment = this.amendComment(comment, "Block", (Object)defaultId, "mod_id:block_id, mod_id:block_id[<properties>]");
            return configLoading.get(this.name(), key, defaultId, comment);
        }

        TargetBlock.TargetMap prop(String key, TargetBlock[] defaultValues, String comment) {
            return TargetBlock.newTargetDefinition(this.cprop(key, defaultValues, comment).getStringList());
        }

        Property cprop(String key, TargetBlock[] defaultValues, String comment) {
            Object[] defaultIds = new String[defaultValues.length];
            for (int i = 0; i < defaultIds.length; ++i) {
                defaultIds[i] = defaultValues[i].toString();
            }
            comment = this.amendComment(comment, "Block_Array", defaultIds, "mod_id:block_id, mod_id:block_id[<properties>], mod_id:*");
            return configLoading.get(this.name(), key, (String[])defaultIds, comment);
        }

        EntityListConfig prop(String key, EntryEntity[] defaultValues, String comment) {
            return new EntityListConfig(this.cprop(key, defaultValues, comment).getStringList());
        }

        Property cprop(String key, EntryEntity[] defaultValues, String comment) {
            Object[] defaultIds = new String[defaultValues.length];
            for (int i = 0; i < defaultIds.length; ++i) {
                defaultIds[i] = defaultValues[i].toString();
            }
            comment = this.amendComment(comment, "Entity_Array", defaultIds, "entity_id <extra_data>, ~entity_id <extra_data>");
            return configLoading.get(this.name(), key, (String[])defaultIds, comment);
        }

        boolean prop(String key, boolean defaultValue, String comment) {
            return this.cprop(key, defaultValue, comment).getBoolean();
        }

        Property cprop(String key, boolean defaultValue, String comment) {
            comment = this.amendComment(comment, "Boolean", (Object)defaultValue, new Object[]{true, false});
            return configLoading.get(this.name(), key, defaultValue, comment);
        }

        boolean[] prop(String key, boolean[] defaultValues, String comment) {
            return this.cprop(key, defaultValues, comment).getBooleanList();
        }

        Property cprop(String key, boolean[] defaultValues, String comment) {
            comment = this.amendComment(comment, "Boolean_Array", (Object[])ArrayUtils.toObject((boolean[])defaultValues), new Object[]{true, false});
            return configLoading.get(this.name(), key, defaultValues, comment);
        }

        int prop(String key, int defaultValue, String comment) {
            return this.cprop(key, defaultValue, comment).getInt();
        }

        int prop(String key, int defaultValue, String comment, int ... range) {
            return this.cprop(key, defaultValue, comment, range).getInt();
        }

        Property cprop(String key, int defaultValue, String comment) {
            return this.cprop(key, defaultValue, comment, this.defaultIntRange());
        }

        Property cprop(String key, int defaultValue, String comment, int ... range) {
            comment = this.amendComment(comment, "Integer", defaultValue, (Object)range[0], (Object)range[1]);
            return configLoading.get(this.name(), key, defaultValue, comment, range[0], range[1]);
        }

        int[] prop(String key, int[] defaultValues, String comment) {
            return this.cprop(key, defaultValues, comment).getIntList();
        }

        int[] prop(String key, int[] defaultValues, String comment, int ... range) {
            return this.cprop(key, defaultValues, comment, range).getIntList();
        }

        Property cprop(String key, int[] defaultValues, String comment) {
            return this.cprop(key, defaultValues, comment, this.defaultIntRange());
        }

        Property cprop(String key, int[] defaultValues, String comment, int ... range) {
            comment = this.amendComment(comment, "Integer_Array", ArrayUtils.toObject((int[])defaultValues), (Object)range[0], (Object)range[1]);
            return configLoading.get(this.name(), key, defaultValues, comment, range[0], range[1]);
        }

        float prop(String key, float defaultValue, String comment) {
            return (float)this.cprop(key, defaultValue, comment).getDouble();
        }

        float prop(String key, float defaultValue, String comment, float ... range) {
            return (float)this.cprop(key, defaultValue, comment, range).getDouble();
        }

        Property cprop(String key, float defaultValue, String comment) {
            return this.cprop(key, defaultValue, comment, this.defaultFltRange());
        }

        Property cprop(String key, float defaultValue, String comment, float ... range) {
            comment = this.amendComment(comment, "Float", Float.valueOf(defaultValue), (Object)Float.valueOf(range[0]), (Object)Float.valueOf(range[1]));
            return configLoading.get(this.name(), key, this.prettyFloatToDouble(defaultValue), comment, this.prettyFloatToDouble(range[0]), this.prettyFloatToDouble(range[1]));
        }

        double prop(String key, double defaultValue, String comment) {
            return this.cprop(key, defaultValue, comment).getDouble();
        }

        double prop(String key, double defaultValue, String comment, double ... range) {
            return this.cprop(key, defaultValue, comment, range).getDouble();
        }

        Property cprop(String key, double defaultValue, String comment) {
            return this.cprop(key, defaultValue, comment, this.defaultDblRange());
        }

        Property cprop(String key, double defaultValue, String comment, double ... range) {
            comment = this.amendComment(comment, "Double", defaultValue, (Object)range[0], (Object)range[1]);
            return configLoading.get(this.name(), key, defaultValue, comment, range[0], range[1]);
        }

        double[] prop(String key, double[] defaultValues, String comment) {
            return this.cprop(key, defaultValues, comment).getDoubleList();
        }

        double[] prop(String key, double[] defaultValues, String comment, double ... range) {
            return this.cprop(key, defaultValues, comment, range).getDoubleList();
        }

        Property cprop(String key, double[] defaultValues, String comment) {
            return this.cprop(key, defaultValues, comment, this.defaultDblRange());
        }

        Property cprop(String key, double[] defaultValues, String comment, double ... range) {
            comment = this.amendComment(comment, "Double_Array", ArrayUtils.toObject((double[])defaultValues), (Object)range[0], (Object)range[1]);
            return configLoading.get(this.name(), key, defaultValues, comment, range[0], range[1]);
        }

        String prop(String key, String defaultValue, String comment, String valueDescription) {
            return this.cprop(key, defaultValue, comment, valueDescription).getString();
        }

        String prop(String key, String defaultValue, String comment, String ... validValues) {
            return this.cprop(key, defaultValue, comment, validValues).getString();
        }

        Property cprop(String key, String defaultValue, String comment, String valueDescription) {
            comment = this.amendComment(comment, "String", (Object)defaultValue, valueDescription);
            return configLoading.get(this.name(), key, defaultValue, comment, new String[0]);
        }

        Property cprop(String key, String defaultValue, String comment, String ... validValues) {
            comment = this.amendComment(comment, "String", (Object)defaultValue, (Object[])validValues);
            return configLoading.get(this.name(), key, defaultValue, comment, validValues);
        }

        private String amendComment(String comment, String type, Object[] defaultValues, String description) {
            return this.amendComment(comment, type, (Object)("{ " + this.toReadable(defaultValues) + " }"), description);
        }

        private String amendComment(String comment, String type, Object[] defaultValues, Object min, Object max) {
            return this.amendComment(comment, type, "{ " + this.toReadable(defaultValues) + " }", min, max);
        }

        private String amendComment(String comment, String type, Object[] defaultValues, Object[] validValues) {
            return this.amendComment(comment, type, (Object)("{ " + this.toReadable(defaultValues) + " }"), validValues);
        }

        private String amendComment(String comment, String type, Object defaultValue, String description) {
            return comment + "\n   >> " + type + ":[ Value={ " + description + " }, Default=" + defaultValue + " ]";
        }

        private String amendComment(String comment, String type, Object defaultValue, Object min, Object max) {
            return comment + "\n   >> " + type + ":[ Range={ " + min + ", " + max + " }, Default=" + defaultValue + " ]";
        }

        private String amendComment(String comment, String type, Object defaultValue, Object[] validValues) {
            if (validValues.length < 2) {
                throw new IllegalArgumentException("Attempted to create config with no options!");
            }
            return comment + "\n   >> " + type + ":[ Valid_Values={ " + this.toReadable(validValues) + " }, Default=" + defaultValue + " ]";
        }

        private double prettyFloatToDouble(float f) {
            return Double.parseDouble(Float.toString(f));
        }

        private String toReadable(Object[] array) {
            if (array.length <= 0) {
                return "";
            }
            StringBuilder commentBuilder = new StringBuilder();
            for (Object value : array) {
                commentBuilder.append(value).append(", ");
            }
            return commentBuilder.substring(0, commentBuilder.length() - 2);
        }
    }

    public class VILLAGES
    extends PropertyCategory {
        private final int[] R_INT_VILLAGE_REP = new int[]{-30, 10};
        public final double BLOCK_ATTACK_CHANCE = this.prop("block_aggression_chance", 0.1, "Chance for you to be marked as an aggressor (to be attacked) when you break any block in a village\nthat is not on the \"block_blacklist\" while your reputation is low enough.");
        public final int BLOCK_ATTACK_LIMIT = this.prop("block_aggression_limit", -5, "The \"block_aggression_chance\" and \"block_treasured_aggression_chance\" only trigger if your reputation\nin the village is less than or equal to this limit.", this.R_INT_VILLAGE_REP);
        public final TargetBlock.TargetMap BLOCK_BLACKLIST = this.prop("block_blacklist", this.buildDefaultBlacklistTargets(), "Specific blocks that will NOT anger villagers when broken.");
        public final double BLOCK_REP_CHANCE = this.prop("block_rep_loss_chance", 0.15, "Chance for you to lose 1 reputation when you break any block in a village that is not on the\n\"block_blacklist\" while your reputation is low enough.");
        public final int BLOCK_REP_LIMIT = this.prop("block_rep_loss_limit", 8, "The \"block_rep_loss_chance\" and \"block_treasured_rep_loss_chance\" only trigger if your reputation\nin the village is equal to or less than this limit.", this.R_INT_VILLAGE_REP);
        public final double TREASURED_ATTACK_CHANCE = this.prop("block_treasured_aggression_chance", 1.0, "Chance for you to be marked as an aggressor (to be attacked) when you break a block in a village that\nis on the \"block_treasured_list\" while your reputation is low enough.");
        public final TargetBlock.TargetMap TREASURED_LIST = this.prop("block_treasured_list", new TargetBlock[]{new TargetBlock(Blocks.field_150475_bE), new TargetBlock(Blocks.field_150342_X), new TargetBlock(Blocks.field_150458_ak), new TargetBlock(Blocks.field_150414_aQ)}, "Specific blocks that use separate chances for aggression and rep loss from other blocks.");
        public final double TREASURED_REP_CHANCE = this.prop("block_treasured_rep_loss_chance", 1.0, "Chance for you to lose 1 reputation when you break a block in a village that is on the \"block_treasured_list\"\nwhile your reputation is low enough.");
        public final TargetBlock.TargetMap BLOCK_WHITELIST = this.prop("block_whitelist", new TargetBlock[0], "Specific blocks that WILL aggro villagers when broken. If any blocks are specified here, they will\nthen be the only blocks that anger villagers (i.e., trigger reputation loss and aggression).");
        public final boolean COMMAND_INCLUDE_CENTER = this.prop("command_include_center", true, "If true, the \"/villageinfo\" command will state the village center position.\nAs the command has unlimited search radius, disable this to prevent players from using the command\nto easily find the nearest village.");
        public final double HELP_REP_CHANCE = this.prop("help_rep_chance", 0.2, "Chance for you to earn 1 reputation for each monster killed near a village. The only reasonable way\nto restore rep from -15 or lower with \"villagers_defend\" enabled.");
        public final boolean HOUSE_REP = this.prop("house_rep", true, "If true, all players known to a village will gain 1 rep when a new house is added to a village and\nlose 1 rep when a house is lost. Highly recommended to keep \"refresh_houses\" enabled when this is.");
        public final boolean NAME_VILLAGERS = this.prop("name_villagers", true, "If true, all villagers will spawn with randomized names based on their profession and career.");
        public final boolean NAME_VILLAGERS_ALWAYS_SHOW = this.prop("name_villagers_always_show", true, "If true, villager names will be marked as 'always shown' so that you do not need to mouse over them\nto see their names. Also makes them a little easier to keep track of.");
        public final boolean REFRESH_HOUSES = this.prop("refresh_houses", true, "If true, houses will stay a part of a village permanently once added (until their doors are destroyed\nor all villagers in the village are killed), instead of being constantly added/removed as villagers move around.");
        public final boolean REPUTATION_PARTICLES = this.prop("reputation_particles", true, "If true, particle effects will play when players lose or gain village reputation.");
        public final boolean REPUTATION_SOUNDS = this.prop("reputation_sounds", true, "If true, villager sound effects will play when players lose or gain village reputation.");
        public final boolean VILLAGERS_DEFEND = this.prop("villagers_defend", true, "If true, villagers will defend their village by attacking its aggressors and players with\n'hated' standing (reputation <= -15), just like their iron golems do in vanilla.");

        @Override
        public String name() {
            return "villages";
        }

        @Override
        protected String comment() {
            return "Options to control village aggression and reputation.\nFor reference, starting reputation is 0, minimum is -30 and maximum is 10.\nYou are considered an enemy to a village if your reputation is -15 or lower.";
        }

        @Override
        double[] defaultDblRange() {
            return PropertyCategory.R_DBL_ONE;
        }

        private TargetBlock[] buildDefaultBlacklistTargets() {
            ArrayList<TargetBlock> targets = new ArrayList<TargetBlock>();
            for (Block block : Block.field_149771_c) {
                if (block instanceof BlockGrass || block instanceof BlockMycelium || block instanceof BlockStone || block instanceof BlockDirt || block instanceof BlockSand || block instanceof BlockPumpkin || block instanceof BlockMelon || block instanceof BlockHugeMushroom || block instanceof BlockSnow || block instanceof BlockIce || block instanceof BlockPackedIce) {
                    targets.add(new TargetBlock(block));
                    continue;
                }
                if (block instanceof IGrowable || block instanceof IPlantable || block instanceof IShearable) {
                    targets.add(new TargetBlock(block));
                    continue;
                }
                if (block instanceof BlockRailBase || block instanceof BlockShulkerBox) {
                    targets.add(new TargetBlock(block));
                    continue;
                }
                if (block instanceof BlockDoor || block instanceof BlockFenceGate) {
                    targets.add(new TargetBlock(block));
                    continue;
                }
                if (block == Blocks.field_150350_a) continue;
                try {
                    if (block.func_176223_P().func_185887_b(null, BlockPos.field_177992_a) != 0.0f || block.func_176223_P().func_185906_d() >= 4) continue;
                    targets.add(new TargetBlock(block));
                }
                catch (Exception exception) {}
            }
            return targets.toArray(new TargetBlock[0]);
        }
    }

    public class ELITE_AI
    extends PropertyCategory {
        public final EntityListConfig MOB_LIST = this.prop("_mob_list", new EntryEntity[]{new EntryEntity(EntityZombie.class, 0.05f, 0.05f), new EntryEntity(EntitySkeleton.class, 0.2f, 0.05f), new EntryEntity(EntityPigZombie.class, 0.1f, 0.05f, 0.02f)}, "List of mobs that can gain special AI patterns and their chances to gain those patterns.\nYou can specify multiple chances for each entity - each chance will be rolled and multiple AIs can stack.\nNote that the entity must have task-based AI enabled.");
        public final int AI_WEIGHT_TOTAL;
        public final double BARRAGE_HEALTH_BOOST;
        public final double CHARGE_HEALTH_BOOST;
        public final double CHARGE_KNOCKBACK_RESISTANCE;
        public final double LEAP_SPEED_BOOST;
        public final float SHAMAN_HEAL_AMOUNT;
        public final double SHAMAN_HEALTH_BOOST;
        public final double SPAWNER_HEALTH_BOOST;
        public final double SPAWNER_SPEED_BOOST;
        public final double SPRINT_BOOTS_SPEED_BOOST;
        public final float SPRINT_SPEED_BOOST;
        public final float THIEF_AVOID_RANGE;
        public final double THIEF_HELMET_SPEED_BOOST;
        public final double THROW_SPEED_BOOST;
        public final double THROW_PLAYER_HEALTH_BOOST;
        public final double THROW_PLAYER_HELMET_DAMAGE;
        public final double THROW_PLAYER_KNOCKBACK_RESISTANCE;

        public ELITE_AI() {
            int weightTotal = 0;
            for (IEliteAI ai : EliteAIHandler.ELITE_AI_LIST) {
                ai.setWeight(Math.max(0, this.prop("ai_" + ai.getName(), 1, "Weight for the " + ai.getName() + " ai pattern to be chosen.")));
                weightTotal += ai.getWeight();
            }
            this.AI_WEIGHT_TOTAL = weightTotal;
            this.BARRAGE_HEALTH_BOOST = this.prop("barrage_health_boost", 20.0, "Flat health increase added to mobs with barrage ai.", PropertyCategory.R_DBL_ALL);
            this.CHARGE_HEALTH_BOOST = this.prop("charge_health_boost", 20.0, "Flat health increase added to mobs with charge ai.", PropertyCategory.R_DBL_ALL);
            this.CHARGE_KNOCKBACK_RESISTANCE = this.prop("charge_knockback_resistance", 0.5, "Knockback resistance added to mobs with charge ai.");
            this.LEAP_SPEED_BOOST = this.prop("leap_speed_boost", 0.1, "Speed increase multiplier to mobs with leap ai. Recommended to keep this well below 0.5.", PropertyCategory.R_DBL_ALL);
            this.SHAMAN_HEAL_AMOUNT = this.prop("shaman_heal_amount", 1.0f, "Amount (in half-hearts) healed by mobs with shaman ai every 2 seconds. Can be overridden by the mob's nbt data.", PropertyCategory.R_FLT_ALL);
            this.SHAMAN_HEALTH_BOOST = this.prop("shaman_health_boost", 20.0, "Flat health increase added to mobs with shaman ai.", PropertyCategory.R_DBL_ALL);
            this.SPAWNER_HEALTH_BOOST = this.prop("spawner_health_boost", 40.0, "Flat health increase added to mobs with spawner ai.", PropertyCategory.R_DBL_ALL);
            this.SPAWNER_SPEED_BOOST = this.prop("spawner_speed_boost", -0.2, "Speed increase multiplier to mobs with spawner ai. Recommended to keep this well below 0.5.", PropertyCategory.R_DBL_ALL);
            this.SPRINT_BOOTS_SPEED_BOOST = this.prop("sprint_boots_speed_boost", 0.1, "Speed increase multiplier to the boots worn by mobs with sprint ai (these can drop as loot!).\nRecommended to keep this well below 0.5.", PropertyCategory.R_DBL_POS);
            this.SPRINT_SPEED_BOOST = this.prop("sprint_speed_boost", 0.7f, "Speed increase multiplier to mobs with sprint ai while they are sprinting. Can be overridden by the mob's nbt data.\nSetting this to 0 breaks the sprint ai, so don't do that.", PropertyCategory.R_FLT_POS);
            this.THIEF_AVOID_RANGE = this.prop("thief_avoid_range", 16.0f, "The minimum distance that mobs with thief ai will try to keep from players once they have stolen an item.\nCan be overridden by the mob's nbt data.", 1.0f, Float.POSITIVE_INFINITY);
            this.THIEF_HELMET_SPEED_BOOST = this.prop("thief_helmet_speed_boost", 0.1, "Speed increase multiplier to the helmet worn by mobs with thief ai (these can drop as loot!).\nRecommended to keep this well below 0.5.", PropertyCategory.R_DBL_POS);
            this.THROW_SPEED_BOOST = this.prop("throw_speed_boost", 0.1, "Speed increase multiplier to mobs with throw ai. Recommended to keep this well below 0.5.", PropertyCategory.R_DBL_ALL);
            this.THROW_PLAYER_HEALTH_BOOST = this.prop("throw_player_health_boost", 20.0, "Flat health increase added to mobs with throw-player ai.", PropertyCategory.R_DBL_ALL);
            this.THROW_PLAYER_HELMET_DAMAGE = this.prop("throw_player_helmet_damage_boost", 1.0, "Flat damage increase added to the helmet worn by mobs with throw-player ai (these can drop as loot!).", PropertyCategory.R_DBL_POS);
            this.THROW_PLAYER_KNOCKBACK_RESISTANCE = this.prop("throw_player_knockback_resistance", 0.5, "Knockback resistance added to mobs with throw-player ai.");
        }

        @Override
        public String name() {
            return "elite_ai";
        }

        @Override
        protected String comment() {
            return "Options to control the types of elite AI and their weighted chances of occurring.";
        }

        @Override
        protected double[] defaultDblRange() {
            return PropertyCategory.R_DBL_ONE;
        }
    }

    public class JOCKEYS
    extends PropertyCategory {
        public final EntityListConfig MOUNT_LIST = this.prop("mount_list", new EntryEntity[]{new EntryEntity(EntitySpider.class, true, new float[0]), new EntryEntity(EntitySlime.class, true, new float[0]), new EntryEntity(EntityPig.class, true, new float[0]), new EntryEntity(EntitySheep.class, true, new float[0]), new EntryEntity(EntityCow.class, true, new float[0]), new EntryEntity(EntityPolarBear.class, true, new float[0])}, "List of mobs that can be ridden on by normal-sized riders (not all entities can be controlled by their rider).");
        public final EntityListConfig MOUNT_LIST_SMALL = this.prop("mount_list_small", new EntryEntity[]{new EntryEntity(EntityChicken.class, true, new float[0]), new EntryEntity(EntityRabbit.class, true, new float[0])}, "List of mobs that can be ridden on by small riders or normal-sized riders that are babies(not all entities can be controlled by their rider).");
        public final EntityListConfig RIDER_LIST = this.prop("rider_list", new EntryEntity[]{new EntryEntity(EntityZombie.class, 0.05f), new EntryEntity(EntitySkeleton.class, 0.1f), new EntryEntity(EntityCreeper.class, 0.05f), new EntryEntity(EntityWitch.class, 0.05f), new EntryEntity(EntityPigZombie.class, 0.1f)}, "List of mobs that can ride normal-sized mounts and the chance for them to gain the rider AI.\nNote that the entity must have task-based AI enabled.");
        public final EntityListConfig RIDER_LIST_SMALL = this.prop("rider_list_small", new EntryEntity[0], "List of mobs that can only ride small mounts or normal-sized mounts that are babies and the chance for them to gain the rider AI.\nNote that the entity must have task-based AI enabled.");

        @Override
        public String name() {
            return "jockeys";
        }

        @Override
        protected String comment() {
            return "Options relating to which mobs should act as riders or mounts.";
        }
    }

    public class REACT_AI
    extends PropertyCategory {
        public final boolean AVOID_EXPLOSIONS = this.prop("avoid_explosions", true, "If true, all mobs will try to avoid TNT and creepers that are about to explode.");
        public final boolean CALL_HELP = this.prop("call_for_help", true, "If true, all mobs will call for help from nearby mobs of the same type when struck.\nNote that this does not trigger from killing blows.");
        public final double CALL_HELP_ON_DEATH = this.prop("call_for_help_on_death", 0.2, "Chance for mobs to call for help when dealt a killing blow.");
        public final double DODGE_ARROWS = this.prop("dodge_arrows", 0.4, "The chance any mob will try to sidestep an arrow fired in their direction.");

        @Override
        public String name() {
            return "reaction_ai";
        }

        @Override
        protected String comment() {
            return "Options to customize reactive behaviors.";
        }

        @Override
        protected double[] defaultDblRange() {
            return PropertyCategory.R_DBL_ONE;
        }
    }

    public class GRIEFING
    extends PropertyCategory {
        public final boolean ENABLED = this.prop("_enabled", true, "If true, mobs will destroy blocks while not doing anything else.");
        public final boolean BREAK_LIGHTS = this.prop("break_lights", true, "If true, block breaking AI will automatically target all light sources (light value > 1).");
        public final boolean BREAK_SOUND = this.prop("break_sound", false, "If true, a lound snapping sound (the vanilla door break sound) will be played when a block\nis broken, which is audible regardless of distance.");
        public final float BREAK_SPEED = this.prop("break_speed", 0.5f, "The block breaking speed multiplier for mobs, relative to the player's block breaking speed.");
        public final boolean LEAVE_DROPS = this.prop("leave_drops", true, "If true, griefed blocks will leave item drops.");
        public final boolean MAD_CREEPERS = this.prop("mad_creepers", true, "If true, creepers will be very mad about not having arms to break things with, and resort to what they know best...");
        public final EntityListConfig MOB_LIST = this.prop("mob_list", new EntryEntity[]{new EntryEntity(EntityZombie.class, 1.0f), new EntryEntity(EntityCreeper.class, 1.0f), new EntryEntity(EntityPigZombie.class, 1.0f)}, "List of mobs that can gain passive griefing AI (note that the entity must have task-based AI enabled).\nThe number after each mob is the chance for that mob type to get the AI, from 0 to 1.");
        public final boolean REQUIRES_TOOLS = this.prop("requires_tools", false, "If true, mobs will only target blocks they have the tools to harvest.\nFor example, they will only break stone with a pickaxe.");
        public final TargetBlock.TargetMap BLACK_LIST = this.prop("target_blacklist", new TargetBlock[0], "Specific blocks that will NOT be griefed by mobs.\nOnly really useful if \"break_lights\" is enabled or when you whitelist an entire namespace (*) to create safe\nlight sources, prevent mobs from breaking normal world gen that produces light, or for removing a few blocks\nfrom a namespace that you don't want mobs to break.");
        public final TargetBlock.TargetMap TARGET_LIST = this.prop("target_blocks", this.buildDefaultGriefTargets(), "Specific blocks that will be griefed by mobs.");
        public final TargetBlock.TargetMap TARGET_LOOTABLE = this.prop("target_lootable", this.buildDefaultGriefTargetsLootable(), "Specific lootable blocks that will be griefed by mobs.\nUnlike the normal \"target_blocks\", these blocks will not be targeted if they still have a loot table tag\n(e.g., unopened dungeon chests).");

        @Override
        public String name() {
            return "idle_griefing";
        }

        @Override
        protected String comment() {
            return "Options to customize monsters' idle block breaking.";
        }

        private TargetBlock[] buildDefaultGriefTargets() {
            ArrayList<TargetBlock> targets = new ArrayList<TargetBlock>();
            for (Block block : Block.field_149771_c) {
                if (block instanceof BlockBed) {
                    targets.add(new TargetBlock(block));
                    continue;
                }
                if (block instanceof BlockWorkbench || block instanceof BlockFurnace || block instanceof BlockEnchantmentTable || block instanceof BlockBrewingStand) {
                    targets.add(new TargetBlock(block));
                    continue;
                }
                if (block instanceof BlockLadder) {
                    targets.add(new TargetBlock(block));
                    continue;
                }
                if (block != Blocks.field_150458_ak && block != Blocks.field_150318_D) continue;
                targets.add(new TargetBlock(block));
            }
            return targets.toArray(new TargetBlock[0]);
        }

        private TargetBlock[] buildDefaultGriefTargetsLootable() {
            ArrayList<TargetBlock> targets = new ArrayList<TargetBlock>();
            for (Block block : Block.field_149771_c) {
                if (!(block instanceof BlockChest)) continue;
                targets.add(new TargetBlock(block));
            }
            return targets.toArray(new TargetBlock[0]);
        }
    }

    public class FIDDLING
    extends PropertyCategory {
        public final boolean ENABLED = this.prop("_enabled", true, "If true, mobs will flip switches, press buttons, etc. while not doing anything else.");
        public final EntityListConfig MOB_LIST = this.prop("mob_list", new EntryEntity[]{new EntryEntity(EntitySkeleton.class, 1.0f), new EntryEntity(EntityPigZombie.class, 1.0f)}, "List of mobs that can gain idle fiddling AI (note that the entity must have task-based AI enabled).\nThe number after each mob is the chance for that mob type to get the AI, from 0 to 1.");
        public final TargetBlock.TargetMap BLACK_LIST = this.prop("target_blacklist", new TargetBlock[0], "Specific blocks that will NOT be fiddled with by mobs.\nOnly really useful if you whitelist an entire namespace (*) to prevent mobs from fiddling with a few blocks from that namespace.");
        public final TargetBlock.TargetMap TARGET_LIST = this.prop("target_blocks", this.buildDefaultFiddleTargets(), "Specific blocks that will be fiddled with by mobs.");

        @Override
        public String name() {
            return "idle_fiddling";
        }

        @Override
        protected String comment() {
            return "Options to customize monsters' idle fiddling behavior.";
        }

        private TargetBlock[] buildDefaultFiddleTargets() {
            ArrayList<TargetBlock> targets = new ArrayList<TargetBlock>();
            for (Block block : Block.field_149771_c) {
                if (block instanceof BlockLever || block instanceof BlockButton || block instanceof BlockRedstoneDiode) {
                    targets.add(new TargetBlock(block));
                    continue;
                }
                if (block instanceof BlockDoor || block instanceof BlockFenceGate) {
                    if (block.func_176223_P().func_185904_a() == Material.field_151573_f) continue;
                    targets.add(new TargetBlock(block));
                    continue;
                }
                if (block != Blocks.field_150335_W && block != Blocks.field_150414_aQ) continue;
                targets.add(new TargetBlock(block));
            }
            return targets.toArray(new TargetBlock[0]);
        }
    }

    public class IDLE_AI
    extends PropertyCategory {
        public final float REACH = this.prop("reach", 3.5f, "Mobs' reach (from eye height) when targeting blocks. Player reach is about 4.5.");
        public final int RANGE_XZ = this.prop("range", 12, "The range at which mobs will search for blocks to target horizontally (xz-plane).", PropertyCategory.R_INT_POS1);
        public final int RANGE_Y = this.prop("range_vertical", 6, "The range at which mobs will search for blocks to target vertically (y-axis).", PropertyCategory.R_INT_POS1);
        public final int SCAN_COUNT = this.prop("scan_count", 32, "The number of blocks each mob randomly searches to grief/fiddle with every \"scan_delay\" ticks.", PropertyCategory.R_INT_POS1);
        public final int SCAN_COUNT_GLOBAL = this.prop("scan_count_global", 0, "The maximum number of blocks that can be searched in any given tick by all mobs. 0 is no limit.");
        public final int SCAN_DELAY = this.prop("scan_delay", 2, "The number of ticks between each block scan.", PropertyCategory.R_INT_POS1);

        @Override
        public String name() {
            return "idle_activities";
        }

        @Override
        protected String comment() {
            return "Options to customize all idle behaviors for monsters (fiddling/griefing).";
        }
    }

    public class DOOR_BREAKING
    extends PropertyCategory {
        public final boolean ENABLED = this.prop("_enabled", true, "If true, mobs will destroy doors that are blocking their path.");
        public final float BREAK_SPEED = this.prop("break_speed", 0.33f, "The block breaking speed multiplier for mobs, relative to the player's block breaking speed.");
        public final boolean LEAVE_DROPS = this.prop("leave_drops", true, "If true, broken blocks will leave item drops.");
        public final boolean MAD_CREEPERS = this.prop("mad_creepers", true, "If true, creepers will be very mad about not having arms to break things with, and resort to what they know best...");
        public final EntityListConfig MOB_LIST = this.prop("mob_list", new EntryEntity[]{new EntryEntity(EntityZombie.class, 1.0f), new EntryEntity(EntityCreeper.class, 1.0f), new EntryEntity(EntityPigZombie.class, 1.0f)}, "List of mobs that can gain door-breaking AI (note that the entity must have task-based AI enabled).\nThe number after each mob is the chance for that mob type to get the AI, from 0 to 1.");
        public final boolean REQUIRES_TARGET = this.prop("requires_target", true, "If true, mobs will only break doors while they are chasing an attack target.\nSetting this to false typically leads to mobs smashing into your house to get to blocks they are targeting\nas part of an idle griefing or fiddling behavior, such as torches or chests.");
        public final boolean REQUIRES_TOOLS = this.prop("requires_tools", true, "If true, mobs will only target blocks they have the tools to harvest.\nFor example, they will only break iron doors with a pickaxe.");
        public final TargetBlock.TargetMap TARGET_LIST = this.prop("target_blocks", this.buildDefaultDoorTargets(), "Door blocks that can be broken by mobs chasing you.");

        @Override
        public String name() {
            return "door_breaking";
        }

        @Override
        protected String comment() {
            return "Options to customize monsters' door-breaking behavior.";
        }

        private TargetBlock[] buildDefaultDoorTargets() {
            ArrayList<TargetBlock> targets = new ArrayList<TargetBlock>();
            for (Block block : Block.field_149771_c) {
                if (!(block instanceof BlockDoor) && !(block instanceof BlockFenceGate) && !(block instanceof BlockTrapDoor)) continue;
                targets.add(new TargetBlock(block));
            }
            return targets.toArray(new TargetBlock[0]);
        }
    }

    public class GENERAL
    extends PropertyCategory {
        public final boolean DEBUG = this.prop("_debug_mode", false, "If true, the mod will start up in debug mode.");
        public final double AGGRESSIVE_CHANCE = this.prop("depacify_aggressive_chance", 0.0, "Chance for an entity on the depacify list to spawn aggressive, instead of just neutral.", PropertyCategory.R_DBL_ONE);
        public final EntityListConfig DEPACIFY_LIST = this.prop("depacify_list", new EntryEntity[]{new EntryEntity(EntityChicken.class, 1.0f), new EntryEntity(EntityCow.class, 1.0f), new EntryEntity(EntityPig.class, 1.0f), new EntryEntity(EntitySheep.class, 1.0f), new EntryEntity(EntityRabbit.class, 1.0f), new EntryEntity(EntitySquid.class, 1.0f)}, "List of passive mobs (by entity id) that are made \"neutral\" like wolves.\nYou may put a tilde (~) in front of any entity id to make it specific; specific entity ids\nwill not count any entities extending (i.e., based on) the specified entity.\nAdditional number after the entity id is the chance (0.0 to 1.0) for entities of that type to spawn with the AI.\nMay or may not work on mod mobs.");
        public final boolean EAT_BREEDING_ITEMS = this.prop("eat_breeding_items", true, "If true, passive mobs will seek out and eat the items used to breed them laying on the floor.");
        public final boolean EATING_HEALS = this.prop("eating_heals", true, "If true, when mobs eat breeding items off the floor, they will regain health like wolves.");

        @Override
        String name() {
            return "_general";
        }

        @Override
        String comment() {
            return "General and/or miscellaneous options.";
        }
    }
}

