/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialai.ai.elite;

import fathertoast.specialai.ai.elite.IEliteAI;
import fathertoast.specialai.config.Config;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;

public class EntityAIThrow
extends EntityAIBase
implements IEliteAI {
    private static double SPEED_TO_THROW_TARGET = 1.3;
    private static double SPEED_TO_TARGET = 1.1;
    private int WEIGHT;
    protected EntityLiving theEntity;
    private EntityLiving throwTarget;
    private int attackTime;
    private int giveUpDelay;

    EntityAIThrow() {
    }

    private EntityAIThrow(EntityLiving entity) {
        this.theEntity = entity;
        this.func_75248_a(3);
    }

    @Override
    public String getName() {
        return "throw";
    }

    @Override
    public int getWeight() {
        return this.WEIGHT;
    }

    @Override
    public void setWeight(int weight) {
        this.WEIGHT = weight;
    }

    @Override
    public void addTo(EntityLiving entity, NBTTagCompound aiTag) {
        entity.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIThrow(entity));
    }

    @Override
    public void save(NBTTagCompound aiTag) {
        aiTag.func_74774_a(this.getName(), (byte)1);
    }

    @Override
    public boolean isSaved(NBTTagCompound aiTag) {
        return aiTag.func_74771_c(this.getName()) > 0;
    }

    @Override
    public void initialize(EntityLiving entity) {
        entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(new AttributeModifier(UUID.randomUUID(), "Thrower speed boost", Config.get().ELITE_AI.THROW_SPEED_BOOST, 1));
    }

    public boolean func_75250_a() {
        EntityLivingBase target = this.theEntity.func_70638_az();
        if (this.attackTime-- > 0 || target == null || this.theEntity.func_184218_aH()) {
            return false;
        }
        if (this.theEntity.func_184207_aI()) {
            return true;
        }
        if (this.theEntity.func_70681_au().nextInt(20) == 0) {
            return this.findThrowTarget();
        }
        return false;
    }

    public void func_75249_e() {
        if (this.throwTarget != null) {
            this.theEntity.func_70661_as().func_75497_a((Entity)this.throwTarget, SPEED_TO_THROW_TARGET);
        } else {
            EntityLivingBase entity = this.theEntity.func_70638_az();
            if (entity != null) {
                this.theEntity.func_70661_as().func_75497_a((Entity)entity, SPEED_TO_TARGET);
            }
        }
    }

    public boolean func_75253_b() {
        return this.theEntity.func_70638_az() != null && !this.theEntity.func_184218_aH() && (this.throwTarget != null && this.throwTarget.func_70089_S() || this.theEntity.func_184207_aI());
    }

    public boolean func_75252_g() {
        return false;
    }

    public void func_75246_d() {
        EntityLivingBase target = this.theEntity.func_70638_az();
        if (target == null) {
            return;
        }
        if (this.throwTarget != null) {
            this.theEntity.func_70671_ap().func_75651_a((Entity)this.throwTarget, 30.0f, 30.0f);
            double range = this.theEntity.field_70130_N * 2.0f * this.theEntity.field_70130_N * 2.0f + this.throwTarget.field_70130_N;
            if (this.theEntity.func_70092_e(this.throwTarget.field_70165_t, this.throwTarget.func_174813_aQ().field_72338_b, this.throwTarget.field_70161_v) <= range) {
                this.throwTarget.func_184205_a((Entity)this.theEntity, true);
                this.throwTarget = null;
                this.theEntity.func_70661_as().func_75497_a((Entity)target, SPEED_TO_TARGET);
                this.theEntity.func_184609_a(EnumHand.MAIN_HAND);
                this.theEntity.func_184609_a(EnumHand.OFF_HAND);
                this.attackTime = 20;
            } else if (this.theEntity.func_70661_as().func_75500_f()) {
                this.theEntity.func_70661_as().func_75497_a((Entity)this.throwTarget, SPEED_TO_THROW_TARGET);
            }
        }
        if (this.theEntity.func_184207_aI()) {
            this.theEntity.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
            if (this.attackTime-- <= 0 && this.theEntity.func_70681_au().nextInt(10) == 0 && this.theEntity.func_70068_e((Entity)target) <= 100.0) {
                double dX = target.field_70165_t - this.theEntity.field_70165_t;
                double dZ = target.field_70161_v - this.theEntity.field_70161_v;
                double dH = Math.sqrt(dX * dX + dZ * dZ);
                Entity entity = (Entity)this.theEntity.func_184188_bt().get(0);
                entity.func_184210_p();
                entity.field_70159_w = dX / dH + this.theEntity.field_70159_w * 0.2;
                entity.field_70179_y = dZ / dH + this.theEntity.field_70179_y * 0.2;
                entity.field_70181_x = 0.4;
                entity.field_70122_E = false;
                entity.field_70143_R = 0.0f;
                this.theEntity.func_70661_as().func_75499_g();
                this.theEntity.func_184609_a(EnumHand.MAIN_HAND);
                this.theEntity.func_184609_a(EnumHand.OFF_HAND);
                this.attackTime = 40 + this.theEntity.func_70681_au().nextInt(41);
            } else if (this.theEntity.func_70661_as().func_75500_f()) {
                this.theEntity.func_70661_as().func_75497_a((Entity)target, SPEED_TO_TARGET);
            }
        }
        if (++this.giveUpDelay > 400) {
            this.theEntity.func_70661_as().func_75499_g();
            this.throwTarget = null;
        }
    }

    public void func_75251_c() {
        if (this.theEntity.func_184207_aI()) {
            ((Entity)this.theEntity.func_184188_bt().get(0)).func_184210_p();
        }
        this.theEntity.func_70661_as().func_75499_g();
        this.giveUpDelay = 0;
        this.throwTarget = null;
    }

    private boolean findThrowTarget() {
        EntityLivingBase target = this.theEntity.func_70638_az();
        if (target == null) {
            return false;
        }
        double distance = this.theEntity.func_70068_e((Entity)target);
        if (distance < 9.0) {
            return false;
        }
        List list = this.theEntity.field_70170_p.func_72839_b((Entity)this.theEntity, this.theEntity.func_174813_aQ().func_72321_a(16.0, 8.0, 16.0));
        for (Object obj : list) {
            double dist;
            if (!(obj instanceof EntityLiving)) continue;
            EntityLiving entity = (EntityLiving)obj;
            if (!entity.field_70122_E || entity.func_184218_aH() || target != entity.func_70638_az() || entity.func_70068_e((Entity)target) <= 36.0 || !((dist = this.theEntity.func_70068_e((Entity)entity)) < distance)) continue;
            distance = dist;
            this.throwTarget = entity;
        }
        return this.throwTarget != null;
    }
}

