/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialai.ai.elite;

import fathertoast.specialai.ai.elite.IEliteAI;
import fathertoast.specialai.config.Config;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityAISpawner
extends EntityAIBase
implements IEliteAI {
    private static final NBTTagCompound SPAWNER_TAG = new NBTTagCompound();
    private int WEIGHT;
    public EntityLiving theEntity;
    private MobSpawnerBaseLogic mobSpawnerLogic;

    EntityAISpawner() {
    }

    private EntityAISpawner(EntityLiving entity, NBTTagCompound spawnerTag) {
        this.theEntity = entity;
        this.mobSpawnerLogic = new MobSpawnerAILogic(entity);
        if (spawnerTag != null) {
            this.mobSpawnerLogic.func_98270_a(spawnerTag);
        } else {
            this.mobSpawnerLogic.func_98270_a(SPAWNER_TAG);
            String entityId = EntityList.func_75621_b((Entity)entity);
            if (entityId == null) {
                entityId = "";
            }
            this.mobSpawnerLogic.func_190894_a(new ResourceLocation(entityId));
        }
        this.func_75248_a(0);
    }

    @Override
    public String getName() {
        return "spawner";
    }

    @Override
    public int getWeight() {
        return this.WEIGHT;
    }

    @Override
    public void setWeight(int weight) {
        this.WEIGHT = weight;
    }

    @Override
    public void addTo(EntityLiving entity, NBTTagCompound aiTag) {
        NBTTagCompound spawnerTag = aiTag.func_74764_b(this.getName() + "Tags") ? aiTag.func_74775_l(this.getName() + "Tags") : null;
        entity.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISpawner(entity, spawnerTag));
    }

    @Override
    public void save(NBTTagCompound aiTag) {
        aiTag.func_74774_a(this.getName(), (byte)1);
    }

    @Override
    public boolean isSaved(NBTTagCompound aiTag) {
        return aiTag.func_74771_c(this.getName()) > 0;
    }

    @Override
    public void initialize(EntityLiving entity) {
        entity.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(Blocks.field_150474_ac));
        entity.func_184642_a(EntityEquipmentSlot.HEAD, 0.0f);
        entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(new AttributeModifier(UUID.randomUUID(), "Spawner speed boost", Config.get().ELITE_AI.SPAWNER_SPEED_BOOST, 1));
        entity.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier(UUID.randomUUID(), "Spawner health boost", Config.get().ELITE_AI.SPAWNER_HEALTH_BOOST, 0));
    }

    public boolean func_75250_a() {
        EntityLivingBase target = this.theEntity.func_70638_az();
        return target != null && this.theEntity.func_70635_at().func_75522_a((Entity)target);
    }

    public boolean func_75253_b() {
        return this.func_75250_a();
    }

    public void func_75246_d() {
        this.mobSpawnerLogic.func_98278_g();
    }

    static {
        MobSpawnerAILogic spawnLogic = new MobSpawnerAILogic(null);
        spawnLogic.func_190894_a(new ResourceLocation("Pig"));
        spawnLogic.func_189530_b(SPAWNER_TAG);
        SPAWNER_TAG.func_82580_o("SpawnPotentials");
        SPAWNER_TAG.func_74777_a("Delay", (short)20);
        SPAWNER_TAG.func_74777_a("MinSpawnDelay", (short)150);
        SPAWNER_TAG.func_74777_a("MaxSpawnDelay", (short)600);
        SPAWNER_TAG.func_74777_a("SpawnCount", (short)4);
        SPAWNER_TAG.func_74777_a("MaxNearbyEntities", (short)7);
        SPAWNER_TAG.func_74777_a("RequiredPlayerRange", (short)16);
        SPAWNER_TAG.func_74777_a("SpawnRange", (short)4);
    }

    private static class MobSpawnerAILogic
    extends MobSpawnerBaseLogic {
        private EntityLiving theEntity;
        protected short aiSpawnRange;

        public MobSpawnerAILogic(EntityLiving entity) {
            this.theEntity = entity;
        }

        public World func_98271_a() {
            return this.theEntity.field_70170_p;
        }

        public BlockPos func_177221_b() {
            return new BlockPos(this.theEntity.field_70165_t, this.theEntity.field_70163_u + (double)this.theEntity.func_70047_e(), this.theEntity.field_70161_v);
        }

        public void func_98267_a(int id) {
            if (id == 1) {
                for (Entity entity : this.theEntity.field_70170_p.func_72839_b((Entity)this.theEntity, this.theEntity.func_174813_aQ().func_72321_a((double)this.aiSpawnRange + 4.0, 2.0, (double)this.aiSpawnRange + 4.0))) {
                    if (entity.field_70173_aa != 0 || !(entity instanceof EntityLiving)) continue;
                    ((EntityLiving)entity).func_70624_b(this.theEntity.func_70638_az());
                    ((EntityLiving)entity).func_70604_c(this.theEntity.func_70638_az());
                }
            }
        }

        public void func_98270_a(NBTTagCompound tag) {
            super.func_98270_a(tag);
            this.aiSpawnRange = tag.func_74765_d("SpawnRange");
        }
    }
}

