/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialai.ai.elite;

import fathertoast.specialai.ai.elite.IEliteAI;
import fathertoast.specialai.config.Config;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class EntityAIBarrage
extends EntityAIBase
implements IEliteAI {
    private static final byte STATE_END = 0;
    private static final byte STATE_START = 1;
    private static final byte STATE_SHOOT = 2;
    private int WEIGHT;
    protected EntityLiving theEntity;
    private float arrowDamage;
    private byte state;
    private byte attackTime;
    private Vec3d attackDir;

    EntityAIBarrage() {
    }

    private EntityAIBarrage(EntityLiving entity, float arrowDamage) {
        this.theEntity = entity;
        this.arrowDamage = arrowDamage;
        this.func_75248_a(7);
    }

    @Override
    public String getName() {
        return "barrage";
    }

    @Override
    public int getWeight() {
        return this.WEIGHT;
    }

    @Override
    public void setWeight(int weight) {
        this.WEIGHT = weight;
    }

    @Override
    public void addTo(EntityLiving entity, NBTTagCompound aiTag) {
        entity.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIBarrage(entity, aiTag.func_74760_g(this.getName())));
    }

    @Override
    public void save(NBTTagCompound aiTag) {
        aiTag.func_74776_a(this.getName(), 3.0f);
    }

    @Override
    public boolean isSaved(NBTTagCompound aiTag) {
        return aiTag.func_74760_g(this.getName()) > 0.0f;
    }

    @Override
    public void initialize(EntityLiving entity) {
        entity.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(Blocks.field_150367_z));
        entity.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier(UUID.randomUUID(), "Barrager health boost", Config.get().ELITE_AI.BARRAGE_HEALTH_BOOST, 0));
    }

    public boolean func_75250_a() {
        block5: {
            block4: {
                if (!this.theEntity.field_70122_E || this.theEntity.func_184218_aH()) break block4;
                byte by = this.attackTime;
                this.attackTime = (byte)(by - 1);
                if (by <= 0 && this.theEntity.func_70681_au().nextInt(10) == 0) break block5;
            }
            return false;
        }
        EntityLivingBase target = this.theEntity.func_70638_az();
        if (target != null) {
            double distance = this.theEntity.func_70068_e((Entity)target);
            return distance <= 256.0 && distance >= 25.0 && this.theEntity.func_70635_at().func_75522_a((Entity)target);
        }
        return false;
    }

    public boolean func_75253_b() {
        return this.state != 0;
    }

    public boolean func_75252_g() {
        return false;
    }

    public void func_75249_e() {
        this.theEntity.func_70661_as().func_75499_g();
        this.attackTime = (byte)30;
        this.state = 1;
        this.theEntity.func_184609_a(EnumHand.MAIN_HAND);
        this.theEntity.func_184609_a(EnumHand.OFF_HAND);
        this.theEntity.field_70170_p.func_184133_a(null, new BlockPos((Entity)this.theEntity), SoundEvents.field_187839_fV, this.theEntity.func_184176_by(), 1.0f, 1.0f / (this.theEntity.func_70681_au().nextFloat() * 0.4f + 0.8f));
    }

    public void func_75246_d() {
        EntityLivingBase target = this.theEntity.func_70638_az();
        this.attackTime = (byte)(this.attackTime - 1);
        if (this.state == 1) {
            if (target == null || !target.func_70089_S()) {
                this.state = 0;
                return;
            }
            this.theEntity.func_70671_ap().func_75651_a((Entity)target, 100.0f, 100.0f);
            if (this.attackTime <= 0) {
                this.attackDir = new Vec3d(target.field_70165_t - this.theEntity.field_70165_t, target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - this.theEntity.field_70163_u - (double)this.theEntity.func_70047_e(), target.field_70161_v - this.theEntity.field_70161_v);
                this.attackDir = this.attackDir.func_72441_c(0.0, Math.sqrt(this.attackDir.field_72450_a * this.attackDir.field_72450_a + this.attackDir.field_72449_c * this.attackDir.field_72449_c) * 0.2, 0.0);
                this.attackTime = (byte)60;
                this.state = (byte)2;
            }
        } else if (this.state == 2) {
            this.theEntity.func_70671_ap().func_75650_a(this.theEntity.field_70165_t + this.attackDir.field_72450_a, this.theEntity.field_70163_u + (double)this.theEntity.func_70047_e(), this.theEntity.field_70161_v + this.attackDir.field_72449_c, 100.0f, 100.0f);
            if (this.attackTime % 5 == 0) {
                EntityTippedArrow arrow = new EntityTippedArrow(this.theEntity.field_70170_p, this.theEntity.field_70165_t, this.theEntity.field_70163_u + (double)this.theEntity.func_70047_e(), this.theEntity.field_70161_v);
                arrow.field_70250_c = this.theEntity;
                arrow.func_70239_b((double)this.arrowDamage + this.theEntity.func_70681_au().nextGaussian() * 0.5 + (double)this.theEntity.field_70170_p.func_175659_aa().func_151525_a() * 0.22);
                arrow.func_70186_c(this.attackDir.field_72450_a, this.attackDir.field_72448_b, this.attackDir.field_72449_c, 1.8f, 20.0f);
                if (this.theEntity.func_70027_ad()) {
                    arrow.func_70015_d(100);
                }
                this.theEntity.field_70170_p.func_184133_a(null, new BlockPos((Entity)this.theEntity), SoundEvents.field_187737_v, this.theEntity.func_184176_by(), 1.0f, 1.0f / (this.theEntity.func_70681_au().nextFloat() * 0.4f + 0.8f));
                this.theEntity.field_70170_p.func_72838_d((Entity)arrow);
            } else if (this.attackTime <= 0) {
                this.state = 0;
            }
        }
    }

    public void func_75251_c() {
        this.attackTime = (byte)60;
    }
}

