/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialai.ai.elite;

import fathertoast.specialai.ai.elite.EntityAIBarrage;
import fathertoast.specialai.ai.elite.EntityAICharge;
import fathertoast.specialai.ai.elite.EntityAIJump;
import fathertoast.specialai.ai.elite.EntityAILeap;
import fathertoast.specialai.ai.elite.EntityAIShaman;
import fathertoast.specialai.ai.elite.EntityAISpawner;
import fathertoast.specialai.ai.elite.EntityAISprint;
import fathertoast.specialai.ai.elite.EntityAIThief;
import fathertoast.specialai.ai.elite.EntityAIThrow;
import fathertoast.specialai.ai.elite.EntityAIThrowPlayer;
import fathertoast.specialai.ai.elite.IEliteAI;
import fathertoast.specialai.config.Config;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class EliteAIHandler {
    public static final IEliteAI[] ELITE_AI_LIST = new IEliteAI[]{new EntityAICharge(), new EntityAISprint(), new EntityAIJump(), new EntityAILeap(), new EntityAIBarrage(), new EntityAISpawner(), new EntityAIShaman(), new EntityAIThrow(), new EntityAIThrowPlayer(), new EntityAIThief()};

    public static void saveSpecialAI(EntityLiving entity, NBTTagCompound aiTag) {
        if (Config.get().ELITE_AI.AI_WEIGHT_TOTAL > 0) {
            int choice = entity.func_70681_au().nextInt(Config.get().ELITE_AI.AI_WEIGHT_TOTAL);
            int index = ELITE_AI_LIST.length;
            while (index-- > 0) {
                if ((choice -= ELITE_AI_LIST[index].getWeight()) >= 0) continue;
                ELITE_AI_LIST[index].save(aiTag);
                return;
            }
        }
    }

    public static void addSpecialAI(EntityLiving entity, NBTTagCompound tag, boolean init) {
        float healthDiff = init ? entity.func_110138_aP() - entity.func_110143_aJ() : Float.NaN;
        for (IEliteAI ai : ELITE_AI_LIST) {
            if (!ai.isSaved(tag)) continue;
            ai.addTo(entity, tag);
            if (!init) continue;
            ai.initialize(entity);
        }
        if (init) {
            entity.func_70606_j(entity.func_110138_aP() - healthDiff);
        }
    }

    static void addModifierToItem(ItemStack stack, IAttribute attribute, double value, AttributeModOperation operation) {
        String name = attribute.func_111108_a();
        stack.func_185129_a(name, new AttributeModifier("specialai:" + name, value, operation.id), EntityLiving.func_184640_d((ItemStack)stack));
    }

    public static enum AttributeModOperation {
        ADDITION(0),
        MULTIPLY_BASE(1),
        MULTIPLY_TOTAL(2);

        public final int id;

        private AttributeModOperation(int key) {
            this.id = key;
        }
    }
}

