/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.planets.Neptune;

import com.mjr.extraplanets.Config;
import com.mjr.extraplanets.ExtraPlanetsDimensions;
import com.mjr.extraplanets.api.prefabs.world.WorldProviderRealisticSpace;
import com.mjr.extraplanets.blocks.ExtraPlanets_Blocks;
import com.mjr.extraplanets.planets.ExtraPlanets_Planets;
import com.mjr.extraplanets.planets.Neptune.worldgen.BiomeProviderNeptune;
import com.mjr.extraplanets.planets.Neptune.worldgen.ChunkProviderNeptune;
import com.mjr.mjrlegendslib.util.MCUtilities;
import java.util.LinkedList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.BiomeAdaptive;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.RoomTreasure;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.IChunkGenerator;

public class WorldProviderNeptune
extends WorldProviderRealisticSpace {
    public Vector3 getFogColor() {
        float f = 1.0f - this.getStarBrightness(1.0f);
        return new Vector3((double)(0.39215687f * f), (double)(0.8235294f * f), (double)(0.87058824f * f));
    }

    public Vector3 getSkyColor() {
        float f = 1.0f - this.getStarBrightness(1.0f);
        return new Vector3((double)(0.09411765f * f), (double)(0.6039216f * f), (double)(0.99215686f * f));
    }

    public boolean hasSunset() {
        return false;
    }

    public long getDayLength() {
        return 16660L;
    }

    public Class<? extends IChunkGenerator> getChunkProviderClass() {
        return ChunkProviderNeptune.class;
    }

    public Class<? extends BiomeProvider> getBiomeProviderClass() {
        BiomeAdaptive.setBodyMultiBiome((CelestialBody)ExtraPlanets_Planets.NEPTUNE);
        return BiomeProviderNeptune.class;
    }

    public double getHorizon() {
        return 44.0;
    }

    public int func_76557_i() {
        return 44;
    }

    public boolean func_76566_a(int var1, int var2) {
        return true;
    }

    public float getGravity() {
        if (Config.OLD_STYLE_GRAVITY) {
            return 0.058f;
        }
        return 0.01f;
    }

    public int getHeight() {
        return 800;
    }

    public double getMeteorFrequency() {
        return 10.0;
    }

    public double getFuelUsageMultiplier() {
        return 1.6;
    }

    public boolean canSpaceshipTierPass(int tier) {
        return tier >= ExtraPlanets_Planets.NEPTUNE.getTierRequirement();
    }

    public float getFallDamageModifier() {
        if (Config.OLD_STYLE_GRAVITY) {
            return 0.38f;
        }
        return 3.2f;
    }

    public CelestialBody getCelestialBody() {
        return ExtraPlanets_Planets.NEPTUNE;
    }

    public float getThermalLevelModifier() {
        if (Config.THERMAL_PADDINGS) {
            if (MCUtilities.isServer() && this.isDaytime()) {
                return -140.0f;
            }
            return -130.0f;
        }
        return 5.0f;
    }

    public double getSolarEnergyMultiplier() {
        return 2.0;
    }

    @Override
    public int getPressureLevel() {
        return 100;
    }

    @Override
    public int getSolarRadiationLevel() {
        return Config.NEPTUNE_RADIATION_AMOUNT;
    }

    public DimensionType func_186058_p() {
        return ExtraPlanetsDimensions.NEPTUNE;
    }

    public int getDungeonSpacing() {
        return 800;
    }

    public ResourceLocation getDungeonChestType() {
        return RoomTreasure.MOONCHEST;
    }

    public List<Block> getSurfaceBlocks() {
        LinkedList<Block> list = new LinkedList<Block>();
        list.add(ExtraPlanets_Blocks.NEPTUNE_BLOCKS);
        list.add(ExtraPlanets_Blocks.DECORATIVE_BLOCKS2);
        return list;
    }
}

