/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.moons.Triton.worldgen;

import com.mjr.extraplanets.Config;
import com.mjr.extraplanets.blocks.ExtraPlanets_Blocks;
import com.mjr.extraplanets.blocks.fluid.ExtraPlanets_Fluids;
import com.mjr.mjrlegendslib.util.WorldGenUtilities;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.BiomeDecoratorSpace;
import micdoodle8.mods.galacticraft.core.world.gen.WorldGenMinableMeta;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BiomeDecoratorTriton
extends BiomeDecoratorSpace {
    private WorldGenerator copperGen;
    private WorldGenerator tinGen;
    private WorldGenerator ironGen;
    private WorldGenerator gravelGen;
    private WorldGenerator fossilsGen;
    private int LakesPerChunk = 5;
    private World currentWorld;

    public BiomeDecoratorTriton() {
        if (Config.GENERATE_ORES_TRITON) {
            this.copperGen = new WorldGenMinableMeta(ExtraPlanets_Blocks.TRITON_BLOCKS, 4, 5, true, ExtraPlanets_Blocks.TRITON_BLOCKS, 2);
            this.tinGen = new WorldGenMinableMeta(ExtraPlanets_Blocks.TRITON_BLOCKS, 4, 4, true, ExtraPlanets_Blocks.TRITON_BLOCKS, 2);
            this.ironGen = new WorldGenMinableMeta(ExtraPlanets_Blocks.TRITON_BLOCKS, 8, 3, true, ExtraPlanets_Blocks.TRITON_BLOCKS, 2);
        }
        this.gravelGen = new WorldGenMinableMeta(ExtraPlanets_Blocks.TRITON_GRAVEL, 12, 0, true, ExtraPlanets_Blocks.TRITON_BLOCKS, 2);
        this.fossilsGen = new WorldGenMinableMeta(ExtraPlanets_Blocks.FOSSIL, 3, 0, true, ExtraPlanets_Blocks.TRITON_BLOCKS, 1);
    }

    protected void setCurrentWorld(World world) {
        this.currentWorld = world;
    }

    protected World getCurrentWorld() {
        return this.currentWorld;
    }

    protected void decorate() {
        if (Config.GENERATE_ORES_TRITON) {
            this.generateOre(26, this.copperGen, 0, 60);
            this.generateOre(23, this.tinGen, 0, 60);
            this.generateOre(20, this.ironGen, 0, 64);
        }
        this.generateOre(15, this.gravelGen, 0, 80);
        this.generateOre(10, this.fossilsGen, 0, 256);
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Pre(this.currentWorld, this.rand, new BlockPos(this.posX, 0, this.posZ)));
        for (int i = 0; i < this.LakesPerChunk; ++i) {
            if (this.rand.nextInt(10) != 0) continue;
            WorldGenUtilities.generateLake((World)this.currentWorld, (Random)this.rand, (BlockPos)new BlockPos(this.posX, 0, this.posZ), (Block)ExtraPlanets_Fluids.NITROGEN_ICE, (Block)ExtraPlanets_Blocks.FROZEN_NITROGEN);
        }
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Post(this.currentWorld, this.rand, new BlockPos(this.posX, 0, this.posZ)));
    }
}

