/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.items;

import com.blakebr0.cucumber.item.ItemMeta;
import com.blakebr0.cucumber.util.Utils;
import com.blakebr0.mysticalagriculture.MysticalAgriculture;
import com.blakebr0.mysticalagriculture.lib.Tooltips;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCharm
extends ItemMeta {
    private Map<Integer, Charm> charms = new HashMap<Integer, Charm>();
    public static ItemStack itemCharmBlank;
    public static ItemStack itemCharmNightvision;
    public static ItemStack itemCharmAbsorption;
    public static ItemStack itemCharmWither;
    public static ItemStack itemCharmAntivenom;
    public static ItemStack itemCharmFire;
    public static ItemStack itemCharmResistance;
    public static ItemStack itemCharmStrength;
    public static ItemStack itemCharmStrength2;
    public static ItemStack itemCharmSpeed;
    public static ItemStack itemCharmJump;
    public static ItemStack itemCharmMinersVision;
    public static ItemStack itemCharmRainbow;
    public static ItemStack itemCharmQuickDraw;
    public static ItemStack itemCharmTripleShot;
    public static ItemStack itemCharmMiningAOE;
    public static ItemStack itemCharmAttackAOE;
    public static ItemStack itemCharmTillingAOE;
    public static ItemStack itemCharmShearingAOE;
    public static ItemStack itemCharmReapingAOE;
    public static ItemStack itemCharmScythingAOE;

    public ItemCharm() {
        super("ma.charm", MysticalAgriculture.REGISTRY);
        this.func_77637_a(MysticalAgriculture.CREATIVE_TAB);
    }

    public void init() {
        itemCharmBlank = this.addItem(0, "blank");
        itemCharmNightvision = this.addItem(1, "nightvision", Applicable.HELMET);
        itemCharmAbsorption = this.addItem(2, "absorption", Applicable.HELMET, Applicable.CHESTPLATE, Applicable.LEGGINGS, Applicable.BOOTS);
        itemCharmWither = this.addItem(3, "wither", Applicable.HELMET, Applicable.CHESTPLATE, Applicable.LEGGINGS, Applicable.BOOTS);
        itemCharmAntivenom = this.addItem(4, "antivenom", Applicable.HELMET, Applicable.CHESTPLATE, Applicable.LEGGINGS, Applicable.BOOTS);
        itemCharmFire = this.addItem(5, "fire", Applicable.HELMET, Applicable.CHESTPLATE, Applicable.LEGGINGS, Applicable.BOOTS);
        itemCharmResistance = this.addItem(6, "resistance", Applicable.HELMET, Applicable.CHESTPLATE, Applicable.LEGGINGS, Applicable.BOOTS);
        itemCharmStrength = this.addItem(7, "strength", Applicable.CHESTPLATE, Applicable.SWORD);
        itemCharmStrength2 = this.addItem(8, "strength2", Applicable.SWORD);
        itemCharmSpeed = this.addItem(9, "speed", Applicable.LEGGINGS);
        itemCharmJump = this.addItem(10, "jump", Applicable.BOOTS);
        itemCharmMinersVision = this.addItem(11, "miners_vision", Applicable.PICKAXE);
        itemCharmRainbow = this.addItem(12, "rainbow", Applicable.SHEARS);
        itemCharmQuickDraw = this.addItem(13, "quick_draw", Applicable.BOW);
        itemCharmTripleShot = this.addItem(14, "triple_shot", Applicable.BOW);
        itemCharmMiningAOE = this.addItem(15, "mining_aoe", Applicable.PICKAXE, Applicable.SHOVEL, Applicable.AXE);
        itemCharmAttackAOE = this.addItem(16, "attack_aoe", Applicable.SWORD);
        itemCharmTillingAOE = this.addItem(17, "tilling_aoe", Applicable.HOE);
        itemCharmShearingAOE = this.addItem(18, "shearing_aoe", Applicable.SHEARS);
        itemCharmReapingAOE = this.addItem(19, "reaping_aoe", Applicable.SICKLE);
        itemCharmScythingAOE = this.addItem(20, "scything_aoe", Applicable.SCYTHE);
    }

    public ItemStack addItem(int meta, String name, Applicable ... applicable) {
        this.charms.put(meta, new Charm("desc.ma.charm_" + name, applicable));
        return super.addItem(meta, name);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        if (stack.func_77960_j() > 0) {
            Charm charm = this.charms.get(stack.func_77960_j());
            if (Utils.isShiftKeyDown()) {
                tooltip.add(Tooltips.DESCRIPTION);
                tooltip.add(charm.getDescription());
                tooltip.add("");
                tooltip.add(Tooltips.APPLICABLE_TO);
                for (int i = 0; i < charm.getApplicable().length; ++i) {
                    tooltip.add(charm.getApplicable()[i].getDescription());
                }
            } else {
                tooltip.add(Tooltips.HOLD_SHIFT_FOR_INFO);
            }
        }
    }

    public static enum Applicable {
        HELMET("- \u00a7c" + Tooltips.HELMET),
        CHESTPLATE("- \u00a7c" + Tooltips.CHESTPLATE),
        LEGGINGS("- \u00a7c" + Tooltips.LEGGINGS),
        BOOTS("- \u00a7c" + Tooltips.BOOTS),
        SWORD("- \u00a7c" + Tooltips.SWORD),
        PICKAXE("- \u00a7c" + Tooltips.PICKAXE),
        SHOVEL("- \u00a7c" + Tooltips.SHOVEL),
        AXE("- \u00a7c" + Tooltips.AXE),
        HOE("- \u00a7c" + Tooltips.HOE),
        SHEARS("- \u00a7c" + Tooltips.SHEARS),
        BOW("- \u00a7c" + Tooltips.BOW),
        SICKLE("- \u00a7c" + Tooltips.SICKLE),
        SCYTHE("- \u00a7c" + Tooltips.SCYTHE);

        private final String desc;

        private Applicable(String desc) {
            this.desc = desc;
        }

        public String getDescription() {
            return this.desc;
        }
    }

    public class Charm {
        private final String desc;
        private final Applicable[] applicable;

        public Charm(String desc, Applicable[] applicable) {
            this.desc = desc;
            this.applicable = applicable;
        }

        public String getDescription() {
            return Utils.localize((String)this.desc);
        }

        public Applicable[] getApplicable() {
            return this.applicable;
        }
    }
}

