/*
 * Decompiled with CFR 0.152.
 */
package com.nicjames2378.bqforestry.tasks;

import betterquesting.api.api.ApiKey;
import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.IQuestDatabase;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api.utils.JsonHelper;
import betterquesting.api2.cache.CapabilityProviderQuestCache;
import betterquesting.api2.cache.QuestCache;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.ParticipantInfo;
import com.nicjames2378.bqforestry.BQ_Forestry;
import com.nicjames2378.bqforestry.client.gui.editors.tasks.GuiEditTaskBeeRetrieval;
import com.nicjames2378.bqforestry.client.tasks.PanelTaskForestryRetrieval;
import com.nicjames2378.bqforestry.config.ConfigHandler;
import com.nicjames2378.bqforestry.tasks.ITaskInventory;
import com.nicjames2378.bqforestry.tasks.factory.FactoryTaskForestryRetrieval;
import com.nicjames2378.bqforestry.utils.UtilitiesBee;
import forestry.api.apiculture.EnumBeeChromosome;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

public class TaskForestryRetrieval
implements ITaskInventory {
    public final NonNullList<BigItemStack> requiredItems = new NonNullList<BigItemStack>(){
        {
            this.add(TaskForestryRetrieval.getDefaultBee());
        }
    };
    private final Set<UUID> completeUsers = new TreeSet<UUID>();
    private final HashMap<UUID, int[]> userProgress = new HashMap();
    public boolean consume = ConfigHandler.cfgConsume;
    public boolean autoConsume = ConfigHandler.cfgAutoConsume;

    public static BigItemStack getDefaultBee() {
        return new BigItemStack(UtilitiesBee.getBaseBee("forestry.speciesCommon", UtilitiesBee.BeeTypes.valueOf(ConfigHandler.cfgBeeType), ConfigHandler.cfgOnlyMated));
    }

    public String getUnlocalisedName() {
        return "bqforestry.task.bee_retrieval";
    }

    public ResourceLocation getFactoryID() {
        return FactoryTaskForestryRetrieval.INSTANCE.getRegistryName();
    }

    public boolean isComplete(UUID uuid) {
        return this.completeUsers.contains(uuid);
    }

    public void setComplete(UUID uuid) {
        this.completeUsers.add(uuid);
    }

    @Override
    public void onInventoryChange(@Nonnull DBEntry<IQuest> quest, @Nonnull EntityPlayer player) {
        if (!this.consume || this.autoConsume) {
            this.detect(new ParticipantInfo(player), quest);
        }
    }

    public void detect(ParticipantInfo participant, DBEntry<IQuest> quest) {
        QuestCache qc;
        UUID playerID = QuestingAPI.getQuestingUUID((EntityPlayer)participant.PLAYER);
        if (participant.PLAYER.field_71071_by == null || this.isComplete(playerID)) {
            return;
        }
        int[] progress = this.getUsersProgress(playerID);
        boolean updated = false;
        for (int i = 0; i < participant.PLAYER.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = participant.PLAYER.field_71071_by.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            int remStack = stack.func_190916_E();
            for (int j = 0; j < this.requiredItems.size(); ++j) {
                BigItemStack rStack = (BigItemStack)this.requiredItems.get(j);
                if (rStack.getBaseStack().func_77969_a(stack) || progress[j] >= rStack.stackSize || UtilitiesBee.isMated(rStack.getBaseStack()) && !UtilitiesBee.isMated(stack)) continue;
                HashMap<EnumBeeChromosome, HashSet<String>> map = UtilitiesBee.getAllTraits(rStack.getBaseStack(), false);
                boolean nbtIsValid = false;
                BQ_Forestry.debug("================");
                for (Map.Entry<EnumBeeChromosome, HashSet<String>> entry : map.entrySet()) {
                    BQ_Forestry.debug(String.format("SubmitItemDEBUG: Chromosome %1$s", entry.getKey()));
                    for (String s : entry.getValue()) {
                        BQ_Forestry.debug(String.format("                      Value %1$s", s));
                    }
                }
                BQ_Forestry.debug("");
                for (Map.Entry<EnumBeeChromosome, HashSet<String>> entry : map.entrySet()) {
                    String submissionTrait = UtilitiesBee.getTrait(stack, entry.getKey(), true)[0];
                    BQ_Forestry.debug(String.format("SubmitItem: Chromosome %1$s (Wanted: %2$s)", entry.getKey(), entry.getValue()));
                    if (entry.getValue().contains(submissionTrait)) {
                        BQ_Forestry.debug(String.format("                      Value [%1$s] is VALID", submissionTrait));
                        nbtIsValid = true;
                        continue;
                    }
                    BQ_Forestry.debug(String.format("                      Value [%1$s] is INVALID", submissionTrait));
                    nbtIsValid = false;
                    break;
                }
                if (!nbtIsValid) continue;
                int remaining = rStack.stackSize - progress[j];
                if (this.consume) {
                    ItemStack removed = participant.PLAYER.field_71071_by.func_70298_a(i, remaining);
                    int n = j;
                    progress[n] = progress[n] + removed.func_190916_E();
                } else {
                    int temp = Math.min(remaining, remStack);
                    remStack -= temp;
                    int n = j;
                    progress[n] = progress[n] + temp;
                }
                updated = true;
            }
        }
        if (updated) {
            this.setUserProgress(playerID, progress);
        }
        boolean hasAll = true;
        int[] totalProgress = this.getUsersProgress(playerID);
        for (int j = 0; j < this.requiredItems.size(); ++j) {
            BigItemStack rStack = (BigItemStack)this.requiredItems.get(j);
            if (totalProgress[j] >= rStack.stackSize) continue;
            hasAll = false;
            break;
        }
        if (hasAll) {
            this.setComplete(playerID);
            updated = true;
        }
        if (updated && (qc = (QuestCache)participant.PLAYER.getCapability(CapabilityProviderQuestCache.CAP_QUEST_CACHE, null)) != null) {
            qc.markQuestDirty(((IQuestDatabase)QuestingAPI.getAPI((ApiKey)ApiReference.QUEST_DB)).getID(quest.getValue()));
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound json) {
        json.func_74757_a("consume", this.consume);
        json.func_74757_a("autoConsume", this.autoConsume);
        NBTTagList itemArray = new NBTTagList();
        for (BigItemStack stack : this.requiredItems) {
            itemArray.func_74742_a((NBTBase)JsonHelper.ItemStackToJson((BigItemStack)stack, (NBTTagCompound)new NBTTagCompound()));
        }
        json.func_74782_a("requiredItems", (NBTBase)itemArray);
        return json;
    }

    public void readFromNBT(NBTTagCompound json) {
        this.consume = json.func_74767_n("consume");
        this.autoConsume = json.func_74767_n("autoConsume");
        this.requiredItems.clear();
        NBTTagList iList = json.func_150295_c("requiredItems", 10);
        for (int i = 0; i < iList.func_74745_c(); ++i) {
            this.requiredItems.add((Object)JsonHelper.JsonToItemStack((NBTTagCompound)iList.func_150305_b(i)));
        }
    }

    public void readProgressFromNBT(NBTTagCompound nbt, boolean merge) {
        if (!merge) {
            this.completeUsers.clear();
            this.userProgress.clear();
        }
        NBTTagList cList = nbt.func_150295_c("completeUsers", 8);
        for (int i = 0; i < cList.func_74745_c(); ++i) {
            try {
                this.completeUsers.add(UUID.fromString(cList.func_150307_f(i)));
                continue;
            }
            catch (Exception e) {
                BQ_Forestry.log.log(Level.ERROR, "Unable to load UUID for task", (Throwable)e);
            }
        }
        NBTTagList pList = nbt.func_150295_c("userProgress", 10);
        for (int n = 0; n < pList.func_74745_c(); ++n) {
            try {
                NBTTagCompound pTag = pList.func_150305_b(n);
                UUID uuid = UUID.fromString(pTag.func_74779_i("uuid"));
                int[] data = new int[this.requiredItems.size()];
                NBTTagList dNbt = pTag.func_150295_c("data", 3);
                for (int i = 0; i < data.length && i < dNbt.func_74745_c(); ++i) {
                    data[i] = dNbt.func_186858_c(i);
                }
                this.userProgress.put(uuid, data);
                continue;
            }
            catch (Exception e) {
                BQ_Forestry.log.log(Level.ERROR, "Unable to load user progress for task", (Throwable)e);
            }
        }
    }

    public NBTTagCompound writeProgressToNBT(NBTTagCompound nbt, @Nullable List<UUID> users) {
        NBTTagList jArray = new NBTTagList();
        NBTTagList progArray = new NBTTagList();
        if (users != null) {
            users.forEach(uuid -> {
                int[] data;
                if (this.completeUsers.contains(uuid)) {
                    jArray.func_74742_a((NBTBase)new NBTTagString(uuid.toString()));
                }
                if ((data = this.userProgress.get(uuid)) != null) {
                    NBTTagCompound pJson = new NBTTagCompound();
                    pJson.func_74778_a("uuid", uuid.toString());
                    NBTTagList pArray = new NBTTagList();
                    for (int i : data) {
                        pArray.func_74742_a((NBTBase)new NBTTagInt(i));
                    }
                    pJson.func_74782_a("data", (NBTBase)pArray);
                    progArray.func_74742_a((NBTBase)pJson);
                }
            });
        } else {
            this.completeUsers.forEach(uuid -> jArray.func_74742_a((NBTBase)new NBTTagString(uuid.toString())));
            this.userProgress.forEach((uuid, data) -> {
                NBTTagCompound pJson = new NBTTagCompound();
                pJson.func_74778_a("uuid", uuid.toString());
                NBTTagList pArray = new NBTTagList();
                for (int i : data) {
                    pArray.func_74742_a((NBTBase)new NBTTagInt(i));
                }
                pJson.func_74782_a("data", (NBTBase)pArray);
                progArray.func_74742_a((NBTBase)pJson);
            });
        }
        nbt.func_74782_a("completeUsers", (NBTBase)jArray);
        nbt.func_74782_a("userProgress", (NBTBase)progArray);
        return nbt;
    }

    public void resetUser(@Nullable UUID uuid) {
        if (uuid == null) {
            this.completeUsers.clear();
            this.userProgress.clear();
        } else {
            this.completeUsers.remove(uuid);
            this.userProgress.remove(uuid);
        }
    }

    public IGuiPanel getTaskGui(IGuiRect rect, DBEntry<IQuest> quest) {
        return new PanelTaskForestryRetrieval(rect, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getTaskEditor(GuiScreen parent, DBEntry<IQuest> quest) {
        return new GuiEditTaskBeeRetrieval(parent, quest, this);
    }

    public void setUserProgress(UUID uuid, int[] progress) {
        this.userProgress.put(uuid, progress);
    }

    public int[] getUsersProgress(UUID uuid) {
        int[] progress = this.userProgress.get(uuid);
        return progress == null || progress.length != this.requiredItems.size() ? new int[this.requiredItems.size()] : progress;
    }
}

