/*
 * Decompiled with CFR 0.152.
 */
package com.nicjames2378.bqforestry.commands;

import com.google.common.collect.Lists;
import com.nicjames2378.bqforestry.config.ConfigHandler;
import com.nicjames2378.bqforestry.utils.UtilitiesBee;
import forestry.api.apiculture.EnumBeeChromosome;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class BQFCommandFindTrait
implements ICommand {
    private String commandKey = "/findtrait";

    private static ValidChromosomes getEnumValid(ICommandSender sender) {
        EntityPlayer player;
        ItemStack heldItem;
        if (sender.func_174793_f() instanceof EntityPlayer && UtilitiesBee.hasValidGrowthLevel(heldItem = (player = (EntityPlayer)sender.func_174793_f()).func_184614_ca())) {
            return ValidChromosomes.Bee;
        }
        return ValidChromosomes.INVALID;
    }

    private static ArrayList<String> getChromosomes(ValidChromosomes type) {
        ArrayList<String> values = new ArrayList<String>();
        switch (type) {
            case Bee: {
                for (EnumBeeChromosome e : EnumBeeChromosome.values()) {
                    values.add(e.getName().toLowerCase());
                }
                break;
            }
        }
        return values;
    }

    public String func_71517_b() {
        return this.commandKey.substring(1);
    }

    public String func_71518_a(ICommandSender sender) {
        ValidChromosomes en = BQFCommandFindTrait.getEnumValid(sender);
        ArrayList<String> list = BQFCommandFindTrait.getChromosomes(en);
        StringBuilder sb = new StringBuilder();
        if (list.size() < 1) {
            return this.commandKey + " <trait> [copyToClipboard]";
        }
        sb.append(this.commandKey).append(" <");
        for (int i = 0; i < list.size(); ++i) {
            sb.append(list.get(i));
            if (i >= list.size() - 1) continue;
            sb.append("|");
        }
        sb.append(">");
        return sb.toString();
    }

    public List<String> func_71514_a() {
        ArrayList aliases = Lists.newArrayList();
        aliases.add(this.commandKey);
        return aliases;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (!(sender.func_174793_f() instanceof EntityPlayer)) throw new WrongUsageException("bqforestry.command.error.clientonly", new Object[0]);
        if (args.length < 1 || args[0] == null) {
            throw new WrongUsageException("bqforestry.command.error.improperargument", new Object[0]);
        }
        EntityPlayer player = (EntityPlayer)sender.func_174793_f();
        ValidChromosomes en = BQFCommandFindTrait.getEnumValid(sender);
        ArrayList<String> list = BQFCommandFindTrait.getChromosomes(en);
        String trait = "";
        switch (en) {
            case Bee: {
                if (!list.contains(args[0].toLowerCase())) throw new WrongUsageException("bqforestry.command.error.improperitem", new Object[]{"item"});
                trait = UtilitiesBee.getTrait(player.func_184614_ca(), EnumBeeChromosome.valueOf((String)args[0].toUpperCase()), true)[0];
                break;
            }
            case INVALID: {
                throw new WrongUsageException("bqforestry.command.error.improperitem", new Object[]{"item"});
            }
        }
        if (trait.equals("")) throw new WrongUsageException("bqforestry.command.error.improperargument", new Object[0]);
        if (args.length < 2 && ConfigHandler.cfgDefaultCommandCopy) {
            this.displayTraitWithCopy(player, trait, true);
            return;
        } else if (args.length >= 2 && args[1].toLowerCase().equals("true")) {
            this.displayTraitWithCopy(player, trait, true);
            return;
        } else {
            this.displayTraitWithCopy(player, trait, false);
        }
    }

    private void displayTraitWithCopy(EntityPlayer player, String trait, boolean copy) {
        TextComponentTranslation getTrait = new TextComponentTranslation("bqforestry.command.gettrait", new Object[]{TextFormatting.YELLOW.toString() + trait});
        TextComponentTranslation getCopied = new TextComponentTranslation("bqforestry.command.gettrait.copied", new Object[0]);
        if (copy) {
            BQFCommandFindTrait.copyToClipboard(trait);
        }
        player.func_145747_a((ITextComponent)(copy ? getTrait.func_150257_a((ITextComponent)getCopied) : getTrait));
    }

    private static void copyToClipboard(String message) {
        StringSelection stringSelection = new StringSelection(message);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, null);
    }

    private TextComponentTranslation format(TextFormatting color, String str, Object ... args) {
        TextComponentTranslation ret = new TextComponentTranslation(str, args);
        ret.func_150256_b().func_150238_a(color);
        return ret;
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        ValidChromosomes en = BQFCommandFindTrait.getEnumValid(sender);
        ArrayList<String> list = BQFCommandFindTrait.getChromosomes(en);
        if (args.length == 1) {
            return CommandBase.func_175762_a((String[])args, list);
        }
        return null;
    }

    public boolean func_82358_a(String[] args, int index) {
        return false;
    }

    public int compareTo(ICommand iCommand) {
        return 0;
    }

    private static enum ValidChromosomes {
        INVALID,
        Bee;

    }
}

