/*
 * Decompiled with CFR 0.152.
 */
package com.nicjames2378.bqforestry.client.gui.editors.tasks;

import betterquesting.api.api.ApiKey;
import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.client.gui.misc.IVolatileScreen;
import betterquesting.api.network.IPacketSender;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.questing.IQuest;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api2.client.gui.controls.IValueIO;
import betterquesting.api2.client.gui.controls.PanelButton;
import betterquesting.api2.client.gui.controls.PanelButtonStorage;
import betterquesting.api2.client.gui.misc.GuiAlign;
import betterquesting.api2.client.gui.misc.GuiPadding;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.GuiTransform;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.CanvasEmpty;
import betterquesting.api2.client.gui.panels.CanvasTextured;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.client.gui.panels.bars.PanelHScrollBar;
import betterquesting.api2.client.gui.panels.bars.PanelVScrollBar;
import betterquesting.api2.client.gui.panels.content.PanelGeneric;
import betterquesting.api2.client.gui.panels.content.PanelLine;
import betterquesting.api2.client.gui.panels.content.PanelTextBox;
import betterquesting.api2.client.gui.panels.lists.CanvasScrolling;
import betterquesting.api2.client.gui.resources.textures.IGuiTexture;
import betterquesting.api2.client.gui.resources.textures.ItemTexture;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.client.gui.themes.presets.PresetLine;
import betterquesting.api2.client.gui.themes.presets.PresetTexture;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.QuestTranslation;
import com.nicjames2378.bqforestry.BQ_Forestry;
import com.nicjames2378.bqforestry.client.gui.editors.controls.BQButton;
import com.nicjames2378.bqforestry.client.gui.editors.controls.PanelToggleStorage;
import com.nicjames2378.bqforestry.client.gui.editors.panels.PanesBee;
import com.nicjames2378.bqforestry.client.gui.editors.tasks.abstractions.BQScreenCanvas;
import com.nicjames2378.bqforestry.client.themes.ThemeHandler;
import com.nicjames2378.bqforestry.config.ConfigHandler;
import com.nicjames2378.bqforestry.tasks.TaskForestryRetrieval;
import com.nicjames2378.bqforestry.utils.UtilitiesBee;
import forestry.api.apiculture.EnumBeeChromosome;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.input.Keyboard;

public class GuiEditTaskBeeRetrieval
extends BQScreenCanvas
implements IVolatileScreen {
    private static final ResourceLocation QUEST_EDIT = new ResourceLocation("betterquesting:quest_edit");
    final HashMap<EnumBeeChromosome, ArrayList<PanelToggleStorage>> mapOptions = new HashMap();
    private Tuple<Integer, Integer> _catCurrentCoords = new Tuple((Object)8, (Object)8);
    private int catWidthBounds = 0;
    private short catButtonSize = (short)32;

    private Tuple<Integer, Integer> getCatCoords() {
        Tuple<Integer, Integer> current = this._catCurrentCoords;
        int x = (Integer)this._catCurrentCoords.func_76341_a() + this.catButtonSize;
        int y = (Integer)this._catCurrentCoords.func_76340_b();
        if (x > this.catWidthBounds - 16 - this.catButtonSize) {
            x = 8;
            y += this.catButtonSize;
        }
        this._catCurrentCoords = new Tuple((Object)x, (Object)y);
        return current;
    }

    public GuiEditTaskBeeRetrieval(GuiScreen parent, DBEntry<IQuest> quest, TaskForestryRetrieval task) {
        super(parent);
        this.quest = quest;
        this.task = task;
    }

    public void initPanel() {
        super.initPanel();
        Keyboard.enableRepeatEvents((boolean)true);
        this._catCurrentCoords = new Tuple((Object)8, (Object)8);
        if (this.task.requiredItems.size() <= 0) {
            this.setSelectedIndex(0);
        }
        CanvasTextured cvBackground = new CanvasTextured((IGuiRect)new GuiTransform(), PresetTexture.PANEL_MAIN.getTexture());
        this.addPanel((IGuiPanel)cvBackground);
        cvBackground.addPanel((IGuiPanel)new PanelTextBox((IGuiRect)new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(16, 16, 16, -32), 0), QuestTranslation.translate((String)"bqforestry.title.edit_bee_retrieval", (Object[])new Object[0])).setAlignment(1).setColor(PresetColor.TEXT_HEADER.getColor()));
        cvBackground.addPanel((IGuiPanel)new PanelButton((IGuiRect)new GuiTransform(GuiAlign.BOTTOM_CENTER, -100, -16, 200, 16, 0), -1, QuestTranslation.translate((String)"gui.done", (Object[])new Object[0])){

            public void onButtonClick() {
                GuiEditTaskBeeRetrieval.this.sendChanges();
                GuiEditTaskBeeRetrieval.this.field_146297_k.func_147108_a(GuiEditTaskBeeRetrieval.this.parent);
            }
        });
        GuiTransform ls0 = new GuiTransform(GuiAlign.TOP_LEFT, 16, 32, 0, 0, 0);
        ls0.setParent(cvBackground.getTransform());
        GuiTransform rs0 = new GuiTransform(GuiAlign.TOP_RIGHT, -16, 32, 0, 0, 0);
        rs0.setParent(cvBackground.getTransform());
        PanelLine plTop = new PanelLine((IGuiRect)ls0, (IGuiRect)rs0, PresetLine.GUI_DIVIDER.getLine(), 1, PresetColor.GUI_DIVIDER.getColor(), -1);
        cvBackground.addPanel((IGuiPanel)plTop);
        GuiTransform ls1 = new GuiTransform(GuiAlign.BOTTOM_LEFT, 16, -32, 0, 0, 0);
        ls1.setParent(cvBackground.getTransform());
        GuiTransform rs1 = new GuiTransform(GuiAlign.BOTTOM_RIGHT, -16, -32, 0, 0, 0);
        rs1.setParent(cvBackground.getTransform());
        PanelLine plBottom = new PanelLine((IGuiRect)ls1, (IGuiRect)rs1, PresetLine.GUI_DIVIDER.getLine(), 1, PresetColor.GUI_DIVIDER.getColor(), -1);
        cvBackground.addPanel((IGuiPanel)plBottom);
        CanvasEmpty cvPanes = new CanvasEmpty((IGuiRect)new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(16, 36, 16, 36), 0));
        cvBackground.addPanel((IGuiPanel)cvPanes);
        CanvasEmpty cvBeeScrollContainer = new CanvasEmpty((IGuiRect)new GuiTransform(GuiAlign.TOP_LEFT, 0, 0, cvPanes.getTransform().getWidth(), 42, 0));
        cvPanes.addPanel((IGuiPanel)cvBeeScrollContainer);
        int buttonSize = cvBeeScrollContainer.getTransform().getHeight() - 4;
        CanvasScrolling cvBeeScroll = new CanvasScrolling((IGuiRect)new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(buttonSize, 4, buttonSize, 0), 0));
        cvBeeScrollContainer.addPanel((IGuiPanel)cvBeeScroll);
        ArrayList<PanelButtonStorage> lstRequiredItemButtons = new ArrayList<PanelButtonStorage>();
        int listSize = this.task.requiredItems.size();
        for (int i = 0; i <= listSize; ++i) {
            if (i == listSize) continue;
            BigItemStack taskItem = (BigItemStack)this.task.requiredItems.get(i);
            PanelButtonStorage btnReqItem = new PanelButtonStorage((IGuiRect)new GuiRectangle(i * buttonSize + i * 2, 0, buttonSize, buttonSize, 0), -1, String.valueOf(i), (Object)i);
            btnReqItem.setCallback(value -> {
                this.setSelectedIndex((int)value);
                for (PanelButtonStorage b : lstRequiredItemButtons) {
                    b.setActive(!((Integer)btnReqItem.getStoredValue()).equals(this.getSelectedIndex()));
                }
                this.refresh();
            });
            btnReqItem.setIcon(((Integer)btnReqItem.getStoredValue()).equals(this.getSelectedIndex()) ? ThemeHandler.ITEM_FRAME_SELECTED.getTexture() : ThemeHandler.ITEM_FRAME.getTexture());
            btnReqItem.setTooltip(this.getHoverTooltip(taskItem.getBaseStack(), i));
            btnReqItem.setActive(!((Integer)btnReqItem.getStoredValue()).equals(this.getSelectedIndex()));
            cvBeeScroll.addPanel((IGuiPanel)btnReqItem);
            lstRequiredItemButtons.add(btnReqItem);
            PanelGeneric btnReqItemIcon = new PanelGeneric((IGuiRect)new GuiRectangle(i * buttonSize + i * 2, 2, buttonSize - 2, buttonSize - 2, -1), (IGuiTexture)new ItemTexture(UtilitiesBee.getSafeStack(taskItem)));
            cvBeeScroll.addPanel((IGuiPanel)btnReqItemIcon);
        }
        cvBeeScrollContainer.addPanel((IGuiPanel)new BQButton.AddButton((IGuiRect)new GuiRectangle(0, 4, buttonSize, buttonSize, 0), "bqforestry.tooltip.add.left", this.field_146297_k.field_71466_p, () -> {
            this.task.requiredItems.add(this.getSelectedIndex(), (Object)TaskForestryRetrieval.getDefaultBee());
            this.refresh();
        }));
        cvBeeScrollContainer.addPanel((IGuiPanel)new BQButton.AddButton((IGuiRect)new GuiRectangle(cvBeeScrollContainer.getTransform().getWidth() - buttonSize, 4, buttonSize, buttonSize, 0), "bqforestry.tooltip.add.right", this.field_146297_k.field_71466_p, () -> {
            if (this.getSelectedIndex() + 1 >= this.task.requiredItems.size()) {
                this.task.requiredItems.add((Object)TaskForestryRetrieval.getDefaultBee());
            } else {
                this.task.requiredItems.add(this.getSelectedIndex() + 1, (Object)TaskForestryRetrieval.getDefaultBee());
            }
            this.refresh();
        }));
        PanelHScrollBar scBeeScrollBarH = new PanelHScrollBar((IGuiRect)new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(buttonSize + 2, 0, buttonSize + 2, -4), -10));
        scBeeScrollBarH.setScrollSpeed(ConfigHandler.cfgScrollSpeed);
        cvBeeScroll.setScrollDriverX((IValueIO)scBeeScrollBarH);
        cvBeeScrollContainer.addPanel((IGuiPanel)scBeeScrollBarH);
        CanvasEmpty cvDataPanels = new CanvasEmpty((IGuiRect)new GuiTransform(GuiAlign.FULL_BOX, 0, 44, cvPanes.getTransform().getWidth(), cvPanes.getTransform().getHeight() - 44, 0));
        cvPanes.addPanel((IGuiPanel)cvDataPanels);
        int cWidthHalf = cvDataPanels.getTransform().getWidth() / 2;
        int cHeight = cvDataPanels.getTransform().getHeight();
        int cHeightThird = cvDataPanels.getTransform().getHeight() / 3;
        CanvasTextured cvBeeStatsHolder = new CanvasTextured((IGuiRect)new GuiTransform(GuiAlign.HALF_LEFT, 0, 0, cWidthHalf - 1, cHeightThird * 2 - 2, 0), PresetTexture.ITEM_FRAME.getTexture());
        cvDataPanels.addPanel((IGuiPanel)cvBeeStatsHolder);
        int getIndex = this.getSelectedIndex();
        cvBeeStatsHolder.addPanel((IGuiPanel)new PanelTextBox((IGuiRect)new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(8, 8, 0, -32), -10), TextFormatting.UNDERLINE.toString() + QuestTranslation.translate((String)"bqforestry.label.beeretrievallabel", (Object[])new Object[0]) + getIndex).setFontSize(16).enableShadow(true));
        if (getIndex >= 0) {
            cvBeeStatsHolder.addPanel((IGuiPanel)new PanelTextBox((IGuiRect)new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(12, 28, 0, 0), 0), String.join((CharSequence)"\n", UtilitiesBee.getBeeInfo(((BigItemStack)this.task.requiredItems.get(getIndex)).getBaseStack()))));
        }
        CanvasTextured cvBeeCategories = new CanvasTextured((IGuiRect)new GuiTransform(GuiAlign.HALF_LEFT, 0, cHeightThird * 2, cWidthHalf - 1, cHeightThird + 1, 0), PresetTexture.ITEM_FRAME.getTexture());
        cvDataPanels.addPanel((IGuiPanel)cvBeeCategories);
        this.catWidthBounds = cvBeeCategories.getTransform().getWidth();
        CanvasScrolling cvScrollCategories = new CanvasScrolling((IGuiRect)new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 2, 8, 2), 0));
        cvBeeCategories.addPanel((IGuiPanel)cvScrollCategories);
        PanelVScrollBar vScrollCategories = new PanelVScrollBar((IGuiRect)new GuiTransform(GuiAlign.RIGHT_EDGE, new GuiPadding(-8, 2, 0, 2), 0));
        cvScrollCategories.setScrollDriverY((IValueIO)vScrollCategories);
        vScrollCategories.setScrollSpeed(ConfigHandler.cfgScrollSpeed);
        cvBeeCategories.addPanel((IGuiPanel)vScrollCategories);
        cvScrollCategories.addPanel((IGuiPanel)BUG_FIX1);
        cvScrollCategories.addPanel(this.getPanel(PanesBee.Trash, ThemeHandler.ICON_ITEM_REMOVE.getTexture()));
        cvScrollCategories.addPanel(this.getPanel(PanesBee.BeeGrowth, ThemeHandler.ICON_GENOME_BEE_GROWTH.getTexture()));
        cvScrollCategories.addPanel(this.getPanel(PanesBee.BeeSpecies, ThemeHandler.ICON_GENOME_SPECIES.getTexture()));
        cvScrollCategories.addPanel(this.getPanel(PanesBee.BeeLifespan, ThemeHandler.ICON_GENOME_LIFESPAN.getTexture()));
        cvScrollCategories.addPanel(this.getPanel(PanesBee.BeeSpeed, ThemeHandler.ICON_GENOME_SPEED.getTexture()));
        cvScrollCategories.addPanel(this.getPanel(PanesBee.BeeFloweringSpeed, ThemeHandler.ICON_GENOME_FLOWERING.getTexture()));
        cvScrollCategories.addPanel(this.getPanel(PanesBee.BeeFertility, ThemeHandler.ICON_GENOME_FERTILITY.getTexture()));
        cvScrollCategories.addPanel(this.getPanel(PanesBee.BeeTerritory, ThemeHandler.ICON_GENOME_TERRITORY.getTexture()));
        cvScrollCategories.addPanel(this.getPanel(PanesBee.BeeEffect, ThemeHandler.ICON_GENOME_EFFECT.getTexture()));
        cvScrollCategories.addPanel(this.getPanel(PanesBee.BeeTemperature, ThemeHandler.ICON_GENOME_TEMPERATURE_TOLERANCE.getTexture()));
        cvScrollCategories.addPanel(this.getPanel(PanesBee.BeeHumidity, ThemeHandler.ICON_GENOME_HUMIDITY_TOLERANCE.getTexture()));
        cvScrollCategories.addPanel(this.getPanel(PanesBee.BeeSleep, ThemeHandler.ICON_GENOME_NEVER_SLEEPS.getTexture()));
        cvScrollCategories.addPanel(this.getPanel(PanesBee.BeeRain, ThemeHandler.ICON_GENOME_RAIN_TOLERANCE.getTexture()));
        cvScrollCategories.addPanel(this.getPanel(PanesBee.BeeCave, ThemeHandler.ICON_GENOME_CAVE_DWELLING.getTexture()));
        cvScrollCategories.addPanel(this.getPanel(PanesBee.BeeFlowerProvider, ThemeHandler.ICON_GENOME_FLOWER_PROVIDER.getTexture()));
        CanvasTextured cvBeeOptions = new CanvasTextured((IGuiRect)new GuiTransform(GuiAlign.HALF_RIGHT, 0, 0, cWidthHalf - 1, cHeight, 0), PresetTexture.ITEM_FRAME.getTexture());
        cvDataPanels.addPanel((IGuiPanel)cvBeeOptions);
        this.getSelectedOption().get(this, (CanvasEmpty)cvBeeOptions);
        BQ_Forestry.debug("Setting Panel to " + this.getSelectedOption().name());
    }

    private void sendChanges() {
        NBTTagCompound payload = new NBTTagCompound();
        NBTTagList dataList = new NBTTagList();
        NBTTagCompound entry = new NBTTagCompound();
        entry.func_74768_a("questID", this.quest.getID());
        entry.func_74782_a("config", ((IQuest)this.quest.getValue()).writeToNBT((NBTBase)new NBTTagCompound()));
        dataList.func_74742_a((NBTBase)entry);
        payload.func_74782_a("data", (NBTBase)dataList);
        payload.func_74768_a("action", 0);
        ((IPacketSender)QuestingAPI.getAPI((ApiKey)ApiReference.PACKET_SENDER)).sendToServer(new QuestingPacket(QUEST_EDIT, payload));
    }

    private PanelButtonStorage<PanesBee> getPanel(PanesBee panel, IGuiTexture icon) {
        Tuple<Integer, Integer> coords = this.getCatCoords();
        PanelButtonStorage btnBeePanel = new PanelButtonStorage((IGuiRect)new GuiTransform(GuiAlign.TOP_LEFT, ((Integer)coords.func_76341_a()).intValue(), ((Integer)coords.func_76340_b()).intValue(), (int)this.catButtonSize, (int)this.catButtonSize, 0), -1, "", (Object)panel);
        btnBeePanel.setIcon(icon);
        btnBeePanel.setActive(this.task.requiredItems.size() > 0);
        btnBeePanel.setCallback(this::setSelectedOption);
        return btnBeePanel;
    }

    private ArrayList<String> getHoverTooltip(ItemStack bee, int index) {
        ArrayList<String> tip = new ArrayList<String>();
        String GOLD = TextFormatting.GOLD.toString();
        String AQUA = TextFormatting.AQUA.toString();
        tip.add(GOLD.concat("Bee Retrieval Item #").concat(String.valueOf(index)));
        tip.add(AQUA.concat(UtilitiesBee.getDisplayName(bee)));
        tip.add(AQUA.concat("(" + UtilitiesBee.getTrait(bee, EnumBeeChromosome.SPECIES, true)[0] + ")"));
        return tip;
    }
}

