/*
 * Decompiled with CFR 0.152.
 */
package com.nicjames2378.bqforestry.client.gui.editors.panels.templates;

import betterquesting.api2.client.gui.controls.IValueIO;
import betterquesting.api2.client.gui.misc.GuiAlign;
import betterquesting.api2.client.gui.misc.GuiPadding;
import betterquesting.api2.client.gui.misc.GuiTransform;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.CanvasEmpty;
import betterquesting.api2.client.gui.panels.IGuiCanvas;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.client.gui.panels.bars.PanelVScrollBar;
import betterquesting.api2.client.gui.panels.content.PanelTextBox;
import betterquesting.api2.client.gui.panels.lists.CanvasScrolling;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.utils.QuestTranslation;
import com.nicjames2378.bqforestry.client.gui.editors.controls.BQButton;
import com.nicjames2378.bqforestry.client.gui.editors.controls.FactoryForestryDataControlArea;
import com.nicjames2378.bqforestry.client.gui.editors.controls.PanelToggleStorage;
import com.nicjames2378.bqforestry.client.gui.editors.panels.templates.TemplateEmpty;
import com.nicjames2378.bqforestry.client.gui.editors.tasks.abstractions.BQScreenCanvas;
import com.nicjames2378.bqforestry.config.ConfigHandler;
import com.nicjames2378.bqforestry.logic.BigBeeStack;
import com.nicjames2378.bqforestry.utils.StringUtils;
import com.nicjames2378.bqforestry.utils.UtilitiesBee;
import forestry.api.apiculture.EnumBeeChromosome;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;

public class TemplateToggleableChromosomes
extends TemplateEmpty {
    private String translationTitleKey = "";
    private EnumBeeChromosome chromosome = EnumBeeChromosome.SPEED;
    private ArrayList<PanelToggleStorage> values = new ArrayList();

    protected EnumBeeChromosome getChromosomeValue() {
        return this.chromosome;
    }

    public TemplateToggleableChromosomes(EnumBeeChromosome chromosome, String translationKeyTitle) {
        super((IGuiRect)new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 0, 0, 0), 0));
        this.chromosome = chromosome;
        this.translationTitleKey = translationKeyTitle;
    }

    public TemplateToggleableChromosomes(IGuiRect rect) {
        super(rect);
    }

    @Override
    public void initialize(final BQScreenCanvas gui, CanvasEmpty canvas) {
        final BigBeeStack bee = new BigBeeStack(gui.getSelectedItem());
        canvas.addPanel((IGuiPanel)new PanelTextBox((IGuiRect)new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(16, 8, 16, -32), 0), QuestTranslation.translate((String)this.translationTitleKey, (Object[])new Object[0])).setAlignment(1).setColor(PresetColor.TEXT_HEADER.getColor()));
        CanvasScrolling canvasScrolling = new CanvasScrolling((IGuiRect)new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 20, 0, 32), 0));
        canvas.addPanel((IGuiPanel)canvasScrolling);
        FactoryForestryDataControlArea dataArea = new FactoryForestryDataControlArea((IGuiCanvas)canvasScrolling, 0, 16, 160);
        dataArea.setLayout(1, 16).setPanels(this.getButtonsForChromosome(this.getChromosomeValue(), dataArea, gui)).buildCanvas();
        PanelVScrollBar vScrollBar = new PanelVScrollBar((IGuiRect)new GuiTransform(GuiAlign.RIGHT_EDGE, new GuiPadding(-8, 16, 0, 32), 0));
        canvasScrolling.setScrollDriverY((IValueIO)vScrollBar);
        vScrollBar.setScrollSpeed(ConfigHandler.cfgScrollSpeed);
        canvas.addPanel((IGuiPanel)vScrollBar);
        BQButton.ConfirmButton doneButton = new BQButton.ConfirmButton((IGuiRect)new GuiTransform(GuiAlign.BOTTOM_EDGE, new GuiPadding(4, -28, 4, 4), 0), -1, QuestTranslation.translate((String)"gui.done", (Object[])new Object[0])){

            public void onButtonClick() {
                UtilitiesBee.clearTraits(bee.getBaseStack(), TemplateToggleableChromosomes.this.getChromosomeValue());
                for (PanelToggleStorage panel : TemplateToggleableChromosomes.this.values) {
                    if (!panel.getToggledStatus()) continue;
                    UtilitiesBee.writeTrait(bee.getBaseStack(), TemplateToggleableChromosomes.this.getChromosomeValue(), panel.getStoredValue().toString());
                }
                gui.updateTaskItem(bee);
            }
        };
        canvas.addPanel((IGuiPanel)doneButton);
    }

    private IGuiPanel[] getButtonsForChromosome(EnumBeeChromosome chromosome, FactoryForestryDataControlArea factoryProvider, BQScreenCanvas gui) {
        this.values = new ArrayList();
        TreeMap<Integer, String> map = UtilitiesBee.getAllelesForChromosome(chromosome);
        for (Map.Entry<Integer, String> entry : map.entrySet()) {
            PanelToggleStorage newPanel = new PanelToggleStorage((IGuiRect)factoryProvider.getNextRect(), -1, entry.getValue().substring(StringUtils.indexOfFirstCapital(entry.getValue())), entry.getValue());
            if (Arrays.asList(UtilitiesBee.getTrait(gui.getSelectedItem(), chromosome, false)).contains(newPanel.getStoredValue().toString())) {
                newPanel.setToggledStatus(true);
            }
            this.values.add(newPanel);
        }
        return this.values.toArray(new IGuiPanel[0]);
    }
}

