/*
 * Decompiled with CFR 0.152.
 */
package com.nicjames2378.bqforestry.client.gui.editors.controls;

import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.CanvasEmpty;
import betterquesting.api2.client.gui.panels.IGuiCanvas;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.utils.QuestTranslation;
import com.nicjames2378.bqforestry.BQ_Forestry;

public class FactoryForestryDataControlArea {
    private IGuiPanel[] panels;
    private IGuiCanvas parent;
    private int x;
    private int y;
    private int w;
    private int height;
    private String titleText = "TITLE_NOT_SET";
    private int LAYOUT_SIZE_X = -1;
    private int LAYOUT_SIZE_Y = -1;
    private int LAYOUT_COLUMNS = -1;
    private int currentColumn = 0;
    private int currentRow = 0;

    public FactoryForestryDataControlArea(IGuiCanvas parent, int x, int y, int w) {
        this.parent = parent;
        this.x = x;
        this.y = y;
        this.w = w;
    }

    public FactoryForestryDataControlArea setPanels(IGuiPanel[] panels) {
        this.panels = panels;
        return this;
    }

    public IGuiPanel[] getPanels() {
        return this.panels;
    }

    public FactoryForestryDataControlArea setTitle(String title, boolean isLangKey) {
        this.titleText = isLangKey ? QuestTranslation.translate((String)title, (Object[])new Object[0]) : title;
        return this;
    }

    public GuiRectangle getNextRect() {
        return new GuiRectangle(this.getNextX(), this.getNextY() + 16, this.LAYOUT_SIZE_X, this.LAYOUT_SIZE_Y);
    }

    public int getHeight() {
        return this.height + 16;
    }

    private int getNextX() {
        int parentHalfWidth = this.parent.getTransform().getWidth() / 2;
        int factoryHalfWidth = this.LAYOUT_COLUMNS * this.LAYOUT_SIZE_X / 2;
        return parentHalfWidth - factoryHalfWidth + this.LAYOUT_SIZE_X * this.getCurrentColumn();
    }

    private int getNextY() {
        return this.LAYOUT_SIZE_Y * this.currentRow;
    }

    private int getCurrentColumn() {
        if (this.currentColumn > this.LAYOUT_COLUMNS - 1) {
            this.currentColumn = 0;
            ++this.currentRow;
        }
        int temp = this.currentColumn++;
        return temp;
    }

    public FactoryForestryDataControlArea setLayout(int columns, int sizeY) {
        if (this.LAYOUT_COLUMNS != -1) {
            BQ_Forestry.debug("Layout already set!");
            return this;
        }
        this.LAYOUT_SIZE_X = this.w / columns;
        this.LAYOUT_SIZE_Y = sizeY;
        this.LAYOUT_COLUMNS = columns;
        return this;
    }

    public CanvasEmpty buildCanvas() {
        this.height = 16 + (this.panels.length / this.LAYOUT_COLUMNS + (this.panels.length % this.LAYOUT_COLUMNS == 0 ? 0 : 1)) * this.LAYOUT_SIZE_Y;
        GuiRectangle rect = new GuiRectangle(this.x, this.y, this.w, this.height);
        CanvasEmpty built = new CanvasEmpty((IGuiRect)rect);
        this.parent.addPanel((IGuiPanel)built);
        for (IGuiPanel panel : this.panels) {
            built.addPanel(panel);
        }
        return built;
    }
}

