/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tickcentral.loading;

import com.github.terminatornl.tickcentral.TickCentral;
import com.github.terminatornl.tickcentral.api.TransformerSupplier;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraftforge.fml.relauncher.CoreModManager;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import net.minecraftforge.fml.relauncher.Side;

public class Loader {
    private final LinkedList<Map.Entry<Integer, TransformerSupplier>> suppliers = new LinkedList();
    private final LaunchClassLoader loader;
    private final Side side = FMLLaunchHandler.side();

    public LaunchClassLoader getClassLoader() {
        return this.loader;
    }

    public Loader() {
        this.loader = (LaunchClassLoader)this.getClass().getClassLoader();
        this.findTransformersInJarFiles();
        if (System.getProperty("net.minecraftforge.gradle.GradleStart.csvDir") != null) {
            this.findTransformersInDeobfuscatedEnvironment();
        }
        this.suppliers.sort(Map.Entry.comparingByKey());
        if (this.suppliers.size() > 0) {
            TickCentral.LOGGER.info("Loaded " + this.suppliers.size() + " addons.");
        } else {
            TickCentral.LOGGER.warn("Warning: No addons detected. TickCentral currently serves no purpose!");
        }
    }

    public void distributeCalls() throws Exception {
        for (Map.Entry entry : this.suppliers) {
            ((TransformerSupplier)entry.getValue()).call();
        }
    }

    public void distributeInject(Map<String, Object> fmlData) {
        for (Map.Entry entry : this.suppliers) {
            ((TransformerSupplier)entry.getValue()).injectData(fmlData);
        }
    }

    public LinkedList<Class<? extends IClassTransformer>> getLastClassTransformersTypes() {
        LinkedList<Class<? extends IClassTransformer>> list = new LinkedList<Class<? extends IClassTransformer>>();
        this.suppliers.forEach(e -> list.addAll(((TransformerSupplier)e.getValue()).getLastTransformers()));
        return list;
    }

    public LinkedList<String> getAllClassTransformers() {
        LinkedList<String> list = new LinkedList<String>();
        this.suppliers.forEach(e -> list.addAll(((TransformerSupplier)e.getValue()).getTransformers()));
        return list;
    }

    private void findTransformersInDeobfuscatedEnvironment() {
        TickCentral.LOGGER.info("We're in a deobfuscated environment! Looking for TickCentral-loadable.txt files");
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream("TickCentral-loadable.txt");
        if (stream != null) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            try {
                this.parseLoadables(reader, new File(this.getClass().getClassLoader().getResource("TickCentral-loadable.txt").toURI()));
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        } else {
            TickCentral.LOGGER.info("TickCentral-loadable.txt was not found!");
        }
    }

    private void findTransformersInJarFiles() {
        try {
            File modsDirectory;
            String fullPath = URLDecoder.decode(Loader.class.getProtectionDomain().getCodeSource().getLocation().getFile(), StandardCharsets.UTF_8.name());
            Pattern pattern = Pattern.compile("^(?:.+:)?(.+)!.*$");
            Matcher matcher = pattern.matcher(fullPath);
            if (!matcher.find()) {
                TickCentral.LOGGER.info("Unable to perform regex on string: " + fullPath);
                TickCentral.LOGGER.info("Assuming mods directory is in ./mods");
                modsDirectory = new File("./mods");
            } else {
                String jarOnly = matcher.group(1);
                modsDirectory = new File(jarOnly).getParentFile();
            }
            File[] potentialMods = modsDirectory.listFiles((dir, name) -> name.toLowerCase().endsWith(".jar"));
            if (potentialMods == null) {
                throw new IllegalStateException("modsDir.listFiles() returned null! Attempted to index: " + modsDirectory);
            }
            for (File file : potentialMods) {
                JarFile jar = new JarFile(file);
                ZipEntry transformerEntry = jar.getEntry("TickCentral-loadable.txt");
                if (transformerEntry == null) continue;
                BufferedReader reader = new BufferedReader(new InputStreamReader(jar.getInputStream(transformerEntry)));
                this.parseLoadables(reader, file);
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public void parseLoadables(BufferedReader reader, File file) throws Throwable {
        AtomicReference e = new AtomicReference();
        reader.lines().forEach(line -> {
            try {
                String loadable = line.trim();
                TickCentral.LOGGER.info("Loading: " + loadable);
                this.loader.addTransformerExclusion(loadable);
                this.loader.addURL(file.getAbsoluteFile().toURI().toURL());
                Class<?> clazz = Class.forName(loadable, true, (ClassLoader)this.loader);
                Object obj = clazz.newInstance();
                if (!(obj instanceof TransformerSupplier)) {
                    throw new IllegalArgumentException("Class " + obj.getClass().getName() + " is not an instance of " + TransformerSupplier.class.getName());
                }
                TransformerSupplier transformer = (TransformerSupplier)obj;
                CoreModManager.getReparseableCoremods().add(file.getName());
                transformer.onLoad(this.loader, this.side);
                this.suppliers.add(new AbstractMap.SimpleEntry<Integer, TransformerSupplier>(transformer.callOrder(), transformer));
            }
            catch (Throwable t) {
                e.set(t);
            }
        });
        reader.close();
        if (e.get() != null) {
            throw (Throwable)e.get();
        }
    }
}

