/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tickcentral.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class Config {
    public boolean DEBUG = false;
    public boolean SHOW_FORCED_LOADING = false;
    public int FILE_COUNT = 0;
    public final File FOLDER = new File("config", "TickCentral");
    public final File CONFIG_FILE = new File(this.FOLDER, "config.cfg");

    public Config() {
        try {
            if (!this.FOLDER.exists() && !this.FOLDER.mkdirs()) {
                throw new IOException("Unable to create directory: " + this.FOLDER);
            }
            if (!this.CONFIG_FILE.exists()) {
                Files.write(this.CONFIG_FILE.toPath(), IOUtils.toByteArray((InputStream)Config.class.getClassLoader().getResourceAsStream("assets/tickcentral/default_config.txt")), new OpenOption[0]);
            }
            for (String line : Files.readAllLines(this.CONFIG_FILE.toPath())) {
                String[] split;
                if ((line = line.trim()).isEmpty() || line.startsWith("#") || (split = line.split(" ?= ?", 2)).length != 2) continue;
                String subject = split[0].trim();
                String value = split[1].trim();
                if (subject.equalsIgnoreCase("SHOW_FORCED_LOADING")) {
                    this.SHOW_FORCED_LOADING = Boolean.parseBoolean(value);
                }
                if (subject.equalsIgnoreCase("DEBUG")) {
                    this.DEBUG = Boolean.parseBoolean(value);
                }
                if (!subject.equalsIgnoreCase("FILE_COUNT")) continue;
                this.FILE_COUNT = Integer.parseInt(value);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void save() throws IOException {
        HashMap<String, String> CURRENTS = new HashMap<String, String>();
        CURRENTS.put("SHOW_FORCED_LOADING", String.valueOf(this.SHOW_FORCED_LOADING));
        CURRENTS.put("DEBUG", String.valueOf(this.DEBUG));
        CURRENTS.put("FILE_COUNT", String.valueOf(this.FILE_COUNT));
        LinkedList<String> builder = new LinkedList<String>();
        for (String string : Files.readAllLines(this.CONFIG_FILE.toPath())) {
            String string2 = string.trim();
            if (string2.isEmpty() || string2.startsWith("#")) {
                builder.add(string2);
                continue;
            }
            String[] split = string2.split(" ?= ?", 2);
            if (split.length != 2) continue;
            String subject = split[0].trim().toUpperCase();
            String value = (String)CURRENTS.get(subject);
            if (value != null) {
                builder.add(subject + " = " + value);
                continue;
            }
            builder.add("# Unknown option: " + string2);
        }
        for (Map.Entry entry : CURRENTS.entrySet()) {
            builder.add((String)entry.getKey() + " = " + (String)entry.getValue());
        }
        Files.write(this.CONFIG_FILE.toPath(), builder, StandardOpenOption.TRUNCATE_EXISTING);
    }
}

