/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.modcompat.forestry.capability.recipehandler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import forestry.api.recipes.ISqueezerRecipe;
import forestry.factory.recipes.SqueezerRecipeManager;
import java.util.IdentityHashMap;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IPrototypedIngredientAlternatives;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.capability.recipehandler.PrototypedIngredientAlternativesList;
import org.cyclops.commoncapabilities.api.capability.recipehandler.RecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.commoncapabilities.modcompat.forestry.capability.recipehandler.CraftingProviderRecipeHandlerAdapter;

public class TileSqueezerRecipeHandler
extends CraftingProviderRecipeHandlerAdapter<ISqueezerRecipe> {
    public TileSqueezerRecipeHandler() {
        super(new SqueezerRecipeManager(), Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponent.ITEMSTACK}), Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponent.FLUIDSTACK}));
    }

    @Override
    protected IRecipeDefinition transformRecipe(ISqueezerRecipe recipe) {
        IdentityHashMap inputs = Maps.newIdentityHashMap();
        IdentityHashMap outputs = Maps.newIdentityHashMap();
        inputs.put(IngredientComponent.ITEMSTACK, Lists.newArrayList((Object[])new IPrototypedIngredientAlternatives[]{new PrototypedIngredientAlternativesList(recipe.getResources().stream().map(itemStack -> new PrototypedIngredient<ItemStack, Integer>(IngredientComponent.ITEMSTACK, (ItemStack)itemStack, 15)).collect(Collectors.toList()))}));
        outputs.put(IngredientComponent.FLUIDSTACK, Lists.newArrayList((Object[])new FluidStack[]{recipe.getFluidOutput()}));
        return new RecipeDefinition(inputs, new MixedIngredients(outputs));
    }

    @Override
    protected ISqueezerRecipe findRecipe(IMixedIngredients input) {
        NonNullList elements = NonNullList.func_191196_a();
        elements.addAll(input.getInstances(IngredientComponent.ITEMSTACK));
        return SqueezerRecipeManager.findMatchingRecipe((NonNullList)elements);
    }

    @Override
    public boolean isValidSizeInput(IngredientComponent<?, ?> component, int size) {
        return component == IngredientComponent.ITEMSTACK;
    }
}

