/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.block;

import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.dave.compactmachines3.block.BlockProtected;
import org.dave.compactmachines3.compat.ITopInfoProvider;
import org.dave.compactmachines3.init.Blockss;
import org.dave.compactmachines3.misc.CubeTools;
import org.dave.compactmachines3.tile.BaseTileEntityTunnel;
import org.dave.compactmachines3.tile.TileEntityMachine;
import org.dave.compactmachines3.utility.DimensionBlockPos;
import org.dave.compactmachines3.world.WorldSavedDataMachines;
import org.dave.compactmachines3.world.tools.DimensionTools;
import org.dave.compactmachines3.world.tools.StructureTools;

public abstract class BlockBaseTunnel
extends BlockProtected
implements ITileEntityProvider,
ITopInfoProvider {
    public static final PropertyDirection MACHINE_SIDE = PropertyDirection.func_177714_a((String)"machineside");

    public BlockBaseTunnel(Material material) {
        super(material);
        this.func_149713_g(1);
        this.func_149715_a(1.0f);
    }

    @Override
    public boolean isBlockProtected(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return CubeTools.shouldSideBeRendered(blockAccess, pos, side);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos whatblock) {
        super.func_189540_a(state, world, pos, blockIn, whatblock);
        if (world.field_72995_K) {
            return;
        }
        if (!(world.func_175625_s(pos) instanceof BaseTileEntityTunnel)) {
            return;
        }
        BaseTileEntityTunnel tunnel = (BaseTileEntityTunnel)world.func_175625_s(pos);
        if (tunnel.alreadyNotifiedOnTick) {
            return;
        }
        tunnel.alreadyNotifiedOnTick = true;
        this.notifyOverworldNeighbor(pos);
    }

    public void notifyOverworldNeighbor(BlockPos pos) {
        DimensionBlockPos dimpos = WorldSavedDataMachines.INSTANCE.machinePositions.get(StructureTools.getCoordsForPos(pos));
        if (dimpos == null) {
            return;
        }
        WorldServer realWorld = DimensionTools.getWorldServerForDimension(dimpos.getDimension());
        if (realWorld == null || !(realWorld.func_175625_s(dimpos.getBlockPos()) instanceof TileEntityMachine)) {
            return;
        }
        realWorld.func_175685_c(dimpos.getBlockPos(), (Block)Blockss.machine, false);
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileEntity te = world.func_175625_s(data.getPos());
        if (te instanceof BaseTileEntityTunnel) {
            BaseTileEntityTunnel tnt = (BaseTileEntityTunnel)te;
            String translate = "enumfacing." + ((EnumFacing)blockState.func_177229_b((IProperty)MACHINE_SIDE)).func_176610_l();
            probeInfo.horizontal().item(new ItemStack(Items.field_151111_aL), probeInfo.defaultItemStyle().width(14).height(14)).text(TextFormatting.YELLOW + "{*" + translate + "*}" + TextFormatting.RESET);
            ItemStack connectedStack = tnt.getConnectedPickBlock();
            if (connectedStack != null && !connectedStack.func_190926_b()) {
                probeInfo.horizontal().item(connectedStack, probeInfo.defaultItemStyle().width(14).height(14)).itemLabel(connectedStack);
            }
        }
    }
}

