/*
 * Decompiled with CFR 0.152.
 */
package net.insane96mcp.vulcanite.lib;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="vulcanite", category="", name="Vulcanite")
public class Properties {
    @Config.Name(value="Config")
    public static final ConfigOptions config = new ConfigOptions();

    @Mod.EventBusSubscriber(modid="vulcanite")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("vulcanite")) {
                ConfigManager.sync((String)"vulcanite", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static class ConfigOptions {
        @Config.Name(value="Tools and Weapons")
        public ToolsAndWeapons toolsAndWeapons = new ToolsAndWeapons();
        @Config.Name(value="Armor")
        public Armor armor = new Armor();
        @Config.Name(value="Ore Generation")
        public OreGeneration oreGeneration = new OreGeneration();
        @Config.Name(value="Vulcanite Block Time on Fire")
        @Config.Comment(value={"How much time will the Vulcanite Block set on fire mobs that are standing on it"})
        public int vulcaniteBlockTimeOnFire = 3;

        public static class OreGeneration {
            public Nether nether = new Nether();
            public Overworld overworld = new Overworld();

            public static class Overworld {
                @Config.Name(value="Veins Per Chunk")
                @Config.Comment(value={"Number of veins that have to try to spawn per chunk"})
                public int veinPerChunk = 0;
                @Config.Name(value="Ore Per Vein")
                @Config.Comment(value={"Number of ores per vein"})
                public int orePerVein = 15;
                @Config.Name(value="Min Y")
                @Config.Comment(value={"The minimum height (Y) to try to generate Veins"})
                @Config.RangeInt(min=0, max=128)
                public int minY = 11;
                @Config.Name(value="Max Y")
                @Config.Comment(value={"The maximum height (Y) to try to generate Veins"})
                @Config.RangeInt(min=0, max=128)
                public int maxY = 14;
                @Config.Name(value="Minimum Lava Required")
                @Config.Comment(value={"How many lava blocks should be near vulcanite to be able to spawn?"})
                public int minLavaRequired = 5;
                @Config.Name(value="Min Nugget Drop")
                @Config.Comment(value={"Minimum amount of nuggets that Vulcanite ore drops"})
                public int minNuggetDrop = 1;
                @Config.Name(value="Max Nugger Drop")
                @Config.Comment(value={"Maximum amount of nuggets that Vulcanite ore drops without fortune"})
                public int maxNuggetDrop = 2;
            }

            public static class Nether {
                @Config.Name(value="Ore Per Vein")
                @Config.Comment(value={"Number of ores generated per vein"})
                public int orePerVein = 4;
                @Config.Name(value="Veins Per Chunk")
                @Config.Comment(value={"Number of veins that have to try to spawn per chunk"})
                public int veinPerChunk = 12;
                @Config.Name(value="Min Y")
                @Config.Comment(value={"The minimum height (Y) to try to generate Veins"})
                @Config.RangeInt(min=0, max=128)
                public int minY = 0;
                @Config.Name(value="Max Y")
                @Config.Comment(value={"The maximum height (Y) to try to generate Veins"})
                @Config.RangeInt(min=0, max=128)
                public int maxY = 32;
            }
        }

        public static class Armor {
            @Config.Name(value="Damage Reduction in Nether")
            @Config.Comment(value={"Percentage damage reduction from hot sources with full Vulcanite Armor in the Nether"})
            @Config.RangeDouble(min=0.0, max=100.0)
            public float damageReductionNether = 70.0f;
            @Config.Name(value="Damage Reduction in Other Dimensions")
            @Config.Comment(value={"Percentage damage reduction from hot sources with full Vulcanite Armor in non-Nether dimensions"})
            @Config.RangeDouble(min=0.0, max=100.0)
            public float damageReductionOther = 40.0f;
        }

        public static class ToolsAndWeapons {
            @Config.Name(value="Bonus Stats")
            public BonusStats bonusStats = new BonusStats();
            @Config.Name(value="Flint and Vulcanite")
            public FlintAndVulcanite flintAndVulcanite = new FlintAndVulcanite();

            public static class FlintAndVulcanite {
                @Config.Name(value="Seconds on Fire")
                @Config.Comment(value={"The number of seconds an entity will be set on fire when right clicked with Flint and Vulcanite"})
                public int secondsOnFire = 4;
                @Config.Name(value="Damage on set on Fire")
                @Config.Comment(value={"How much uses will be consumed on the flint and vulcanite when you set a mob on fire"})
                @Config.RangeInt(min=0, max=222)
                public int damageOnUse = 2;
                @Config.Name(value="TnT Ignites Faster")
                @Config.Comment(value={"If true TNT will take half the time to explode when ignited with Flint and Vulcanite"})
                public boolean tntIgnitesFaster = true;
            }

            public static class BonusStats {
                @Config.Name(value="Bonus Damage")
                @Config.Comment(value={"Bonus damage % dealt to Fire Immune mobs"})
                public float damage = 15.0f;
                @Config.Name(value="Bonus Damage with Fire Aspect")
                @Config.Comment(value={"Bonus damage % dealt to Fire Immune mobs per Fire Aspect Level (to sum to 'bonus_damage')"})
                public float damageFireAspect = 7.5f;
                @Config.Name(value="Should Drop Experience")
                @Config.Comment(value={"If the smelting property of the tools should make the blocks broken drop experience"})
                public boolean shouldDropExperience = true;
                @Config.Name(value="Bonus Efficiency")
                @Config.Comment(value={"Bonus Efficency % for tools when in the nether (100.0 means that the tool will be twice as fast in the nether)"})
                public float efficencyInNether = 50.0f;
            }
        }
    }
}

