/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.integration.appeng.recipe;

import appeng.api.AEApi;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IRecipeInfo;
import thelm.packagedauto.integration.appeng.AppEngUtil;

public class RecipeCraftingPatternHelper
implements ICraftingPatternDetails {
    public final ItemStack recipeHolder;
    public final IRecipeInfo recipe;
    public final IAEItemStack[] inputs;
    public final IAEItemStack[] outputs;
    public final IAEItemStack[] condensedInputs;
    public final IAEItemStack[] condensedOutputs;

    public RecipeCraftingPatternHelper(ItemStack recipeHolder, IRecipeInfo recipe) {
        this.recipeHolder = recipeHolder;
        this.recipe = recipe;
        IItemStorageChannel storageChannel = (IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class);
        this.inputs = (IAEItemStack[])recipe.getPatterns().stream().map(IPackagePattern::getOutput).map(arg_0 -> ((IItemStorageChannel)storageChannel).createStack(arg_0)).toArray(IAEItemStack[]::new);
        this.outputs = (IAEItemStack[])recipe.getOutputs().stream().map(arg_0 -> ((IItemStorageChannel)storageChannel).createStack(arg_0)).toArray(IAEItemStack[]::new);
        this.condensedInputs = AppEngUtil.condenseStacks(this.inputs);
        this.condensedOutputs = AppEngUtil.condenseStacks(this.outputs);
    }

    public ItemStack getPattern() {
        return this.recipeHolder;
    }

    public boolean isValidItemForSlot(int slotIndex, ItemStack itemStack, World world) {
        throw new IllegalStateException("Not supported.");
    }

    public boolean isCraftable() {
        return false;
    }

    public IAEItemStack[] getInputs() {
        return this.inputs;
    }

    public IAEItemStack[] getOutputs() {
        return this.outputs;
    }

    public IAEItemStack[] getCondensedInputs() {
        return this.condensedInputs;
    }

    public IAEItemStack[] getCondensedOutputs() {
        return this.condensedOutputs;
    }

    public boolean canSubstitute() {
        return false;
    }

    public ItemStack getOutput(InventoryCrafting craftingInv, World world) {
        throw new IllegalStateException("Not supported.");
    }

    public int getPriority() {
        return 0;
    }

    public void setPriority(int priority) {
    }

    public boolean equals(Object obj) {
        if (obj instanceof RecipeCraftingPatternHelper) {
            RecipeCraftingPatternHelper other = (RecipeCraftingPatternHelper)obj;
            return this.recipe.equals(other.recipe);
        }
        return false;
    }

    public int hashCode() {
        return this.recipe.hashCode();
    }
}

