/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.api;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntRBTreeMap;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IRecipeInfo;
import thelm.packagedauto.api.IRecipeType;
import thelm.packagedauto.api.RecipeTypeRegistry;

public class MiscUtil {
    private static final Cache<NBTTagCompound, IRecipeInfo> RECIPE_CACHE = CacheBuilder.newBuilder().maximumSize(500L).build();
    private static final Logger LOGGER = LogManager.getLogger();

    private MiscUtil() {
    }

    public static List<ItemStack> condenseStacks(IInventory inventory) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(inventory.func_70302_i_());
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            stacks.add(inventory.func_70301_a(i));
        }
        return MiscUtil.condenseStacks(stacks);
    }

    public static List<ItemStack> condenseStacks(IItemHandler itemHandler) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(itemHandler.getSlots());
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            stacks.add(itemHandler.getStackInSlot(i));
        }
        return MiscUtil.condenseStacks(stacks);
    }

    public static List<ItemStack> condenseStacks(ItemStack ... stacks) {
        return MiscUtil.condenseStacks(Arrays.asList(stacks));
    }

    public static List<ItemStack> condenseStacks(Stream<ItemStack> stacks) {
        return MiscUtil.condenseStacks(stacks.collect(Collectors.toList()));
    }

    public static List<ItemStack> condenseStacks(Iterable<ItemStack> stacks) {
        return MiscUtil.condenseStacks(stacks instanceof List ? (List)stacks : Lists.newArrayList(stacks));
    }

    public static List<ItemStack> condenseStacks(List<ItemStack> stacks) {
        Object2IntRBTreeMap map = new Object2IntRBTreeMap((triple1, triple2) -> Triple.of((Object)((Item)triple1.getLeft()).getRegistryName(), (Object)triple1.getMiddle(), (Object)("" + triple1.getRight())).compareTo(Triple.of((Object)((Item)triple2.getLeft()).getRegistryName(), (Object)triple2.getMiddle(), (Object)("" + triple2.getRight()))));
        for (ItemStack stack : stacks) {
            if (stack.func_190926_b()) continue;
            Triple triple = Triple.of((Object)stack.func_77973_b(), (Object)stack.func_77960_j(), (Object)stack.func_77978_p());
            if (!map.containsKey((Object)triple)) {
                map.put((Object)triple, 0);
            }
            map.addTo((Object)triple, stack.func_190916_E());
        }
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (Object2IntMap.Entry entry : map.object2IntEntrySet()) {
            int limit;
            Triple triple = (Triple)entry.getKey();
            Item item = (Item)triple.getLeft();
            int meta = (Integer)triple.getMiddle();
            NBTTagCompound nbt = (NBTTagCompound)triple.getRight();
            for (int count = entry.getIntValue(); count > 0; count -= limit) {
                ItemStack toAdd = new ItemStack(item, 1, meta);
                toAdd.func_77982_d(nbt);
                limit = item.getItemStackLimit(toAdd);
                toAdd.func_190920_e(Math.min(count, limit));
                list.add(toAdd);
            }
        }
        return list;
    }

    public static NBTTagList saveAllItems(NBTTagList tagList, List<ItemStack> list) {
        for (int i = 0; i < list.size(); ++i) {
            ItemStack stack = list.get(i);
            boolean empty = stack.func_190926_b();
            if (empty && i != list.size() - 1) continue;
            if (empty) {
                stack = ItemStack.field_190927_a;
            }
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74774_a("Index", (byte)i);
            stack.func_77955_b(nbt);
            tagList.func_74742_a((NBTBase)nbt);
        }
        return tagList;
    }

    public static void loadAllItems(NBTTagList tagList, List<ItemStack> list) {
        list.clear();
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound nbt = tagList.func_150305_b(i);
            int j = nbt.func_74771_c("Index") & 0xFF;
            while (j >= list.size()) {
                list.add(ItemStack.field_190927_a);
            }
            if (j < 0) continue;
            ItemStack stack = new ItemStack(nbt);
            list.set(j, stack.func_190926_b() ? ItemStack.field_190927_a : stack);
        }
    }

    public static IPackagePattern getPatternHelper(IRecipeInfo recipeInfo, int index) {
        try {
            Class<?> helperClass = Class.forName("thelm.packagedauto.util.PatternHelper.PatternHelper");
            Constructor<?> helperConstructor = helperClass.getConstructor(IRecipeInfo.class, Integer.TYPE);
            return (IPackagePattern)helperConstructor.newInstance(recipeInfo, index);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<ItemStack> getRemainingItems(IInventory inventory) {
        return MiscUtil.getRemainingItems(IntStream.range(0, inventory.func_70302_i_()).mapToObj(arg_0 -> ((IInventory)inventory).func_70301_a(arg_0)).collect(Collectors.toList()));
    }

    public static List<ItemStack> getRemainingItems(IInventory inventory, int minInclusive, int maxExclusive) {
        return MiscUtil.getRemainingItems(IntStream.range(minInclusive, maxExclusive).mapToObj(arg_0 -> ((IInventory)inventory).func_70301_a(arg_0)).collect(Collectors.toList()));
    }

    public static List<ItemStack> getRemainingItems(ItemStack ... stacks) {
        return MiscUtil.getRemainingItems(Arrays.asList(stacks));
    }

    public static List<ItemStack> getRemainingItems(List<ItemStack> stacks) {
        NonNullList ret = NonNullList.func_191197_a((int)stacks.size(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < ret.size(); ++i) {
            ret.set(i, (Object)MiscUtil.getContainerItem(stacks.get(i)));
        }
        return ret;
    }

    public static ItemStack getContainerItem(ItemStack stack) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (stack.func_77973_b().hasContainerItem(stack)) {
            if (!(stack = stack.func_77973_b().getContainerItem(stack)).func_190926_b() && stack.func_77984_f() && stack.func_77960_j() > stack.func_77958_k()) {
                return ItemStack.field_190927_a;
            }
            return stack;
        }
        if (stack.func_190916_E() > 1) {
            stack = stack.func_77946_l();
            stack.func_190920_e(stack.func_190916_E() - 1);
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack cloneStack(ItemStack stack, int stackSize) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack retStack = stack.func_77946_l();
        retStack.func_190920_e(stackSize);
        return retStack;
    }

    public static boolean isEmpty(IItemHandler itemHandler) {
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            if (itemHandler.getStackInSlot(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public static NBTTagCompound writeRecipeToNBT(NBTTagCompound nbt, IRecipeInfo recipe) {
        nbt.func_74778_a("RecipeType", recipe.getRecipeType().getName().toString());
        recipe.writeToNBT(nbt);
        return nbt;
    }

    public static IRecipeInfo readRecipeFromNBT(NBTTagCompound nbt) {
        IRecipeInfo recipe = (IRecipeInfo)RECIPE_CACHE.getIfPresent((Object)nbt);
        if (recipe != null && recipe.isValid()) {
            return recipe;
        }
        IRecipeType recipeType = RecipeTypeRegistry.getRecipeType(new ResourceLocation(nbt.func_74779_i("RecipeType")));
        if (recipeType != null) {
            recipe = recipeType.getNewRecipeInfo();
            recipe.readFromNBT(nbt);
            RECIPE_CACHE.put((Object)nbt, (Object)recipe);
            if (recipe.isValid()) {
                return recipe;
            }
        }
        return null;
    }
}

