/*
 * Decompiled with CFR 0.152.
 */
package com.sosnitzka.taiga;

import java.io.File;
import java.util.ArrayList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class TAIGAConfiguration {
    public static final String CATEGORY_NAME_GENERAL = "category_general";
    public static final String CATEGORY_NAME_ORE_GEN = "category_ore_gen";
    public static boolean ironGen;
    public static boolean endGen;
    public static boolean tiberiumGen;
    public static boolean prometheumGen;
    public static boolean valyriumGen;
    public static boolean osramGen;
    public static boolean duraniteGen;
    public static boolean basaltGen;
    public static boolean eezoGen;
    public static boolean karmesineGen;
    public static boolean oviumGen;
    public static boolean jauxumGen;
    public static boolean vibraniumGen;
    public static boolean uruGen;
    public static boolean auroriumGen;
    public static boolean palladiumGen;
    public static boolean abyssumGen;
    public static int IRON_VAL;
    public static int TIBERIUM_VAL;
    public static int PROMETHEUM_VAL;
    public static int VALYRIUM_VAL;
    public static int OSRAM_VAL;
    public static int DURANITE_VAL;
    public static int BASALT_VAL;
    public static int EEZO_VAL;
    public static int KARMESINE_VAL;
    public static int OVIUM_VAL;
    public static int JAUXUM_VAL;
    public static int VIBRANIUM_VAL;
    public static int DILITHIUM_VAL;
    public static int URU_VAL;
    public static int AURORIUM_VAL;
    public static int PALLADIUM_VAL;
    public static int ABYSSUM_VAL;
    private static Configuration config;

    public static void preInit() {
        File configFile = new File(Loader.instance().getConfigDir(), "TAIGA.cfg");
        config = new Configuration(configFile);
        TAIGAConfiguration.syncFromFile();
    }

    public static void clientPreInit() {
        MinecraftForge.EVENT_BUS.register((Object)new ConfigEventHandler());
    }

    public static Configuration getConfig() {
        return config;
    }

    public static void syncFromFile() {
        TAIGAConfiguration.syncConfig(true, true);
    }

    public static void syncFromGUI() {
        TAIGAConfiguration.syncConfig(false, true);
    }

    private static void syncConfig(boolean loadConfigFromFile, boolean readFieldsFromConfig) {
        if (loadConfigFromFile) {
            config.load();
        }
        boolean RESFAC_MIN_VALUE = false;
        int RESFAC_MAX_VALUE = 100;
        int IRON_DEFAULT = 20;
        int TIBERIUM_DEFAULT = 15;
        int PROMETHEUM_DEFAULT = 18;
        int VALYRIUM_DEFAULT = 10;
        int DILITHIUM_DEFAULT = 12;
        boolean OSRAM_DEFAULT = true;
        boolean DURANITE_DEFAULT = true;
        int BASALT_DEFAULT = 12;
        int EEZO_DEFAULT = 3;
        int KARMESINE_DEFAULT = 8;
        int JAUXUM_DEFAULT = 8;
        int OVIUM_DEFAULT = 8;
        int VIBRANIUM_DEFAULT = 8;
        boolean URU_DEFAULT = true;
        int AURORIUM_DEFAULT = 10;
        int PALLADIUM_DEFAULT = 10;
        int ABYSSUM_DEFAULT = 4;
        Property ironSwitch = config.get(CATEGORY_NAME_GENERAL, "Additional Iron", false);
        ironSwitch.setComment("Switch additional ore on/off");
        ironSwitch.setLanguageKey("gui.taiga_configuration.gen_iron");
        Property endSwitch = config.get(CATEGORY_NAME_GENERAL, "Additional Endstone", true);
        endSwitch.setComment("Switch additional endstone on/off");
        endSwitch.setLanguageKey("gui.taiga_configuration.gen_end");
        ArrayList<String> propOrderGeneral = new ArrayList<String>();
        propOrderGeneral.add(ironSwitch.getName());
        propOrderGeneral.add(endSwitch.getName());
        config.setCategoryPropertyOrder(CATEGORY_NAME_GENERAL, propOrderGeneral);
        Property ironValueProp = config.get(CATEGORY_NAME_ORE_GEN, "Iron", 20, "generation count per chunk", 0, 100);
        ironValueProp.setLanguageKey("gui.taiga_configuration.iron_multiplier");
        Property basaltValueProp = config.get(CATEGORY_NAME_ORE_GEN, "Basalt", 12, "generation count per chunk", 0, 100);
        basaltValueProp.setLanguageKey("gui.taiga_configuration.basalt_multiplier");
        Property tiberiumValueProp = config.get(CATEGORY_NAME_ORE_GEN, "Tiberium", 15, "generation count per chunk", 0, 100);
        tiberiumValueProp.setLanguageKey("gui.taiga_configuration.tiberium_multiplier");
        Property auroriumValueProp = config.get(CATEGORY_NAME_ORE_GEN, "Aurorium", 10, "generation count per chunk", 0, 100);
        auroriumValueProp.setLanguageKey("gui.taiga_configuration.aurorium_multiplier");
        Property prometheumValueProp = config.get(CATEGORY_NAME_ORE_GEN, "Prometheum", 18, "generation count per chunk", 0, 100);
        prometheumValueProp.setLanguageKey("gui.taiga_configuration.prometheum_multiplier");
        Property duraniteValueProp = config.get(CATEGORY_NAME_ORE_GEN, "Duranite", 1, "generation count per chunk", 0, 100);
        duraniteValueProp.setLanguageKey("gui.taiga_configuration.duranite_multiplier");
        Property valyriumValueProp = config.get(CATEGORY_NAME_ORE_GEN, "Valyrium", 10, "generation count per chunk", 0, 100);
        valyriumValueProp.setLanguageKey("gui.taiga_configuration.valyrium_multiplier");
        Property vibraniumValueProp = config.get(CATEGORY_NAME_ORE_GEN, "Vibranium", 8, "generation count per chunk", 0, 100);
        vibraniumValueProp.setLanguageKey("gui.taiga_configuration.vibranium_multiplier");
        Property dilithiumValueProp = config.get(CATEGORY_NAME_ORE_GEN, "Dilithium", 12, "generation count per chunk", 0, 100);
        dilithiumValueProp.setLanguageKey("gui.taiga_configuration.dilithium_multiplier");
        Property karmesineValueProp = config.get(CATEGORY_NAME_ORE_GEN, "Karmesine", 8, "generation count per chunk", 0, 100);
        karmesineValueProp.setLanguageKey("gui.taiga_configuration.karmesine_multiplier");
        Property oviumValueProp = config.get(CATEGORY_NAME_ORE_GEN, "Ovium", 8, "generation count per chunk", 0, 100);
        oviumValueProp.setLanguageKey("gui.taiga_configuration.ovium_multiplier");
        Property jauxumValueProp = config.get(CATEGORY_NAME_ORE_GEN, "Jauxum", 8, "generation count per chunk", 0, 100);
        jauxumValueProp.setLanguageKey("gui.taiga_configuration.jauxum_multiplier");
        Property palladiumValueProp = config.get(CATEGORY_NAME_ORE_GEN, "Palladium", 10, "generation count per chunk", 0, 100);
        palladiumValueProp.setLanguageKey("gui.taiga_configuration.palladium_multiplier");
        Property uruValueProp = config.get(CATEGORY_NAME_ORE_GEN, "Uru", 1, "generation count per chunk", 0, 100);
        uruValueProp.setLanguageKey("gui.taiga_configuration.uru_multiplier");
        Property osramValueProp = config.get(CATEGORY_NAME_ORE_GEN, "Osram", 1, "generation count per chunk", 0, 100);
        osramValueProp.setLanguageKey("gui.taiga_configuration.osram_multiplier");
        Property abyssumValueProp = config.get(CATEGORY_NAME_ORE_GEN, "Abyssum", 4, "generation count per chunk", 0, 100);
        abyssumValueProp.setLanguageKey("gui.taiga_configuration.abyssum_multiplier");
        Property eezoValueProp = config.get(CATEGORY_NAME_ORE_GEN, "Eezo", 3, "generation count per chunk", 0, 100);
        eezoValueProp.setLanguageKey("gui.taiga_configuration.eezo_multiplier");
        ArrayList<String> propOrderOreGen = new ArrayList<String>();
        propOrderOreGen.add(ironValueProp.getName());
        propOrderOreGen.add(basaltValueProp.getName());
        propOrderOreGen.add(tiberiumValueProp.getName());
        propOrderOreGen.add(auroriumValueProp.getName());
        propOrderOreGen.add(prometheumValueProp.getName());
        propOrderOreGen.add(duraniteValueProp.getName());
        propOrderOreGen.add(valyriumValueProp.getName());
        propOrderOreGen.add(vibraniumValueProp.getName());
        propOrderOreGen.add(dilithiumValueProp.getName());
        propOrderOreGen.add(karmesineValueProp.getName());
        propOrderOreGen.add(oviumValueProp.getName());
        propOrderOreGen.add(jauxumValueProp.getName());
        propOrderOreGen.add(palladiumValueProp.getName());
        propOrderOreGen.add(uruValueProp.getName());
        propOrderOreGen.add(osramValueProp.getName());
        propOrderOreGen.add(abyssumValueProp.getName());
        propOrderOreGen.add(eezoValueProp.getName());
        config.setCategoryPropertyOrder(CATEGORY_NAME_ORE_GEN, propOrderOreGen);
        if (readFieldsFromConfig) {
            ironGen = ironSwitch.getBoolean(false);
            endGen = endSwitch.getBoolean(true);
            IRON_VAL = ironValueProp.getInt(20);
            if (IRON_VAL > 100 || IRON_VAL < 0) {
                IRON_VAL = 20;
            }
            if ((TIBERIUM_VAL = tiberiumValueProp.getInt(15)) > 100 || TIBERIUM_VAL < 0) {
                TIBERIUM_VAL = 15;
            }
            if ((PROMETHEUM_VAL = prometheumValueProp.getInt(18)) > 100 || PROMETHEUM_VAL < 0) {
                PROMETHEUM_VAL = 18;
            }
            if ((VALYRIUM_VAL = valyriumValueProp.getInt(10)) > 100 || VALYRIUM_VAL < 0) {
                VALYRIUM_VAL = 10;
            }
            if ((OSRAM_VAL = osramValueProp.getInt(1)) > 100 || OSRAM_VAL < 0) {
                OSRAM_VAL = 1;
            }
            if ((DURANITE_VAL = duraniteValueProp.getInt(1)) > 100 || DURANITE_VAL < 0) {
                DURANITE_VAL = 1;
            }
            if ((BASALT_VAL = basaltValueProp.getInt(12)) > 100 || BASALT_VAL < 0) {
                BASALT_VAL = 12;
            }
            if ((EEZO_VAL = eezoValueProp.getInt(3)) > 100 || EEZO_VAL < 0) {
                EEZO_VAL = 3;
            }
            if ((KARMESINE_VAL = karmesineValueProp.getInt(8)) > 100 || KARMESINE_VAL < 0) {
                KARMESINE_VAL = 8;
            }
            if ((OVIUM_VAL = oviumValueProp.getInt(8)) > 100 || OVIUM_VAL < 0) {
                OVIUM_VAL = 8;
            }
            if ((JAUXUM_VAL = jauxumValueProp.getInt(8)) > 100 || JAUXUM_VAL < 0) {
                JAUXUM_VAL = 8;
            }
            if ((VIBRANIUM_VAL = vibraniumValueProp.getInt(8)) > 100 || VIBRANIUM_VAL < 0) {
                VIBRANIUM_VAL = 8;
            }
            if ((DILITHIUM_VAL = dilithiumValueProp.getInt(12)) > 100 || DILITHIUM_VAL < 0) {
                DILITHIUM_VAL = 12;
            }
            if ((URU_VAL = uruValueProp.getInt(1)) > 100 || URU_VAL < 0) {
                URU_VAL = 1;
            }
            if ((AURORIUM_VAL = auroriumValueProp.getInt(10)) > 100 || AURORIUM_VAL < 0) {
                AURORIUM_VAL = 10;
            }
            if ((PALLADIUM_VAL = palladiumValueProp.getInt(10)) > 100 || PALLADIUM_VAL < 0) {
                PALLADIUM_VAL = 10;
            }
            if ((ABYSSUM_VAL = abyssumValueProp.getInt(4)) > 100 || ABYSSUM_VAL < 0) {
                ABYSSUM_VAL = 4;
            }
        }
        ironSwitch.set(ironGen);
        endSwitch.set(endGen);
        ironValueProp.set(IRON_VAL);
        tiberiumValueProp.set(TIBERIUM_VAL);
        prometheumValueProp.set(PROMETHEUM_VAL);
        valyriumValueProp.set(VALYRIUM_VAL);
        osramValueProp.set(OSRAM_VAL);
        duraniteValueProp.set(DURANITE_VAL);
        basaltValueProp.set(BASALT_VAL);
        eezoValueProp.set(EEZO_VAL);
        karmesineValueProp.set(KARMESINE_VAL);
        oviumValueProp.set(OVIUM_VAL);
        jauxumValueProp.set(JAUXUM_VAL);
        vibraniumValueProp.set(VIBRANIUM_VAL);
        dilithiumValueProp.set(DILITHIUM_VAL);
        uruValueProp.set(URU_VAL);
        auroriumValueProp.set(AURORIUM_VAL);
        palladiumValueProp.set(PALLADIUM_VAL);
        abyssumValueProp.set(ABYSSUM_VAL);
        if (config.hasChanged()) {
            config.save();
        }
    }

    static {
        config = null;
    }

    public static class ConfigEventHandler {
        @SubscribeEvent(priority=EventPriority.NORMAL)
        public void onEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
            if ("taiga".equals(event.getModID()) && !event.isWorldRunning() && (event.getConfigID().equals(TAIGAConfiguration.CATEGORY_NAME_GENERAL) || event.getConfigID().equals(TAIGAConfiguration.CATEGORY_NAME_ORE_GEN))) {
                TAIGAConfiguration.syncFromGUI();
            }
        }
    }
}

