/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.processor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.WorldServer;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.processor.ChunkProcess;

public class ChunkCalculator {
    public static final ChunkComparator comparator = new ChunkComparator();

    public static Map<FilePos, Set<FilePos>> createcircleExt(int xPos, int zPos, int minRadius, int maxRadius) {
        LinkedHashMap<FilePos, Set<FilePos>> storage = new LinkedHashMap<FilePos, Set<FilePos>>();
        for (int x = -maxRadius; x < maxRadius; ++x) {
            for (int z = -maxRadius; z < maxRadius; ++z) {
                FilePos pos = new FilePos(x + xPos, z + zPos);
                double radius = pos.getSqDistance(xPos, zPos);
                if (radius > (double)maxRadius || radius < (double)minRadius) continue;
                ChunkCalculator.addToCompressor(storage, pos);
            }
        }
        return storage;
    }

    public static Map<FilePos, Set<FilePos>> createcircle(int xPos, int zPos, int radius) {
        LinkedHashMap<FilePos, Set<FilePos>> storage = new LinkedHashMap<FilePos, Set<FilePos>>();
        for (int x = -radius; x < radius; ++x) {
            for (int z = -radius; z < radius; ++z) {
                FilePos pos = new FilePos(x + xPos, z + zPos);
                if (pos.getSqDistance(xPos, zPos) > (double)radius) continue;
                ChunkCalculator.addToCompressor(storage, pos);
            }
        }
        return storage;
    }

    public static Map<FilePos, Set<FilePos>> createSquareExt(int xPos, int zPos, int minRadius, int maxRadius) {
        LinkedHashMap<FilePos, Set<FilePos>> storage = new LinkedHashMap<FilePos, Set<FilePos>>();
        for (int x = -maxRadius; x < maxRadius; ++x) {
            for (int z = -maxRadius; z < maxRadius; ++z) {
                if (x > -minRadius && x <= minRadius && z > -minRadius && z <= minRadius) continue;
                ChunkCalculator.addToCompressor(storage, new FilePos(x + xPos, z + zPos));
            }
        }
        return storage;
    }

    public static Map<FilePos, Set<FilePos>> createSquare(int xPos, int zPos, int radius) {
        LinkedHashMap<FilePos, Set<FilePos>> storage = new LinkedHashMap<FilePos, Set<FilePos>>();
        for (int x = -radius; x < radius; ++x) {
            for (int z = -radius; z < radius; ++z) {
                ChunkCalculator.addToCompressor(storage, new FilePos(x + xPos, z + zPos));
            }
        }
        return storage;
    }

    public static Map<FilePos, Set<FilePos>> createArea(int xStart, int zStart, int xEnd, int zEnd) {
        LinkedHashMap<FilePos, Set<FilePos>> storage = new LinkedHashMap<FilePos, Set<FilePos>>();
        int centerX = xStart + (xEnd - xStart) / 2;
        int centerZ = zStart + (zEnd - zStart) / 2;
        for (int x = xStart; x < xEnd; ++x) {
            for (int z = zStart; z < zEnd; ++z) {
                ChunkCalculator.addToCompressor(storage, new FilePos(x, z));
            }
        }
        return storage;
    }

    public static Map<FilePos, Set<FilePos>> createcircleArea(int xStart, int zStart, int xEnd, int zEnd, int centerX, int centerZ, int radius) {
        LinkedHashMap<FilePos, Set<FilePos>> storage = new LinkedHashMap<FilePos, Set<FilePos>>();
        for (int x = xStart; x < xEnd; ++x) {
            for (int z = zStart; z < zEnd; ++z) {
                FilePos pos = new FilePos(x, z);
                if (pos.getSqDistance(centerX, centerZ) > (double)radius) continue;
                ChunkCalculator.addToCompressor(storage, pos);
            }
        }
        return storage;
    }

    private static void addToCompressor(Map<FilePos, Set<FilePos>> storage, FilePos pos) {
        FilePos chunkFile = pos.toChunkFile();
        Set<FilePos> list = storage.get(chunkFile);
        if (list == null) {
            list = new LinkedHashSet<FilePos>();
            storage.put(chunkFile, list);
        }
        list.add(pos);
    }

    public static ChunkProcess createProcess(WorldServer world, Map<FilePos, Set<FilePos>> storage, FilePos center) {
        comparator.setCenter(center);
        ArrayList<FilePos> list = new ArrayList<FilePos>(storage.keySet());
        Collections.sort(list, comparator);
        ChunkProcess task = new ChunkProcess(world);
        task.addTaskList(list, storage);
        return task;
    }

    public static class ChunkComparator
    implements Comparator<FilePos> {
        FilePos center = new FilePos(0, 0);

        public void setCenter(FilePos pos) {
            this.center = pos.toChunkFile();
        }

        @Override
        public int compare(FilePos o1, FilePos o2) {
            int second;
            int first = o1.getDistance(this.center.x, this.center.z);
            if (first > (second = o2.getDistance(this.center.x, this.center.z))) {
                return 1;
            }
            if (second > first) {
                return -1;
            }
            return 0;
        }
    }
}

