/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.network.packets.chunkRequest;

import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import pregenerator.ChunkPregenerator;
import pregenerator.base.api.network.IReadableBuffer;
import pregenerator.base.api.network.IWriteableBuffer;
import pregenerator.base.api.network.PregenPacket;
import pregenerator.impl.tracking.ChunkEntry;
import pregenerator.impl.tracking.CollectorMap;
import pregenerator.impl.tracking.ServerTracker;
import pregenerator.impl.tracking.WorldTracker;

public class KillWorldRequest
extends PregenPacket {
    int dim;
    String type;
    boolean tiles;

    public KillWorldRequest() {
    }

    public KillWorldRequest(int dim, String s, boolean tile) {
        this.dim = dim;
        this.type = s;
        this.tiles = tile;
    }

    @Override
    public void read(IReadableBuffer buffer) {
        this.tiles = buffer.readBoolean();
        this.dim = buffer.readInt();
        this.type = ChunkEntry.readString(buffer);
    }

    @Override
    public void write(IWriteableBuffer buffer) {
        buffer.writeBoolean(this.tiles);
        buffer.writeInt(this.dim);
        ChunkEntry.writeString(this.type, buffer);
    }

    @Override
    public void handle(final EntityPlayer player) {
        MinecraftServer server = ChunkPregenerator.getServer();
        if (!server.func_152345_ab()) {
            server.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    KillWorldRequest.this.process(player);
                }
            });
            return;
        }
        this.process(player);
    }

    public void process(EntityPlayer player) {
        WorldTracker tracker = ServerTracker.INSTANCE.getWorld(this.dim);
        if (tracker == null) {
            ChunkPregenerator.pregenBase.sendChatMessage((ICommandSender)player, "Dimension [" + this.dim + "] not loaded on the Server");
            return;
        }
        if (this.tiles) {
            Class clz = (Class)ChunkEntry.registry.func_82594_a((Object)new ResourceLocation(this.type));
            if (clz == null) {
                ChunkPregenerator.pregenBase.sendChatMessage((ICommandSender)player, "TileEntity [" + this.type + "] doesn't exist on the Server");
                return;
            }
            CollectorMap<TileEntity> map = new CollectorMap<TileEntity>();
            map.addAll(tracker.getTileList());
            int removed = 0;
            for (TileEntity tile : map.getAllOfType(clz)) {
                tracker.world.func_175698_g(tile.func_174877_v());
                ++removed;
            }
            ChunkPregenerator.pregenBase.sendChatMessage((ICommandSender)player, "Removed " + removed + " TileEntities of type [" + this.type + "]");
        } else {
            Class clz = EntityList.getClass((ResourceLocation)new ResourceLocation(this.type));
            if (clz == null) {
                ChunkPregenerator.pregenBase.sendChatMessage((ICommandSender)player, "Entity [" + this.type + "] doesn't exist on the Server");
                return;
            }
            CollectorMap<Entity> map = new CollectorMap<Entity>();
            map.addAll(tracker.getEntityList());
            List list = map.getAllOfType(clz);
            for (Entity e : list) {
                e.func_70106_y();
            }
            ChunkPregenerator.pregenBase.sendChatMessage((ICommandSender)player, "Removed " + list.size() + " Entities of type [" + this.type + "]");
        }
    }
}

