/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.network.packets;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import pregenerator.ChunkPregenerator;
import pregenerator.base.api.network.IReadableBuffer;
import pregenerator.base.api.network.IWriteableBuffer;
import pregenerator.base.api.network.PregenPacket;
import pregenerator.impl.client.infos.InfoEntry;
import pregenerator.impl.network.packets.AnswerPacket;

public class RequestPacket
extends PregenPacket {
    List<InfoEntry> entries = new ArrayList<InfoEntry>();

    public RequestPacket() {
    }

    public RequestPacket(List<InfoEntry> list) {
        this.entries.addAll(list);
    }

    @Override
    public void read(IReadableBuffer buffer) {
        int amount = buffer.readByte();
        for (int i = 0; i < amount; ++i) {
            InfoEntry entry = InfoEntry.getByID(buffer.readByte());
            if (entry == null) continue;
            this.entries.add(entry);
        }
    }

    @Override
    public void write(IWriteableBuffer buffer) {
        buffer.writeByte(this.entries.size());
        for (InfoEntry entry : this.entries) {
            buffer.writeByte(entry.getID());
        }
    }

    @Override
    public void handle(EntityPlayer player) {
        ChunkPregenerator.networking.sendPacketToPlayer(new AnswerPacket(this.entries), player);
    }
}

