/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.base.impl.misc;

import java.util.ArrayList;
import java.util.List;

public class SelectionList<V> {
    List<V> values = new ArrayList<V>();
    int index = 0;
    boolean noLoop = false;

    public SelectionList() {
    }

    public SelectionList(List<V> values) {
        this.setValues(values);
    }

    public SelectionList setNoLoop() {
        this.noLoop = true;
        return this;
    }

    public void setValues(List<V> value) {
        if (this.values.isEmpty()) {
            this.index = 0;
            this.values.addAll(value);
            return;
        }
        V last = this.values.get(this.index);
        this.values.clear();
        this.values.addAll(value);
        this.index = Math.max(0, this.values.indexOf(last));
    }

    public void addValues(List<V> list) {
        this.values.addAll(list);
    }

    public void addValue(V value) {
        this.values.add(value);
    }

    public int getIndex() {
        return this.index;
    }

    public int size() {
        return this.values.size();
    }

    public List<V> getValues() {
        return this.values;
    }

    public V getValue(int index) {
        return index < 0 || index >= this.values.size() ? null : (V)this.values.get(index);
    }

    public V getValue() {
        return this.values.isEmpty() ? null : (V)this.values.get(this.index);
    }

    public V removeIndex(int index) {
        V value = this.values.remove(index);
        this.setIndex(this.index);
        return value;
    }

    public void setIndex(int index) {
        this.index = Math.max(0, Math.min(index, this.values.size() - 1));
    }

    public void setIndexFromValue(V value) {
        this.index = Math.max(0, this.values.indexOf(value));
    }

    public void next() {
        ++this.index;
        if (this.index >= this.values.size()) {
            this.index = this.noLoop ? this.values.size() - 1 : 0;
        }
    }

    public void prev() {
        --this.index;
        if (this.index < 0) {
            this.index = Math.max(0, this.noLoop ? 0 : this.values.size() - 1);
        }
    }

    public void clear() {
        this.index = 0;
        this.values.clear();
    }
}

