/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.tile.data;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.network.MessageTileDataParameter;
import com.raoulvdberge.refinedstorage.tile.data.TileDataManager;
import com.raoulvdberge.refinedstorage.tile.data.TileDataParameter;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileDataWatcher {
    private boolean sentInitial;
    private EntityPlayerMP player;
    private TileDataManager manager;
    private Object[] cache;

    public TileDataWatcher(EntityPlayerMP player, TileDataManager manager) {
        this.player = player;
        this.manager = manager;
        if (manager != null) {
            this.manager.addWatcher(this);
            this.cache = new Object[manager.getWatchedParameters().size()];
        }
    }

    public EntityPlayerMP getPlayer() {
        return this.player;
    }

    public void onClosed() {
        this.manager.removeWatcher(this);
    }

    public void detectAndSendChanges() {
        if (!this.sentInitial) {
            this.manager.getParameters().forEach(p -> this.sendParameter(true, (TileDataParameter)p));
            this.sentInitial = true;
        } else {
            for (int i = 0; i < this.manager.getWatchedParameters().size(); ++i) {
                Object cached;
                TileDataParameter parameter = this.manager.getWatchedParameters().get(i);
                Object real = parameter.getValueProducer().apply(this.manager.getTile());
                if (real.equals(cached = this.cache[i])) continue;
                this.cache[i] = real;
                if (cached == null) continue;
                this.sendParameter(false, parameter);
            }
        }
    }

    public void sendParameter(boolean initial, TileDataParameter parameter) {
        RS.INSTANCE.network.sendTo((IMessage)new MessageTileDataParameter(this.manager.getTile(), parameter, initial), this.player);
    }
}

