/*
 * Decompiled with CFR 0.152.
 */
package net.modcrafters.mclib.inventory.implementations;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.modcrafters.mclib.ingredients.IFluidIngredient;
import net.modcrafters.mclib.ingredients.IMachineIngredient;
import net.modcrafters.mclib.inventory.IFluidInventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0015\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lnet/modcrafters/mclib/inventory/implementations/FluidInventory;", "Lnet/modcrafters/mclib/inventory/IFluidInventory;", "key", "", "handler", "Lnet/minecraftforge/fluids/capability/IFluidHandler;", "(Ljava/lang/String;Lnet/minecraftforge/fluids/capability/IFluidHandler;)V", "getKey", "()Ljava/lang/String;", "slots", "", "getSlots", "()I", "extractFluid", "Lnet/minecraftforge/fluids/FluidStack;", "ingredient", "Lnet/modcrafters/mclib/ingredients/IMachineIngredient;", "fromSlot", "simulate", "", "getSlotContent", "slot", "tesla-core-lib"})
public final class FluidInventory
implements IFluidInventory {
    @NotNull
    private final String key;
    private final IFluidHandler handler;

    @Override
    public int getSlots() {
        return this.handler.getTankProperties().length;
    }

    @Override
    @Nullable
    public FluidStack getSlotContent(int slot) {
        IFluidTankProperties iFluidTankProperties = this.handler.getTankProperties()[slot];
        Intrinsics.checkExpressionValueIsNotNull((Object)iFluidTankProperties, (String)"this.handler.tankProperties[slot]");
        return iFluidTankProperties.getContents();
    }

    @Override
    @Nullable
    public FluidStack extractFluid(@NotNull IMachineIngredient ingredient, int fromSlot, boolean simulate) {
        Intrinsics.checkParameterIsNotNull((Object)ingredient, (String)"ingredient");
        IMachineIngredient iMachineIngredient = ingredient;
        return iMachineIngredient instanceof IFluidIngredient ? this.handler.drain(((IFluidIngredient)ingredient).getFluidStack(), !simulate) : null;
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    public FluidInventory(@NotNull String key, @NotNull IFluidHandler handler) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
        this.key = key;
        this.handler = handler;
    }

    @Override
    public int extract(@NotNull IMachineIngredient ingredient, int fromSlot, boolean simulate) {
        Intrinsics.checkParameterIsNotNull((Object)ingredient, (String)"ingredient");
        return IFluidInventory.DefaultImpls.extract(this, ingredient, fromSlot, simulate);
    }

    @Override
    @NotNull
    public IMachineIngredient getIngredient(int slot) {
        return IFluidInventory.DefaultImpls.getIngredient(this, slot);
    }
}

