/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vliblegacy.m_guide.client.elements;

import com.valkyrieofnight.vliblegacy.lib.client.gui.elements.VLElement;
import com.valkyrieofnight.vliblegacy.lib.client.gui.elements.VLElementIndex;
import com.valkyrieofnight.vliblegacy.lib.client.gui.elements.container.VLContScissorPane;
import com.valkyrieofnight.vliblegacy.lib.client.gui.elements.container.dynamic.VLContFixedXDynY;
import com.valkyrieofnight.vliblegacy.lib.client.gui.elements.container.list.VLContListVFixedX;
import com.valkyrieofnight.vliblegacy.lib.client.gui.elements.image.VLElementImage;
import com.valkyrieofnight.vliblegacy.lib.client.util.GridAlignment;
import com.valkyrieofnight.vliblegacy.m_guide.client.elements.ButtonMain;
import com.valkyrieofnight.vliblegacy.m_guide.client.elements.ButtonMetro;
import com.valkyrieofnight.vliblegacy.m_guide.client.elements.GuiGuidePage;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;

public abstract class ModGuide
extends VLContScissorPane {
    protected GuideIndex index;
    int test = 0;
    public static final String TOC = ".page.toc";

    public ModGuide(String elementID) {
        super(elementID);
    }

    public void setGuidePageSize(int xSize, int ySize) {
        this.xSize = xSize;
        this.ySize = ySize;
    }

    @Override
    public void preInit() {
        this.index = new GuideIndex(this, "index");
        this.addElement(this.index);
        this.index.setXSize(this.xSize);
    }

    public GuideTOCPage getMainMenu() {
        return this.index.pageTOC;
    }

    public boolean home() {
        this.resetScroll();
        return this.index.home();
    }

    public void next() {
        this.index.next();
        this.resetScroll();
    }

    public boolean hasNext() {
        return this.index.hasNextIndex();
    }

    public void prev() {
        this.index.prev();
        this.resetScroll();
    }

    public boolean hasPrev() {
        return this.index.hasPrevIndex();
    }

    public abstract VLElementImage getMainMenuLogo();

    public abstract ButtonMetro getButton();

    public static class GuideTOCMenu
    extends VLContFixedXDynY {
        public GuideIndex index;
        public GuideTOCPage menuPage;
        protected GridAlignment menuGrid;
        protected int buttonXSize = 100;
        protected int buttonYSize = 20;
        protected int buttonXSpacing = 4;
        protected int buttonYSpacing = 4;
        private boolean initMenuButtonSize = false;

        public GuideTOCMenu(String elementID, GuideIndex index, GuideTOCPage page) {
            super(elementID + ModGuide.TOC, index.pageXSize);
            this.menuPage = page;
            this.index = index;
        }

        public void setSpacing(int xSpacing, int ySpacing) {
            this.buttonXSpacing = xSpacing;
            this.buttonYSpacing = ySpacing;
        }

        @Override
        public void addElements() {
        }

        public void addMenuButton(String address, List<ItemStack> stack, String text) {
            if (!this.initMenuButtonSize) {
                this.initMenuButtonSize = true;
                this.buttonXSize = (this.xSize - 4) / 2;
                this.menuGrid = new GridAlignment(this.buttonXSize, this.buttonYSize, this.buttonXSpacing, this.buttonYSpacing, 2, GridAlignment.Alignment.VERTICAL);
            }
            ButtonMain n = new ButtonMain(address, this.menuGrid.getCurrentXOffset(), this.menuGrid.getCurrentYOffset() + 4, this.buttonXSize, this.buttonYSize, stack, text);
            this.menuGrid.next();
            this.addElement(n);
            this.onElementResize(n);
        }

        @Override
        public void mouseClicked(VLElement ele, int mx, int my, int mouseButton) {
            if (mouseButton == 0) {
                this.index.setIndex(ele.getID());
            }
        }

        @Override
        public void mouseScrolled(VLElement ele, int mx, int my, int scroll) {
        }

        @Override
        public void keyTyped(VLElement ele, char character, int keyCode) {
        }
    }

    public static class GuideTOCPage
    extends VLContListVFixedX {
        public GuideIndex index;
        public GuideTOCMenu menu;

        public GuideTOCPage(String eleID, GuideIndex index, int xSize) {
            super(eleID, xSize);
            this.index = index;
        }

        @Override
        protected void preInit() {
            this.setXPosOffset(4);
            this.setYPosOffset(4);
        }

        @Override
        public void addElements() {
            VLElementImage e = this.index.guide.getMainMenuLogo();
            this.addElement(e);
            this.menu = new GuideTOCMenu(this.elementID + ".menu", this.index, this);
            this.addElement(this.menu);
            this.menu.setXSize(this.xSize - 8);
            this.menu.setSpacing(4, 4);
        }

        public void addMenuButton(String address, List<ItemStack> stacks, String loc) {
            this.menu.addMenuButton(address, stacks, loc);
        }

        public void addPage(GuiGuidePage page) {
            this.index.addIndex(page);
        }
    }

    private static class GuideIndex
    extends VLElementIndex {
        protected ModGuide guide;
        protected GuideTOCPage pageTOC;
        protected int pageXSize;
        protected int pageYSize;
        int test = 0;

        public GuideIndex(ModGuide guide, String elementID) {
            super(elementID);
            this.guide = guide;
        }

        @Override
        public boolean setIndex(String indexID) {
            if (this.hasIndex(indexID)) {
                this.currentIndex = indexID;
                int sy = -this.getIndex(this.currentIndex).getYSize() + this.guide.getYSize() - 8;
                if (sy < 0) {
                    this.guide.setScrollMin(0, sy);
                } else {
                    this.guide.setScrollMin(0, 0);
                }
                return true;
            }
            return false;
        }

        @Override
        public void addIndex(VLElement index) {
            super.addIndex(index);
        }

        @Override
        public void init() {
            this.pageTOC = new GuideTOCPage(this.elementID + ModGuide.TOC, this, this.guide.getXSize());
            this.addIndex(this.pageTOC);
            this.pageTOC.setXSize(this.guide.getXSize());
        }

        @Override
        public void onElementResize(@Nonnull VLElement ele) {
            if (ele.getYPosActualLargest() > this.getYPosActualLargest()) {
                this.ySize = ele.getXPosOffsetLargest();
            }
            this.gui.onElementResize(ele);
        }

        @Override
        public void mouseClicked(VLElement ele, int mx, int my, int mouseButton) {
        }

        public boolean home() {
            if (this.isCurrentIndex(this.pageTOC.getID())) {
                return true;
            }
            this.setIndex(this.pageTOC.getID());
            return false;
        }

        public void next() {
            if (this.hasNextIndex()) {
                this.setIndex(this.getNextIndex());
            }
        }

        public void prev() {
            if (this.hasPrevIndex()) {
                this.setIndex(this.getPrevIndex());
            }
        }
    }
}

