/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.huntingdim.events;

import net.darkhax.bookshelf.lib.Constants;
import net.darkhax.bookshelf.util.StackUtils;
import net.darkhax.huntingdim.events.EventLoader;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class EventData {
    private final String event;
    private final ItemStack[] heldItems;
    private final ItemStack[] wornItems;

    public EventData(NBTTagCompound tag) {
        this.event = tag.func_74779_i("Event");
        this.heldItems = this.readItems(tag, "HeldItems");
        this.wornItems = this.readItems(tag, "WornItems");
    }

    public String getName() {
        return this.event;
    }

    public ItemStack[] getHeldItems() {
        return this.heldItems;
    }

    public ItemStack[] getWornItems() {
        return this.wornItems;
    }

    public ItemStack getRandomHeld() {
        return this.heldItems[Constants.RANDOM.nextInt(this.heldItems.length)];
    }

    public ItemStack getRandomWorn() {
        return this.wornItems[Constants.RANDOM.nextInt(this.wornItems.length)];
    }

    private ItemStack[] readItems(NBTTagCompound tag, String name) {
        NBTTagList list = tag.func_150295_c(name, 10);
        ItemStack[] items = new ItemStack[list.func_74745_c()];
        for (int i = 0; i < items.length; ++i) {
            items[i] = new ItemStack(list.func_150305_b(i));
            StackUtils.appendLore((ItemStack)items[i], (String[])new String[]{this.event + " " + EventLoader.year});
        }
        return items;
    }
}

