/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.huntingdim.block;

import com.google.common.cache.LoadingCache;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Random;
import net.darkhax.bookshelf.block.IColorfulBlock;
import net.darkhax.bookshelf.lib.Constants;
import net.darkhax.bookshelf.util.WorldUtils;
import net.darkhax.huntingdim.HuntingDimension;
import net.darkhax.huntingdim.Messages;
import net.darkhax.huntingdim.dimension.TeleporterHunting;
import net.darkhax.huntingdim.event.EntityTravelToDimensionEventWrapped;
import net.darkhax.huntingdim.handler.ConfigurationHandler;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockWorldState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockPattern;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockHuntingPortal
extends BlockPortal
implements IColorfulBlock {
    private final Method playSound = ReflectionHelper.findMethod(EntityLiving.class, (String)"getAmbientSound", (String)"func_184639_G", (Class[])new Class[0]);

    public BlockHuntingPortal() {
        this.func_149722_s();
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149715_a(0.75f);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (worldIn.func_82736_K().func_82766_b("doMobSpawning") && ConfigurationHandler.chanceSpawn > 0 && rand.nextInt(ConfigurationHandler.chanceSpawn) < worldIn.func_175659_aa().func_151525_a()) {
            EntityLiving living;
            BlockPos blockpos = pos;
            while (!worldIn.func_180495_p(blockpos).isSideSolid((IBlockAccess)worldIn, blockpos, EnumFacing.UP) && blockpos.func_177956_o() > 0) {
                blockpos = blockpos.func_177977_b();
            }
            if (blockpos.func_177956_o() > 0 && !worldIn.func_180495_p(blockpos.func_177984_a()).func_185915_l() && (living = this.getMobForChunk(worldIn, pos)) != null) {
                living.func_70012_b((double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 1.1, (double)blockpos.func_177952_p() + 0.5, MathHelper.func_76142_g((float)(worldIn.field_73012_v.nextFloat() * 360.0f)), 0.0f);
                living.field_70759_as = living.field_70177_z;
                living.field_70761_aq = living.field_70177_z;
                living.func_180482_a(worldIn.func_175649_E(new BlockPos((Entity)living)), (IEntityLivingData)null);
                worldIn.func_72838_d((Entity)living);
                living.func_70642_aH();
            }
        }
    }

    public boolean func_176548_d(World worldIn, BlockPos pos) {
        FrameBuilder frameBuilder = new FrameBuilder(worldIn, pos, EnumFacing.Axis.X);
        if (frameBuilder.isValid() && frameBuilder.portalBlockCount == 0) {
            frameBuilder.placePortalBlocks();
            return true;
        }
        frameBuilder = new FrameBuilder(worldIn, pos, EnumFacing.Axis.Z);
        if (frameBuilder.isValid() && frameBuilder.portalBlockCount == 0) {
            frameBuilder.placePortalBlocks();
            return true;
        }
        return false;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        FrameBuilder frameBuilder;
        EnumFacing.Axis axis = (EnumFacing.Axis)state.func_177229_b((IProperty)field_176550_a);
        if (axis == EnumFacing.Axis.X) {
            FrameBuilder frameBuilder2 = new FrameBuilder(worldIn, pos, EnumFacing.Axis.X);
            if (!frameBuilder2.isValid() || frameBuilder2.portalBlockCount < frameBuilder2.width * frameBuilder2.height) {
                worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            }
        } else if (!(axis != EnumFacing.Axis.Z || (frameBuilder = new FrameBuilder(worldIn, pos, EnumFacing.Axis.Z)).isValid() && frameBuilder.portalBlockCount >= frameBuilder.width * frameBuilder.height)) {
            worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (worldIn.field_72995_K || !entityIn.func_70093_af()) {
            return;
        }
        if (entityIn instanceof EntityPlayerMP) {
            int dimension;
            EntityPlayerMP player = (EntityPlayerMP)entityIn;
            if (entityIn.func_184218_aH() || entityIn.func_184207_aI()) {
                Messages.TELEPORTER_MOUNTED.sendMessage((ICommandSender)player, new Object[0]);
            }
            int n = dimension = player.field_71093_bK == ConfigurationHandler.dimensionId ? ConfigurationHandler.returnDimension : ConfigurationHandler.dimensionId;
            if (EntityTravelToDimensionEventWrapped.onTravelToDimension((Entity)player, dimension)) {
                player.func_70095_a(false);
                if (!WorldUtils.isDimension((World)player.func_130014_f_(), (DimensionType)HuntingDimension.dimensionType)) {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 100, 4, true, false));
                }
                player.field_71133_b.func_184103_al().transferPlayerToDimension(player, dimension, (Teleporter)new TeleporterHunting(player.field_71133_b.func_71218_a(dimension), HuntingDimension.frame.func_176223_P(), this.func_176223_P()));
            } else {
                Messages.TELEPORTER_CANCELED.sendMessage((ICommandSender)player, new Object[0]);
            }
        } else {
            if (entityIn instanceof ICommandSender) {
                Messages.TELEPORTER_INVALID_PLAYER.sendMessage((ICommandSender)entityIn, new Object[0]);
            }
            HuntingDimension.LOG.info("Could not teleport {} because they are an invalid player entity! Class is {}", new Object[]{entityIn.func_145748_c_().func_150260_c(), entityIn.getClass().toString()});
        }
    }

    private EntityLiving getMobForChunk(World world, BlockPos pos) {
        Biome.SpawnListEntry entry;
        List validMobs;
        Biome biome = world.func_180494_b(pos);
        if (biome != null && (validMobs = biome.func_76747_a(EnumCreatureType.MONSTER)) != null && !validMobs.isEmpty() && (entry = (Biome.SpawnListEntry)validMobs.get(Constants.RANDOM.nextInt(validMobs.size()))) != null) {
            try {
                EntityLiving entity = entry.newInstance(world);
                if (entity instanceof EntityLiving) {
                    return entity;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        EntityLiving living;
        if (ConfigurationHandler.chanceSound > 0 && rand.nextInt(ConfigurationHandler.chanceSound) == 0 && (living = this.getMobForChunk(worldIn, pos)) != null) {
            try {
                SoundEvent sound = (SoundEvent)this.playSound.invoke((Object)living, new Object[0]);
                if (sound != null) {
                    worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, sound, SoundCategory.HOSTILE, 0.5f, rand.nextFloat() * 0.4f + 0.8f, false);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException sound) {
                // empty catch block
            }
            living.func_70106_y();
        }
        for (int i = 0; i < 4; ++i) {
            double x = (float)pos.func_177958_n() + rand.nextFloat();
            double y = (float)pos.func_177956_o() + rand.nextFloat();
            double z = (float)pos.func_177952_p() + rand.nextFloat();
            worldIn.func_175688_a(EnumParticleTypes.SPELL_MOB, x, y, z, ConfigurationHandler.defaultColorVector.field_72450_a, ConfigurationHandler.defaultColorVector.field_72448_b, ConfigurationHandler.defaultColorVector.field_72449_c, new int[0]);
        }
    }

    public BlockPattern.PatternHelper func_181089_f(World worldIn, BlockPos position) {
        EnumFacing.Axis axis = EnumFacing.Axis.Z;
        FrameBuilder frameBuilder = new FrameBuilder(worldIn, position, EnumFacing.Axis.X);
        LoadingCache loadingcache = BlockPattern.func_181627_a((World)worldIn, (boolean)true);
        if (!frameBuilder.isValid()) {
            axis = EnumFacing.Axis.X;
            frameBuilder = new FrameBuilder(worldIn, position, EnumFacing.Axis.Z);
        }
        if (!frameBuilder.isValid()) {
            return new BlockPattern.PatternHelper(position, EnumFacing.NORTH, EnumFacing.UP, loadingcache, 1, 1, 1);
        }
        int[] aint = new int[EnumFacing.AxisDirection.values().length];
        EnumFacing enumfacing = frameBuilder.rightDir.func_176735_f();
        BlockPos blockpos = frameBuilder.bottomLeft.func_177981_b(frameBuilder.getHeight() - 1);
        for (EnumFacing.AxisDirection orientation : EnumFacing.AxisDirection.values()) {
            BlockPattern.PatternHelper patternHelper = new BlockPattern.PatternHelper(enumfacing.func_176743_c() == orientation ? blockpos : blockpos.func_177967_a(frameBuilder.rightDir, frameBuilder.getWidth() - 1), EnumFacing.func_181076_a((EnumFacing.AxisDirection)orientation, (EnumFacing.Axis)axis), EnumFacing.UP, loadingcache, frameBuilder.getWidth(), frameBuilder.getHeight(), 1);
            for (int i = 0; i < frameBuilder.getWidth(); ++i) {
                for (int j = 0; j < frameBuilder.getHeight(); ++j) {
                    BlockWorldState blockworldstate = patternHelper.func_177670_a(i, j, 1);
                    if (blockworldstate.func_177509_a() == null || blockworldstate.func_177509_a().func_185904_a() == Material.field_151579_a) continue;
                    int n = orientation.ordinal();
                    aint[n] = aint[n] + 1;
                }
            }
        }
        EnumFacing.AxisDirection enumfacing$axisdirection1 = EnumFacing.AxisDirection.POSITIVE;
        for (EnumFacing.AxisDirection enumfacing$axisdirection2 : EnumFacing.AxisDirection.values()) {
            if (aint[enumfacing$axisdirection2.ordinal()] >= aint[enumfacing$axisdirection1.ordinal()]) continue;
            enumfacing$axisdirection1 = enumfacing$axisdirection2;
        }
        return new BlockPattern.PatternHelper(enumfacing.func_176743_c() == enumfacing$axisdirection1 ? blockpos : blockpos.func_177967_a(frameBuilder.rightDir, frameBuilder.getWidth() - 1), EnumFacing.func_181076_a((EnumFacing.AxisDirection)enumfacing$axisdirection1, (EnumFacing.Axis)axis), EnumFacing.UP, loadingcache, frameBuilder.getWidth(), frameBuilder.getHeight(), 1);
    }

    public IBlockColor getColorHandler() {
        return (state, world, pos, index) -> ConfigurationHandler.defaultColorPacked;
    }

    public static class FrameBuilder {
        private final World world;
        private final EnumFacing.Axis axis;
        private final EnumFacing rightDir;
        private final EnumFacing leftDir;
        private int portalBlockCount;
        private BlockPos bottomLeft;
        private int height;
        private int width;

        public FrameBuilder(World worldIn, BlockPos position, EnumFacing.Axis axis) {
            this.world = worldIn;
            this.axis = axis;
            if (axis == EnumFacing.Axis.X) {
                this.leftDir = EnumFacing.EAST;
                this.rightDir = EnumFacing.WEST;
            } else {
                this.leftDir = EnumFacing.NORTH;
                this.rightDir = EnumFacing.SOUTH;
            }
            BlockPos blockpos = position;
            while (position.func_177956_o() > blockpos.func_177956_o() - 21 && position.func_177956_o() > 0 && this.isEmptyBlock(worldIn.func_180495_p(position.func_177977_b()))) {
                position = position.func_177977_b();
            }
            int i = this.getDistanceUntilEdge(position, this.leftDir) - 1;
            if (i >= 0) {
                this.bottomLeft = position.func_177967_a(this.leftDir, i);
                this.width = this.getDistanceUntilEdge(this.bottomLeft, this.rightDir);
                if (this.width < 2 || this.width > 21) {
                    this.bottomLeft = null;
                    this.width = 0;
                }
            }
            if (this.bottomLeft != null) {
                this.height = this.calculatePortalHeight();
            }
        }

        protected int getDistanceUntilEdge(BlockPos p_180120_1_, EnumFacing p_180120_2_) {
            BlockPos blockpos;
            int i;
            for (i = 0; i < 22 && this.isEmptyBlock(this.world.func_180495_p(blockpos = p_180120_1_.func_177967_a(p_180120_2_, i))) && this.world.func_180495_p(blockpos.func_177977_b()).func_177230_c() == HuntingDimension.frame; ++i) {
            }
            Block block = this.world.func_180495_p(p_180120_1_.func_177967_a(p_180120_2_, i)).func_177230_c();
            return block == HuntingDimension.frame ? i : 0;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        protected int calculatePortalHeight() {
            this.height = 0;
            block0: while (this.height < 21) {
                for (int i = 0; i < this.width; ++i) {
                    BlockPos blockpos = this.bottomLeft.func_177967_a(this.rightDir, i).func_177981_b(this.height);
                    Block block = this.world.func_180495_p(blockpos).func_177230_c();
                    if (!this.isEmptyBlock(this.world.func_180495_p(blockpos))) break block0;
                    if (block == HuntingDimension.portal) {
                        ++this.portalBlockCount;
                    }
                    if (i == 0 ? (block = this.world.func_180495_p(blockpos.func_177972_a(this.leftDir)).func_177230_c()) != HuntingDimension.frame : i == this.width - 1 && (block = this.world.func_180495_p(blockpos.func_177972_a(this.rightDir)).func_177230_c()) != HuntingDimension.frame) break block0;
                }
                ++this.height;
            }
            for (int j = 0; j < this.width; ++j) {
                if (this.world.func_180495_p(this.bottomLeft.func_177967_a(this.rightDir, j).func_177981_b(this.height)).func_177230_c() == HuntingDimension.frame) continue;
                this.height = 0;
                break;
            }
            if (this.height <= 21 && this.height >= 3) {
                return this.height;
            }
            this.bottomLeft = null;
            this.width = 0;
            this.height = 0;
            return 0;
        }

        protected boolean isEmptyBlock(IBlockState blockIn) {
            return blockIn.func_185904_a() == Material.field_151579_a || blockIn.func_177230_c() == Blocks.field_150480_ab || blockIn.func_177230_c() == HuntingDimension.portal;
        }

        public boolean isValid() {
            return this.bottomLeft != null && this.width >= 2 && this.width <= 21 && this.height >= 3 && this.height <= 21;
        }

        public void placePortalBlocks() {
            for (int i = 0; i < this.width; ++i) {
                BlockPos blockpos = this.bottomLeft.func_177967_a(this.rightDir, i);
                for (int j = 0; j < this.height; ++j) {
                    this.world.func_180501_a(blockpos.func_177981_b(j), HuntingDimension.portal.func_176223_P().func_177226_a((IProperty)BlockPortal.field_176550_a, (Comparable)this.axis), 2);
                }
            }
        }
    }
}

