/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.util.nbt;

import com.google.common.collect.Lists;
import hellfirepvp.modularmachinery.common.util.nbt.NBTComparableNumber;
import hellfirepvp.modularmachinery.common.util.nbt.NBTPatternString;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public class NBTMatchingHelper {
    public static boolean matchNBTCompound(@Nullable NBTTagCompound matchNBT, @Nullable NBTTagCompound itemStackNBTToCheck) {
        if (matchNBT == null) {
            return true;
        }
        if (itemStackNBTToCheck == null) {
            return matchNBT.func_150296_c().isEmpty();
        }
        return NBTMatchingHelper.matchCompound(matchNBT, itemStackNBTToCheck);
    }

    private static boolean matchBase(NBTBase matchBase, NBTBase matchStack) {
        if (matchBase instanceof NBTComparableNumber) {
            return matchStack instanceof NBTPrimitive && ((NBTComparableNumber)matchBase).test((NBTPrimitive)matchStack);
        }
        if (matchBase instanceof NBTPatternString) {
            return matchStack instanceof NBTTagString && ((NBTPatternString)matchBase).testString(((NBTTagString)matchStack).func_150285_a_());
        }
        if (matchBase instanceof NBTTagCompound) {
            return matchStack instanceof NBTTagCompound && NBTMatchingHelper.matchCompound((NBTTagCompound)matchBase, (NBTTagCompound)matchStack);
        }
        if (matchBase instanceof NBTTagList) {
            return matchStack instanceof NBTTagList && NBTMatchingHelper.matchList((NBTTagList)matchBase, (NBTTagList)matchStack);
        }
        if (matchBase instanceof NBTTagByteArray) {
            return matchStack instanceof NBTTagByteArray && Arrays.equals(((NBTTagByteArray)matchBase).func_150292_c(), ((NBTTagByteArray)matchStack).func_150292_c());
        }
        if (matchBase instanceof NBTTagIntArray) {
            return matchStack instanceof NBTTagIntArray && Arrays.equals(((NBTTagIntArray)matchBase).func_150302_c(), ((NBTTagIntArray)matchStack).func_150302_c());
        }
        return matchBase.equals((Object)matchStack);
    }

    private static boolean matchCompound(NBTTagCompound matchNBT, NBTTagCompound itemStackNBTToCheck) {
        for (String keyMatch : matchNBT.func_150296_c()) {
            if (itemStackNBTToCheck.func_74764_b(keyMatch)) {
                NBTBase baseStack;
                NBTBase baseOriginal = matchNBT.func_74781_a(keyMatch);
                if (NBTMatchingHelper.matchBase(baseOriginal, baseStack = itemStackNBTToCheck.func_74781_a(keyMatch))) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private static boolean matchList(NBTTagList baseOriginal, NBTTagList baseStack) {
        if (baseOriginal.func_74745_c() == 0) {
            return true;
        }
        if (baseStack.func_74745_c() == 0) {
            return false;
        }
        if (baseOriginal.func_150303_d() != baseStack.func_150303_d()) {
            return false;
        }
        ArrayList copyConsumeTags = Lists.newArrayList((Iterable)baseStack);
        block0: for (NBTBase entryBase : baseOriginal) {
            for (NBTBase stackBase : copyConsumeTags) {
                if (!NBTMatchingHelper.matchBase(entryBase, stackBase)) continue;
                copyConsumeTags.remove(stackBase);
                continue block0;
            }
            return false;
        }
        return true;
    }
}

