/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.tiles;

import cofh.redstoneflux.api.IEnergyReceiver;
import cofh.redstoneflux.api.IEnergyStorage;
import com.brandon3055.draconicevolution.DEFeatures;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyStorageCore;
import com.google.common.collect.Iterables;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IEnergyContainer;
import hellfirepvp.modularmachinery.common.base.Mods;
import hellfirepvp.modularmachinery.common.block.prop.EnergyHatchSize;
import hellfirepvp.modularmachinery.common.integration.IntegrationIC2EventHandlerHelper;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.tiles.base.TileEnergyHatch;
import hellfirepvp.modularmachinery.common.util.IEnergyHandler;
import hellfirepvp.modularmachinery.common.util.MiscUtils;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import java.util.Collections;
import java.util.LinkedList;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.Event;

@Optional.Interface(iface="ic2.api.energy.tile.IEnergySource", modid="ic2")
public class TileEnergyOutputHatch
extends TileEnergyHatch
implements IEnergySource {
    private BlockPos foundCore = null;

    public TileEnergyOutputHatch() {
    }

    public TileEnergyOutputHatch(EnergyHatchSize size) {
        super(size, IOType.OUTPUT);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        long prevEnergy = this.energy;
        long transferCap = Math.min(this.size.transferLimit, this.energy);
        if (Mods.DRACONICEVOLUTION.isPresent()) {
            long transferred = this.attemptDECoreTransfer(transferCap);
            transferCap -= transferred;
            this.energy -= transferred;
        }
        long usableAmps = Math.min((long)this.size.getGtAmperage(), transferCap / 4L / this.size.getGTEnergyTransferVoltage());
        for (EnumFacing face : EnumFacing.field_82609_l) {
            if (transferCap > 0L && Mods.GREGTECH.isPresent() && usableAmps > 0L) {
                long totalTransferred = this.attemptGTTransfer(face, transferCap / 4L, usableAmps) * 4L;
                usableAmps -= totalTransferred / 4L / this.size.getGTEnergyTransferVoltage();
                transferCap -= totalTransferred;
                this.energy -= totalTransferred;
            }
            if (transferCap > 0L) {
                if (Mods.REDSTONEFLUXAPI.isPresent()) {
                    int transferred = this.attemptFERFTransfer(face, this.convertDownEnergy(transferCap));
                    transferCap -= (long)transferred;
                    this.energy -= (long)transferred;
                } else {
                    int transferred = this.attemptFETransfer(face, this.convertDownEnergy(transferCap));
                    transferCap -= (long)transferred;
                    this.energy -= (long)transferred;
                }
            }
            if (transferCap <= 0L) break;
        }
        if (prevEnergy != this.energy) {
            this.markForUpdate();
        }
    }

    @Optional.Method(modid="draconicevolution")
    private long attemptDECoreTransfer(long transferCap) {
        TileEntity te;
        TileEntity tileEntity = te = this.foundCore == null ? null : this.field_145850_b.func_175625_s(this.foundCore);
        if (!(this.foundCore != null && te instanceof TileEnergyStorageCore || this.field_145850_b.func_82737_E() % 100L != 0L)) {
            this.foundCore = this.findCore(this.foundCore);
        }
        if (this.foundCore != null && te instanceof TileEnergyStorageCore) {
            TileEnergyStorageCore core = (TileEnergyStorageCore)te;
            long energyReceived = Math.min(core.getExtendedCapacity() - core.energy.value, transferCap);
            ((TileEnergyStorageCore)te).energy.value += energyReceived;
            return energyReceived;
        }
        return 0L;
    }

    @Optional.Method(modid="draconicevolution")
    private BlockPos findCore(BlockPos before) {
        LinkedList<TileEnergyStorageCore> list = new LinkedList<TileEnergyStorageCore>();
        int range = 16;
        Iterable positions = BlockPos.func_177980_a((BlockPos)this.field_174879_c.func_177982_a(-range, -range, -range), (BlockPos)this.field_174879_c.func_177982_a(range, range, range));
        for (BlockPos blockPos : positions) {
            TileEntity tile2;
            if (this.field_145850_b.func_180495_p(blockPos).func_177230_c() != DEFeatures.energyStorageCore || !((tile2 = this.field_145850_b.func_175625_s(blockPos)) instanceof TileEnergyStorageCore) || !((TileEnergyStorageCore)tile2).active.value) continue;
            list.add((TileEnergyStorageCore)tile2);
        }
        if (before != null) {
            list.removeIf(tile -> tile.func_174877_v().equals((Object)before));
        }
        Collections.shuffle(list);
        TileEnergyStorageCore first = (TileEnergyStorageCore)Iterables.getFirst(list, null);
        return first == null ? null : first.func_174877_v();
    }

    @Optional.Method(modid="gregtech")
    private long attemptGTTransfer(EnumFacing face, long transferCap, long usedAmps) {
        IEnergyContainer energyContainer;
        long voltage = this.size.getGTEnergyTransferVoltage();
        long amperes = Math.min(usedAmps, (long)this.size.getGtAmperage());
        int transferableAmps = 0;
        while ((long)transferableAmps < amperes && (long)transferableAmps * voltage <= transferCap) {
            ++transferableAmps;
        }
        if (transferableAmps == 0) {
            return 0L;
        }
        TileEntity tileEntity = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(face));
        EnumFacing oppositeSide = face.func_176734_d();
        if (tileEntity != null && tileEntity.hasCapability(GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER, oppositeSide) && (energyContainer = (IEnergyContainer)tileEntity.getCapability(GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER, oppositeSide)) != null && energyContainer.inputsEnergy(oppositeSide)) {
            return energyContainer.acceptEnergyFromNetwork(oppositeSide, voltage, (long)transferableAmps) * voltage;
        }
        return 0L;
    }

    private int attemptFETransfer(EnumFacing face, int maxTransferLeft) {
        net.minecraftforge.energy.IEnergyStorage ce;
        BlockPos at = this.func_174877_v().func_177972_a(face);
        EnumFacing accessingSide = face.func_176734_d();
        int receivedEnergy = 0;
        TileEntity te = this.field_145850_b.func_175625_s(at);
        if (te != null && !(te instanceof TileEnergyHatch) && te.hasCapability(CapabilityEnergy.ENERGY, accessingSide) && (ce = (net.minecraftforge.energy.IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, accessingSide)) != null && ce.canReceive()) {
            try {
                receivedEnergy = ce.receiveEnergy(maxTransferLeft, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return receivedEnergy;
    }

    @Optional.Method(modid="redstoneflux")
    private int attemptFERFTransfer(EnumFacing face, int maxTransferLeft) {
        BlockPos at = this.func_174877_v().func_177972_a(face);
        EnumFacing accessingSide = face.func_176734_d();
        int receivedEnergy = 0;
        TileEntity te = this.field_145850_b.func_175625_s(at);
        if (te != null && !(te instanceof TileEnergyHatch)) {
            net.minecraftforge.energy.IEnergyStorage ce;
            if (te instanceof IEnergyReceiver && ((IEnergyReceiver)te).canConnectEnergy(accessingSide)) {
                try {
                    receivedEnergy = ((IEnergyReceiver)te).receiveEnergy(accessingSide, maxTransferLeft, false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (receivedEnergy <= 0 && te instanceof IEnergyStorage) {
                try {
                    receivedEnergy = ((IEnergyStorage)te).receiveEnergy(maxTransferLeft, false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (receivedEnergy <= 0 && te.hasCapability(CapabilityEnergy.ENERGY, accessingSide) && (ce = (net.minecraftforge.energy.IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, accessingSide)) != null && ce.canReceive()) {
                try {
                    receivedEnergy = ce.receiveEnergy(maxTransferLeft, false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return receivedEnergy;
    }

    @Optional.Method(modid="ic2")
    public void onLoad() {
        super.onLoad();
        IntegrationIC2EventHandlerHelper.fireLoadEvent(this.field_145850_b, (IEnergyTile)this);
    }

    @Optional.Method(modid="ic2")
    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
        }
    }

    @Optional.Method(modid="ic2")
    public double getOfferedEnergy() {
        return Math.min((long)this.size.getIC2EnergyTransmission(), this.getCurrentEnergy() / 4L);
    }

    @Optional.Method(modid="ic2")
    public void drawEnergy(double amount) {
        this.energy = MiscUtils.clamp(this.energy - MathHelper.func_76124_d((double)amount) * 4L, 0L, this.size.maxEnergy);
        this.markForUpdate();
    }

    @Optional.Method(modid="ic2")
    public int getSourceTier() {
        return this.size.ic2EnergyTier;
    }

    @Optional.Method(modid="ic2")
    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing side) {
        return true;
    }

    @Override
    @Nullable
    public MachineComponent provideComponent() {
        return new MachineComponent.EnergyHatch(IOType.OUTPUT){

            @Override
            public IEnergyHandler getContainerProvider() {
                return TileEnergyOutputHatch.this;
            }
        };
    }
}

