/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.machine;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import hellfirepvp.modularmachinery.common.modifier.ModifierReplacement;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.util.BlockArray;
import hellfirepvp.modularmachinery.common.util.BlockInformationVariable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.util.JsonUtils;

public class MachineLoader {
    private static final Gson GSON = new GsonBuilder().registerTypeHierarchyAdapter(DynamicMachine.class, (Object)new DynamicMachine.MachineDeserializer()).registerTypeHierarchyAdapter(BlockInformationVariable.class, (Object)new BlockInformationVariable.Deserializer()).registerTypeHierarchyAdapter(ModifierReplacement.class, (Object)new ModifierReplacement.Deserializer()).registerTypeHierarchyAdapter(RecipeModifier.class, (Object)new RecipeModifier.Deserializer()).create();
    private static Map<String, Exception> failedAttempts = new HashMap<String, Exception>();
    public static Map<String, BlockArray.BlockInformation> variableContext = new HashMap<String, BlockArray.BlockInformation>();

    public static Map<FileType, List<File>> discoverDirectory(File directory) {
        HashMap<FileType, List<File>> candidates = new HashMap<FileType, List<File>>();
        for (FileType type : FileType.values()) {
            candidates.put(type, Lists.newLinkedList());
        }
        LinkedList directories = Lists.newLinkedList();
        directories.add(directory);
        while (!directories.isEmpty()) {
            File dir = (File)directories.remove(0);
            for (File f : dir.listFiles()) {
                if (f.isDirectory()) {
                    directories.addLast(f);
                    continue;
                }
                if (FileType.VARIABLES.accepts(f.getName())) {
                    ((List)candidates.get((Object)FileType.VARIABLES)).add(f);
                    continue;
                }
                if (!FileType.MACHINE.accepts(f.getName())) continue;
                ((List)candidates.get((Object)FileType.MACHINE)).add(f);
            }
        }
        return candidates;
    }

    public static List<DynamicMachine> loadMachines(List<File> machineCandidates) {
        ArrayList loadedMachines = Lists.newArrayList();
        for (File f : machineCandidates) {
            try {
                InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(f), StandardCharsets.UTF_8);
                Throwable throwable = null;
                try {
                    loadedMachines.add(JsonUtils.func_193839_a((Gson)GSON, (Reader)isr, DynamicMachine.class));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (isr == null) continue;
                    if (throwable != null) {
                        try {
                            isr.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    isr.close();
                }
            }
            catch (Exception exc) {
                failedAttempts.put(f.getPath(), exc);
            }
        }
        return loadedMachines;
    }

    public static Map<String, Exception> captureFailedAttempts() {
        Map<String, Exception> failed = failedAttempts;
        failedAttempts = new HashMap<String, Exception>();
        return failed;
    }

    public static void prepareContext(List<File> files) {
        variableContext.clear();
        for (File f : files) {
            try {
                InputStreamReader isr = new InputStreamReader(new FileInputStream(f));
                Throwable throwable = null;
                try {
                    Map<String, BlockArray.BlockInformation> variables = ((BlockInformationVariable)JsonUtils.func_193839_a((Gson)GSON, (Reader)isr, BlockInformationVariable.class)).getDefinedVariables();
                    for (String key : variables.keySet()) {
                        variableContext.put(key, variables.get(key));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (isr == null) continue;
                    if (throwable != null) {
                        try {
                            isr.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    isr.close();
                }
            }
            catch (Exception exc) {
                failedAttempts.put(f.getPath(), exc);
            }
        }
    }

    public static enum FileType {
        VARIABLES,
        MACHINE;


        public boolean accepts(String fileName) {
            switch (this) {
                case VARIABLES: {
                    return fileName.endsWith(".var.json");
                }
            }
            return fileName.endsWith(".json");
        }
    }
}

