/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.integration.ingredient;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import hellfirepvp.modularmachinery.common.base.Mods;
import hellfirepvp.modularmachinery.common.integration.ModIntegrationJEI;
import hellfirepvp.modularmachinery.common.integration.ingredient.HybridFluid;
import hellfirepvp.modularmachinery.common.integration.ingredient.HybridFluidGas;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nullable;
import mekanism.api.gas.GasStack;
import mezz.jei.api.ingredients.IIngredientHelper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Optional;

public class HybridStackHelper<T extends HybridFluid>
implements IIngredientHelper<T> {
    public List<T> expandSubtypes(List<T> ingredients) {
        return ingredients;
    }

    @Nullable
    public T getMatch(Iterable<T> ingredients, T ingredientToMatch) {
        T gasMatch;
        if (Mods.MEKANISM.isPresent() && (gasMatch = this.attemptGasStackMatch(ingredients, ingredientToMatch)) != null) {
            return gasMatch;
        }
        return this.matchFluidStack(ingredients, ingredientToMatch);
    }

    private T matchFluidStack(Iterable<T> ingredients, T ingredientToMatch) {
        if (Iterables.isEmpty(ingredients)) {
            return null;
        }
        FluidStack stack = ((HybridFluid)ingredientToMatch).asFluidStack();
        if (stack == null) {
            return null;
        }
        Fluid fluidMatch = stack.getFluid();
        for (HybridFluid hybridFluid : ingredients) {
            FluidStack hybridFluidStack = hybridFluid.asFluidStack();
            if (hybridFluidStack == null || hybridFluidStack.getFluid() != fluidMatch) continue;
            return (T)hybridFluid;
        }
        return null;
    }

    @Optional.Method(modid="mekanism")
    private T attemptGasStackMatch(Iterable<T> ingredients, T ingredientToMatch) {
        if (ingredientToMatch instanceof HybridFluidGas && !Iterables.isEmpty(ingredients)) {
            GasStack toMatch = ((HybridFluidGas)ingredientToMatch).asGasStack();
            for (HybridFluid hybridFluid : ingredients) {
                HybridFluidGas hybridFluidGas;
                if (hybridFluid == null || !(hybridFluid instanceof HybridFluidGas) || (hybridFluidGas = (HybridFluidGas)hybridFluid).asGasStack().getGas() != toMatch.getGas()) continue;
                return (T)hybridFluidGas;
            }
        }
        return null;
    }

    public String getDisplayName(T ingredient) {
        String display;
        if (Mods.MEKANISM.isPresent() && (display = this.getGasDisplayName(ingredient)) != null) {
            return display;
        }
        FluidStack fluidStack = ((HybridFluid)ingredient).asFluidStack();
        if (fluidStack == null) {
            return "";
        }
        IIngredientHelper fluidHelper = ModIntegrationJEI.ingredientRegistry.getIngredientHelper(FluidStack.class);
        return fluidHelper.getDisplayName((Object)fluidStack);
    }

    @Optional.Method(modid="mekanism")
    private String getGasDisplayName(T ingredient) {
        if (ingredient instanceof HybridFluidGas) {
            IIngredientHelper gasHelper = ModIntegrationJEI.ingredientRegistry.getIngredientHelper(GasStack.class);
            return gasHelper.getDisplayName((Object)((HybridFluidGas)ingredient).asGasStack());
        }
        return null;
    }

    public String getUniqueId(T ingredient) {
        String uniqueId;
        if (Mods.MEKANISM.isPresent() && (uniqueId = this.gasGasUniqueId(ingredient)) != null) {
            return uniqueId;
        }
        FluidStack fluidStack = ((HybridFluid)ingredient).asFluidStack();
        if (fluidStack == null) {
            return "";
        }
        IIngredientHelper fluidHelper = ModIntegrationJEI.ingredientRegistry.getIngredientHelper(FluidStack.class);
        return fluidHelper.getUniqueId((Object)fluidStack);
    }

    @Optional.Method(modid="mekanism")
    private String gasGasUniqueId(T ingredient) {
        if (ingredient instanceof HybridFluidGas) {
            IIngredientHelper gasHelper = ModIntegrationJEI.ingredientRegistry.getIngredientHelper(GasStack.class);
            return gasHelper.getUniqueId((Object)((HybridFluidGas)ingredient).asGasStack());
        }
        return null;
    }

    public String getWildcardId(T ingredient) {
        String wildcard;
        if (Mods.MEKANISM.isPresent() && (wildcard = this.getGasWildcardId(ingredient)) != null) {
            return wildcard;
        }
        FluidStack fluidStack = ((HybridFluid)ingredient).asFluidStack();
        if (fluidStack == null) {
            return "";
        }
        IIngredientHelper fluidHelper = ModIntegrationJEI.ingredientRegistry.getIngredientHelper(FluidStack.class);
        return fluidHelper.getUniqueId((Object)fluidStack);
    }

    @Optional.Method(modid="mekanism")
    private String getGasWildcardId(T ingredient) {
        if (ingredient instanceof HybridFluidGas) {
            IIngredientHelper gasHelper = ModIntegrationJEI.ingredientRegistry.getIngredientHelper(GasStack.class);
            return gasHelper.getWildcardId((Object)((HybridFluidGas)ingredient).asGasStack());
        }
        return null;
    }

    public String getModId(T ingredient) {
        String modid;
        if (Mods.MEKANISM.isPresent() && (modid = this.getGasModId(ingredient)) != null) {
            return modid;
        }
        FluidStack fluidStack = ((HybridFluid)ingredient).asFluidStack();
        if (fluidStack == null) {
            return "";
        }
        IIngredientHelper fluidHelper = ModIntegrationJEI.ingredientRegistry.getIngredientHelper(FluidStack.class);
        return fluidHelper.getModId((Object)fluidStack);
    }

    @Optional.Method(modid="mekanism")
    private String getGasModId(T ingredient) {
        if (ingredient instanceof HybridFluidGas) {
            IIngredientHelper gasHelper = ModIntegrationJEI.ingredientRegistry.getIngredientHelper(GasStack.class);
            return gasHelper.getModId((Object)((HybridFluidGas)ingredient).asGasStack());
        }
        return null;
    }

    public Iterable<Color> getColors(T ingredient) {
        Iterable<Color> gasColors;
        if (Mods.MEKANISM.isPresent() && (gasColors = this.getGasColors(ingredient)) != null) {
            return gasColors;
        }
        FluidStack fluidStack = ((HybridFluid)ingredient).asFluidStack();
        if (fluidStack == null) {
            return Lists.newArrayList();
        }
        IIngredientHelper fluidHelper = ModIntegrationJEI.ingredientRegistry.getIngredientHelper(FluidStack.class);
        return fluidHelper.getColors((Object)fluidStack);
    }

    @Optional.Method(modid="mekanism")
    private Iterable<Color> getGasColors(T ingredient) {
        if (ingredient instanceof HybridFluidGas) {
            IIngredientHelper gasHelper = ModIntegrationJEI.ingredientRegistry.getIngredientHelper(GasStack.class);
            return gasHelper.getColors((Object)((HybridFluidGas)ingredient).asGasStack());
        }
        return null;
    }

    public String getResourceId(T ingredient) {
        String id;
        if (Mods.MEKANISM.isPresent() && (id = this.getGasResourceId(ingredient)) != null) {
            return id;
        }
        FluidStack fluidStack = ((HybridFluid)ingredient).asFluidStack();
        if (fluidStack == null) {
            return "";
        }
        IIngredientHelper fluidHelper = ModIntegrationJEI.ingredientRegistry.getIngredientHelper(FluidStack.class);
        return fluidHelper.getResourceId((Object)fluidStack);
    }

    @Optional.Method(modid="mekanism")
    private String getGasResourceId(T ingredient) {
        if (ingredient instanceof HybridFluidGas) {
            IIngredientHelper gasHelper = ModIntegrationJEI.ingredientRegistry.getIngredientHelper(GasStack.class);
            return gasHelper.getResourceId((Object)((HybridFluidGas)ingredient).asGasStack());
        }
        return null;
    }

    public T copyIngredient(T ingredient) {
        return (T)((HybridFluid)ingredient).copy();
    }

    public ItemStack cheatIngredient(T ingredient, boolean fullStack) {
        ItemStack cheated;
        if (Mods.MEKANISM.isPresent() && (cheated = this.getGasCheatIngredient(ingredient, fullStack)) != null) {
            return cheated;
        }
        FluidStack fluidStack = ((HybridFluid)ingredient).asFluidStack();
        if (fluidStack == null) {
            return ItemStack.field_190927_a;
        }
        IIngredientHelper fluidHelper = ModIntegrationJEI.ingredientRegistry.getIngredientHelper(FluidStack.class);
        return fluidHelper.cheatIngredient((Object)fluidStack, fullStack);
    }

    @Optional.Method(modid="mekanism")
    private ItemStack getGasCheatIngredient(T ingredient, boolean fullStack) {
        if (ingredient instanceof HybridFluidGas) {
            IIngredientHelper gasHelper = ModIntegrationJEI.ingredientRegistry.getIngredientHelper(GasStack.class);
            return gasHelper.cheatIngredient((Object)((HybridFluidGas)ingredient).asGasStack(), fullStack);
        }
        return null;
    }

    public String getErrorInfo(T ingredient) {
        String id;
        if (Mods.MEKANISM.isPresent() && (id = this.getGasErrorInfo(ingredient)) != null) {
            return id;
        }
        FluidStack fluidStack = ((HybridFluid)ingredient).asFluidStack();
        if (fluidStack == null) {
            return "";
        }
        IIngredientHelper fluidHelper = ModIntegrationJEI.ingredientRegistry.getIngredientHelper(FluidStack.class);
        return fluidHelper.getErrorInfo((Object)fluidStack);
    }

    @Optional.Method(modid="mekanism")
    private String getGasErrorInfo(T ingredient) {
        if (ingredient instanceof HybridFluidGas) {
            IIngredientHelper gasHelper = ModIntegrationJEI.ingredientRegistry.getIngredientHelper(GasStack.class);
            return gasHelper.getErrorInfo((Object)((HybridFluidGas)ingredient).asGasStack());
        }
        return null;
    }
}

