/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.crafting.requirement.jei;

import com.google.common.collect.Lists;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementItem;
import hellfirepvp.modularmachinery.common.integration.recipe.RecipeLayoutPart;
import hellfirepvp.modularmachinery.common.util.FuelItemHelper;
import hellfirepvp.modularmachinery.common.util.ItemUtils;
import java.awt.Point;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class JEIComponentItem
extends ComponentRequirement.JEIComponent<ItemStack> {
    private final RequirementItem requirement;

    public JEIComponentItem(RequirementItem requirement) {
        this.requirement = requirement;
    }

    @Override
    public Class<ItemStack> getJEIRequirementClass() {
        return ItemStack.class;
    }

    @Override
    public List<ItemStack> getJEIIORequirements() {
        switch (this.requirement.requirementType) {
            case ITEMSTACKS: {
                ItemStack stack = ItemUtils.copyStackWithSize(this.requirement.required, this.requirement.required.func_190916_E());
                if (this.requirement.previewDisplayTag != null) {
                    stack.func_77982_d(this.requirement.previewDisplayTag);
                } else if (this.requirement.tag != null) {
                    this.requirement.previewDisplayTag = this.requirement.tag.func_74737_b();
                    stack.func_77982_d(this.requirement.previewDisplayTag.func_74737_b());
                }
                return Lists.newArrayList((Object[])new ItemStack[]{stack});
            }
            case OREDICT: {
                NonNullList stacks = OreDictionary.getOres((String)this.requirement.oreDictName);
                NonNullList out = NonNullList.func_191196_a();
                for (ItemStack oreDictIn : stacks) {
                    if (oreDictIn.func_77952_i() == Short.MAX_VALUE && !oreDictIn.func_77984_f() && oreDictIn.func_77973_b().func_77640_w() != null) {
                        oreDictIn.func_77973_b().func_150895_a(oreDictIn.func_77973_b().func_77640_w(), out);
                        continue;
                    }
                    out.add((Object)oreDictIn);
                }
                NonNullList stacksOut = NonNullList.func_191196_a();
                for (ItemStack s : out) {
                    ItemStack copy = s.func_77946_l();
                    copy.func_190920_e(this.requirement.oreDictItemAmount);
                    stacksOut.add((Object)copy);
                }
                return stacksOut;
            }
            case FUEL: {
                return FuelItemHelper.getFuelItems();
            }
        }
        return Lists.newArrayList();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public RecipeLayoutPart<ItemStack> getLayoutPart(Point offset) {
        return new RecipeLayoutPart.Item(offset);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onJEIHoverTooltip(int slotIndex, boolean input, ItemStack ingredient, List<String> tooltip) {
        if (this.requirement.requirementType == RequirementItem.ItemRequirementType.FUEL) {
            int burn = TileEntityFurnace.func_145952_a((ItemStack)ingredient);
            if (burn > 0) {
                tooltip.add(TextFormatting.GRAY.toString() + I18n.func_135052_a((String)"tooltip.machinery.fuel.item", (Object[])new Object[]{burn}));
            }
            tooltip.add(I18n.func_135052_a((String)"tooltip.machinery.fuel", (Object[])new Object[0]));
        }
        if (this.requirement.chance < 1.0f && this.requirement.chance >= 0.0f) {
            String keyNever = input ? "tooltip.machinery.chance.in.never" : "tooltip.machinery.chance.out.never";
            String keyChance = input ? "tooltip.machinery.chance.in" : "tooltip.machinery.chance.out";
            String chanceStr = String.valueOf(MathHelper.func_76141_d((float)(this.requirement.chance * 100.0f)));
            if (this.requirement.chance == 0.0f) {
                tooltip.add(I18n.func_135052_a((String)keyNever, (Object[])new Object[0]));
            } else {
                if (this.requirement.chance < 0.01f) {
                    chanceStr = "< 1";
                }
                chanceStr = chanceStr + "%";
                tooltip.add(I18n.func_135052_a((String)keyChance, (Object[])new Object[]{chanceStr}));
            }
        }
    }
}

