/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items;

import de.ellpeck.actuallyadditions.api.misc.IGoggles;
import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.items.base.ItemArmorAA;
import de.ellpeck.actuallyadditions.mod.material.InitArmorMaterials;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import io.netty.util.internal.ConcurrentSet;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemEngineerGoggles
extends ItemArmorAA
implements IGoggles {
    private final Set<Entity> cachedGlowingEntities = new ConcurrentSet();
    private final boolean displayMobs;

    public ItemEngineerGoggles(String name, boolean displayMobs) {
        super(name, InitArmorMaterials.armorMaterialGoggles, 0, StackUtil.getEmpty());
        this.displayMobs = displayMobs;
        this.func_77656_e(0);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static boolean isWearing(EntityPlayer player) {
        ItemStack face = (ItemStack)player.field_71071_by.field_70460_b.get(3);
        return StackUtil.isValid(face) && face.func_77973_b() instanceof IGoggles;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        ItemStack face;
        EntityPlayer player = ActuallyAdditions.PROXY.getCurrentPlayer();
        if (player != null && ItemEngineerGoggles.isWearing(player) && ((IGoggles)(face = (ItemStack)player.field_71071_by.field_70460_b.get(3)).func_77973_b()).displaySpectralMobs()) {
            double range = 8.0;
            AxisAlignedBB aabb = new AxisAlignedBB(player.field_70165_t - range, player.field_70163_u - range, player.field_70161_v - range, player.field_70165_t + range, player.field_70163_u + range, player.field_70161_v + range);
            List entities = player.field_70170_p.func_72872_a(Entity.class, aabb);
            if (entities != null && !entities.isEmpty()) {
                this.cachedGlowingEntities.addAll(entities);
            }
            if (!this.cachedGlowingEntities.isEmpty()) {
                for (Entity entity : this.cachedGlowingEntities) {
                    if (entity.field_70128_L || entity.func_70092_e(player.field_70165_t, player.field_70163_u, player.field_70161_v) > range * range) {
                        entity.func_184195_f(false);
                        this.cachedGlowingEntities.remove(entity);
                        continue;
                    }
                    entity.func_184195_f(true);
                }
            }
            return;
        }
        if (!this.cachedGlowingEntities.isEmpty()) {
            for (Entity entity : this.cachedGlowingEntities) {
                if (entity.field_70128_L) continue;
                entity.func_184195_f(false);
            }
            this.cachedGlowingEntities.clear();
        }
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.RARE;
    }

    @Override
    public boolean displaySpectralMobs() {
        return this.displayMobs;
    }
}

