/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks.render;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import de.ellpeck.actuallyadditions.mod.blocks.render.Transformer;
import java.util.EnumMap;
import java.util.List;
import javax.annotation.Nullable;
import javax.vecmath.Vector3f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.common.model.TRSRTransformation;

public class CompostModel
implements IBakedModel {
    public static IBakedModel compostBase;
    private final IBakedModel display;
    private final ImmutableList<BakedQuad> general;
    private final ImmutableMap<EnumFacing, ImmutableList<BakedQuad>> faces;

    public CompostModel(IBlockState flowerState, float height) {
        ImmutableList.Builder builder;
        this.display = Minecraft.func_71410_x().func_175602_ab().func_184389_a(flowerState);
        TRSRTransformation transform = TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(new Vector3f(0.0f, -0.218f, 0.0f), null, new Vector3f(0.75f, height / 1.81f, 0.75f), null));
        EnumMap<EnumFacing, ImmutableList> faces = new EnumMap<EnumFacing, ImmutableList>(EnumFacing.class);
        for (EnumFacing face : EnumFacing.values()) {
            builder = ImmutableList.builder();
            if (!this.display.func_188618_c()) {
                for (BakedQuad quad : this.display.func_188616_a(flowerState, face, 0L)) {
                    Transformer transformer = new Transformer(transform, quad.getFormat());
                    quad.pipe((IVertexConsumer)transformer);
                    builder.add((Object)transformer.build());
                }
                builder.addAll((Iterable)compostBase.func_188616_a(null, face, 0L));
            }
            faces.put(face, builder.build());
        }
        if (!this.display.func_188618_c()) {
            builder = ImmutableList.builder();
            for (BakedQuad quad : this.display.func_188616_a(flowerState, null, 0L)) {
                Transformer transformer = new Transformer(transform, quad.getFormat());
                quad.pipe((IVertexConsumer)transformer);
                builder.add((Object)transformer.build());
            }
            builder.addAll((Iterable)compostBase.func_188616_a(null, null, 0L));
            this.general = builder.build();
        } else {
            this.general = ImmutableList.of();
        }
        this.faces = Maps.immutableEnumMap(faces);
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        if (side == null) {
            return this.general;
        }
        return (List)this.faces.get((Object)side);
    }

    public boolean func_177555_b() {
        return compostBase.func_177555_b() && this.display.func_177555_b();
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return compostBase.func_177554_e();
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }
}

