/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.entity.item;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.client.particle.ParticleBlur;

public class EntityItemTargetted
extends EntityItem {
    private static final DataParameter<BlockPos> TARGET = EntityDataManager.func_187226_a(EntityItemTargetted.class, (DataSerializer)DataSerializers.field_187200_j);
    private EntityLivingBase targetEntity = null;

    public EntityItemTargetted(World world) {
        super(world);
        this.lifespan = Integer.MAX_VALUE;
    }

    public EntityItemTargetted(World world, double x, double y, double z) {
        super(world, x, y, z);
        this.lifespan = Integer.MAX_VALUE;
    }

    public EntityItemTargetted(World world, double x, double y, double z, ItemStack itemStack) {
        super(world, x, y, z, itemStack);
        this.lifespan = Integer.MAX_VALUE;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(TARGET, (Object)this.func_180425_c());
    }

    public void setTarget(BlockPos pos) {
        this.func_184212_Q().func_187227_b(TARGET, (Object)pos);
    }

    public void setTarget(EntityLivingBase targetEntity) {
        this.targetEntity = targetEntity;
        this.setTarget(targetEntity.func_180425_c());
    }

    public BlockPos getTarget() {
        return (BlockPos)this.func_184212_Q().func_187225_a(TARGET);
    }

    public boolean func_189652_ae() {
        return true;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.targetEntity != null) {
            this.setTarget(this.targetEntity.func_180425_c());
        }
        BlockPos target = this.getTarget();
        double dx = this.field_70165_t - (double)target.func_177958_n();
        double dy = this.field_70163_u - (double)((float)target.func_177956_o() + 1.0f);
        double dz = this.field_70161_v - (double)target.func_177952_p();
        double strength = -0.1;
        double d = MathHelper.func_76133_a((double)(dx * dx + dy * dy + dz * dz));
        if (d > 1.0) {
            double m = 1.0 / (2.0 * Math.max(1.0, d));
            this.field_70159_w = (dx *= m) * strength;
            this.field_70181_x = (dy *= m) * strength;
            this.field_70179_y = (dz *= m) * strength;
            if (this.field_70123_F) {
                this.field_70181_x = 0.3;
            }
        }
        if (this.field_70170_p.field_72995_K) {
            this.showEntityMoved();
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void showEntityMoved() {
        Random rand = this.field_70170_p.field_73012_v;
        float scale = 0.05f;
        float red = rand.nextFloat() * 0.1f + 0.5f;
        float green = rand.nextFloat() * 0.1f + 0.5f;
        float blue = rand.nextFloat() * 0.2f + 0.8f;
        float ageMultiplier = (float)(rand.nextDouble() * 2.5 + 10.0);
        ParticleBlur blur = new ParticleBlur(this.field_70170_p, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, scale, 0.1 - (double)rand.nextFloat() * 0.2, 0.1 - (double)rand.nextFloat() * 0.2, 0.1 - (double)rand.nextFloat() * 0.2, red, green, blue, ageMultiplier);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)blur);
        if (rand.nextInt(5) == 0) {
            BlockPos target = this.getTarget();
            double dx = this.field_70165_t - (double)((float)target.func_177958_n() + 0.5f);
            double dy = this.field_70163_u - (double)((float)target.func_177956_o() + 1.0f);
            double dz = this.field_70161_v - (double)((float)target.func_177952_p() + 0.5f);
            double factor = rand.nextDouble();
            double x = this.field_70165_t - dx * factor;
            double y = this.field_70163_u - dy * factor;
            double z = this.field_70161_v - dz * factor;
            ParticleBlur blur2 = new ParticleBlur(this.field_70170_p, x, y, z, scale, -0.02 * dx, -0.02 * dy, -0.02 * dz, red, green, blue, ageMultiplier);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)blur2);
        }
    }
}

