/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.recipe.xml;

import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.cyclopscore.init.RecipeHandler;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipe;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeInput;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeOutput;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeProperties;
import org.cyclops.cyclopscore.recipe.custom.component.DurationRecipeProperties;
import org.cyclops.cyclopscore.recipe.custom.component.IngredientAndFluidStackRecipeComponent;
import org.cyclops.cyclopscore.recipe.xml.SuperRecipeTypeHandler;
import org.cyclops.cyclopscore.recipe.xml.XmlRecipeLoader;
import org.cyclops.integrateddynamics.block.BlockMechanicalDryingBasin;
import org.w3c.dom.Element;

public class MechanicalDryingBasinRecipeTypeHandler
extends SuperRecipeTypeHandler<IngredientAndFluidStackRecipeComponent, IngredientAndFluidStackRecipeComponent, DurationRecipeProperties> {
    public String getCategoryId() {
        return "integrateddynamics:mechanical_drying_basin_recipe";
    }

    protected IRecipe<IngredientAndFluidStackRecipeComponent, IngredientAndFluidStackRecipeComponent, DurationRecipeProperties> handleRecipe(RecipeHandler recipeHandler, Element input, Element output, Element properties) throws XmlRecipeLoader.XmlRecipeException {
        Ingredient inputItem = Ingredient.field_193370_a;
        Ingredient outputItem = Ingredient.field_193370_a;
        FluidStack inputFluid = null;
        FluidStack outputFluid = null;
        if (input.getElementsByTagName("item").getLength() > 0) {
            inputItem = this.getIngredient(recipeHandler, input.getElementsByTagName("item").item(0));
        }
        if (input.getElementsByTagName("fluid").getLength() > 0) {
            inputFluid = this.getFluid(recipeHandler, input.getElementsByTagName("fluid").item(0));
        }
        if (output.getElementsByTagName("item").getLength() > 0) {
            outputItem = this.getIngredient(recipeHandler, output.getElementsByTagName("item").item(0));
        }
        if (output.getElementsByTagName("fluid").getLength() > 0) {
            outputFluid = this.getFluid(recipeHandler, output.getElementsByTagName("fluid").item(0));
        }
        if (inputFluid != null && outputFluid != null) {
            throw new XmlRecipeLoader.XmlRecipeException(String.format("Can't have an input and output fluid: %s and %s", inputFluid.getLocalizedName(), outputFluid.getLocalizedName()));
        }
        int duration = Integer.parseInt(properties.getElementsByTagName("duration").item(0).getTextContent());
        IngredientAndFluidStackRecipeComponent inputRecipeComponent = new IngredientAndFluidStackRecipeComponent(inputItem, inputFluid);
        IngredientAndFluidStackRecipeComponent outputRecipeComponent = new IngredientAndFluidStackRecipeComponent(outputItem, outputFluid);
        return BlockMechanicalDryingBasin.getInstance().getRecipeRegistry().registerRecipe((IRecipeInput)inputRecipeComponent, (IRecipeOutput)outputRecipeComponent, (IRecipeProperties)new DurationRecipeProperties(duration));
    }
}

