/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.item;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.item.IInformationProvider;
import org.cyclops.cyclopscore.item.ItemBlockNBT;
import org.cyclops.cyclopscore.modcompat.capabilities.DefaultCapabilityProvider;
import org.cyclops.integrateddynamics.block.IEnergyContainerBlock;
import org.cyclops.integrateddynamics.capability.energystorage.EnergyStorageItemBlockEnergyContainer;
import org.cyclops.integrateddynamics.tileentity.TileEnergyBattery;

public class ItemBlockEnergyContainer
extends ItemBlockNBT {
    private IEnergyContainerBlock block;

    public ItemBlockEnergyContainer(Block block) {
        super(block);
        this.func_77627_a(false);
        this.block = (IEnergyContainerBlock)block;
    }

    public IEnergyContainerBlock get() {
        return this.block;
    }

    protected IEnergyStorage getEnergyBattery(ItemStack itemStack) {
        return (IEnergyStorage)itemStack.getCapability(CapabilityEnergy.ENERGY, null);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, World world, List<String> list, ITooltipFlag flag) {
        super.func_77624_a(itemStack, world, list, flag);
        IEnergyStorage energyStorage = this.getEnergyBattery(itemStack);
        int amount = energyStorage.getEnergyStored();
        int capacity = energyStorage.getMaxEnergyStored();
        String line = String.format("%,d", amount) + " / " + String.format("%,d", capacity) + " " + L10NHelpers.localize((String)"general.integrateddynamics.energy_unit.name", (Object[])new Object[0]);
        list.add(IInformationProvider.ITEM_PREFIX + line);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack itemStack) {
        IEnergyStorage energyStorage = this.getEnergyBattery(itemStack);
        double amount = energyStorage.getEnergyStored();
        double capacity = energyStorage.getMaxEnergyStored();
        return (capacity - amount) / capacity;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return MathHelper.func_181758_c((float)(Math.max(0.0f, 1.0f - (float)this.getDurabilityForDisplay(stack)) / 3.0f), (float)1.0f, (float)1.0f);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new DefaultCapabilityProvider(() -> CapabilityEnergy.ENERGY, (Object)new EnergyStorageItemBlockEnergyContainer(this, stack){

            @Override
            public int getRate() {
                return TileEnergyBattery.getEnergyPerTick(this.getMaxEnergyStored());
            }
        });
    }
}

