/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.client.render.tileentity;

import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.cyclopscore.helper.DirectionHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.integrateddynamics.tileentity.TileSqueezer;

public class RenderTileEntitySqueezer
extends TileEntitySpecialRenderer<TileSqueezer>
implements RenderHelpers.IFluidContextRender {
    private static final double OFFSET = 0.01;
    private static final double MINY = 0.0625;
    private static final double MAXY = 0.115;
    private static final double MIN = 0.01;
    private static final double MAX = 0.99;
    private static double[][][] coordinates = new double[][][]{new double[][]{{0.01, 0.0625, 0.01}, {0.01, 0.0625, 0.99}, {0.99, 0.0625, 0.99}, {0.99, 0.0625, 0.01}}, new double[][]{{0.01, 0.115, 0.01}, {0.01, 0.115, 0.99}, {0.99, 0.115, 0.99}, {0.99, 0.115, 0.01}}, new double[][]{{0.01, 0.0625, 0.01}, {0.01, 0.115, 0.01}, {0.99, 0.115, 0.01}, {0.99, 0.0625, 0.01}}, new double[][]{{0.01, 0.0625, 0.99}, {0.01, 0.115, 0.99}, {0.99, 0.115, 0.99}, {0.99, 0.0625, 0.99}}, new double[][]{{0.01, 0.0625, 0.01}, {0.01, 0.115, 0.01}, {0.01, 0.115, 0.99}, {0.01, 0.0625, 0.99}}, new double[][]{{0.99, 0.0625, 0.01}, {0.99, 0.115, 0.01}, {0.99, 0.115, 0.99}, {0.99, 0.0625, 0.99}}};
    private TileSqueezer lastTile;

    public void render(TileSqueezer tile, double x, double y, double z, float partialTickTime, int partialDamage, float alpha) {
        if (tile != null) {
            if (tile.func_70301_a(0) != null) {
                GlStateManager.func_179094_E();
                float var10 = (float)(x - 0.5);
                float var11 = (float)(y - 0.5);
                float var12 = (float)(z - 0.5);
                GlStateManager.func_179109_b((float)var10, (float)var11, (float)var12);
                this.renderItem(tile.func_145831_w(), tile.func_174877_v(), tile.func_70301_a(0), tile);
                GlStateManager.func_179121_F();
            }
            if (!tile.getTank().isEmpty()) {
                this.lastTile = tile;
                RenderHelpers.renderTileFluidContext((FluidStack)tile.getTank().getFluid(), (double)x, (double)y, (double)z, (TileEntity)tile, (RenderHelpers.IFluidContextRender)this);
            }
        }
    }

    private void renderItem(World world, BlockPos pos, ItemStack itemStack, TileSqueezer tile) {
        GlStateManager.func_179094_E();
        float yTop = (float)(9 - tile.getItemHeight()) * 0.125f;
        GlStateManager.func_179109_b((float)1.0f, (float)((yTop - 1.0f) / 2.0f + 1.0f), (float)1.0f);
        GlStateManager.func_179152_a((float)0.7f, (float)0.7f, (float)0.7f);
        GlStateManager.func_179152_a((float)1.0f, (float)(yTop - 0.125f), (float)1.0f);
        GlStateManager.func_179123_a();
        RenderHelper.func_74519_b();
        RenderHelpers.renderItem((ItemStack)itemStack);
        RenderHelper.func_74518_a();
        GlStateManager.func_179099_b();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    public void renderFluid(FluidStack fluid) {
        double height = Math.max(0.0525, (double)fluid.amount * 0.0625 / 1000.0 + 0.0625 - 0.01);
        int brightness = this.lastTile.func_145831_w().func_175626_b(this.lastTile.func_174877_v(), fluid.getFluid().getLuminosity(fluid));
        int l2 = brightness >> 16 & 0xFFFF;
        int i3 = brightness & 0xFFFF;
        for (EnumFacing side : DirectionHelpers.DIRECTIONS) {
            TextureAtlasSprite icon = RenderHelpers.getFluidIcon((FluidStack)this.lastTile.getTank().getFluid(), (EnumFacing)EnumFacing.UP);
            Tessellator t = Tessellator.func_178181_a();
            BufferBuilder worldRenderer = t.func_178180_c();
            worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181711_k);
            double[][] c = coordinates[side.ordinal()];
            double replacedMaxV = side == EnumFacing.UP || side == EnumFacing.DOWN ? (double)icon.func_94210_h() : (double)(icon.func_94210_h() - icon.func_94206_g()) * height + (double)icon.func_94206_g();
            worldRenderer.func_181662_b(c[0][0], RenderTileEntitySqueezer.getHeight(side, c[0][1], height), c[0][2]).func_187315_a((double)icon.func_94209_e(), replacedMaxV).func_187314_a(l2, i3).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
            worldRenderer.func_181662_b(c[1][0], RenderTileEntitySqueezer.getHeight(side, c[1][1], height), c[1][2]).func_187315_a((double)icon.func_94209_e(), (double)icon.func_94206_g()).func_187314_a(l2, i3).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
            worldRenderer.func_181662_b(c[2][0], RenderTileEntitySqueezer.getHeight(side, c[2][1], height), c[2][2]).func_187315_a((double)icon.func_94212_f(), (double)icon.func_94206_g()).func_187314_a(l2, i3).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
            worldRenderer.func_181662_b(c[3][0], RenderTileEntitySqueezer.getHeight(side, c[3][1], height), c[3][2]).func_187315_a((double)icon.func_94212_f(), replacedMaxV).func_187314_a(l2, i3).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
            t.func_78381_a();
        }
    }

    private static double getHeight(EnumFacing side, double height, double replaceHeight) {
        if (height == 0.115) {
            return replaceHeight;
        }
        return height;
    }
}

