/*
 * Decompiled with CFR 0.152.
 */
package zabi.minecraft.minerva.common.crafting;

import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import zabi.minecraft.minerva.common.crafting.InputCounter;
import zabi.minecraft.minerva.common.utils.CachedSupplier;

public class NumberedInput
implements Predicate<ItemStack> {
    public static final NumberedInput EMPTY_INPUT = new NumberedInput();
    private final Ingredient ing;
    private final int amt;
    private CachedSupplier<NonNullList<ItemStack>> cachedValues;

    private NumberedInput() {
        this.ing = Ingredient.field_193370_a;
        this.amt = 0;
        this.cachedValues = new CachedSupplier<NonNullList>(() -> NonNullList.func_191196_a());
    }

    public NumberedInput(Ingredient i, int amount, boolean exactCount) {
        if (amount > 64) {
            throw new IllegalArgumentException("Stacks can be at most of 64");
        }
        if (amount < 1 || i.equals(Ingredient.field_193370_a)) {
            throw new IllegalArgumentException("The empty ingredient cannot be created");
        }
        this.ing = i;
        this.amt = amount;
        this.cachedValues = new CachedSupplier<NonNullList>(() -> this.generateCache(this.ing, this.amt));
    }

    private NonNullList<ItemStack> generateCache(Ingredient ing2, int amt2) {
        NonNullList nnl = NonNullList.func_191197_a((int)this.ing.func_193365_a().length, (Object)ItemStack.field_190927_a);
        for (int i = 0; i < this.ing.func_193365_a().length; ++i) {
            nnl.set(i, (Object)this.ing.func_193365_a()[i].func_77946_l());
            ((ItemStack)nnl.get(i)).func_190920_e(amt2);
        }
        return nnl;
    }

    public NumberedInput(Ingredient i, int amount) {
        this(i, amount, false);
    }

    public NumberedInput(Ingredient i) {
        this(i, 1);
    }

    @Override
    public boolean test(ItemStack in) {
        if (this.ing.apply(in)) {
            return in.func_190916_E() == this.amt;
        }
        return false;
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof NumberedInput) {
            NumberedInput other = (NumberedInput)arg0;
            return this.amt == other.amt && this.ing.equals(other.ing);
        }
        return false;
    }

    public int hashCode() {
        return this.ing.hashCode() << 8 | this.amt;
    }

    public NonNullList<ItemStack> getCachedStacks() {
        return this.cachedValues.get();
    }

    public InputCounter getCounter() {
        return new InputCounter(this.ing, this.amt);
    }

    public int getCount() {
        return this.amt;
    }
}

