/*
 * Decompiled with CFR 0.152.
 */
package zabi.minecraft.minerva.client.hud.internal;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.nbt.NBTTagCompound;
import zabi.minecraft.minerva.client.hud.EnumHudAnchor;

public class HudStatus {
    private double xData;
    private double yData;
    private int width;
    private int height;
    private int sizeFactor = 1;
    private EnumHudAnchor xAnchor;
    private EnumHudAnchor yAnchor;
    private boolean enabled = true;
    private final double xDataDefault;
    private final double yDataDefault;
    private final EnumHudAnchor xAnchorDefault;
    private final EnumHudAnchor yAnchorDefault;
    private final boolean visibleDefault;

    public HudStatus(double x, double y, int width, int height, EnumHudAnchor horizontalAnchor, EnumHudAnchor verticalAnchor, boolean visible) {
        this.xData = x;
        this.xDataDefault = x;
        this.yData = y;
        this.yDataDefault = y;
        this.xAnchor = horizontalAnchor;
        this.xAnchorDefault = horizontalAnchor;
        this.yAnchor = verticalAnchor;
        this.yAnchorDefault = verticalAnchor;
        this.width = width;
        this.height = height;
        this.enabled = visible;
        this.visibleDefault = visible;
    }

    public void reset() {
        this.xData = this.xDataDefault;
        this.yData = this.yDataDefault;
        this.xAnchor = this.xAnchorDefault;
        this.yAnchor = this.yAnchorDefault;
        this.enabled = this.visibleDefault;
        this.sizeFactor = 1;
    }

    public void setPosition(double x, double y, EnumHudAnchor horAnchor, EnumHudAnchor verAnchor) {
        this.xData = x;
        this.yData = y;
        this.xAnchor = horAnchor;
        this.yAnchor = verAnchor;
    }

    public void setSizeFactor(int factor) {
        this.sizeFactor = factor;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void toggle() {
        this.enabled = !this.enabled;
    }

    public void setEnabledStatus(boolean enable) {
        this.enabled = enable;
    }

    public int getX() {
        ScaledResolution sr = new ScaledResolution(Minecraft.func_71410_x());
        return this.xAnchor.dataToPixel(this.xData, this.getWidth(), sr.func_78326_a());
    }

    public int getY() {
        ScaledResolution sr = new ScaledResolution(Minecraft.func_71410_x());
        return this.yAnchor.dataToPixel(this.yData, this.getHeight(), sr.func_78328_b());
    }

    public int getWidth() {
        return this.width * this.sizeFactor;
    }

    public int getHeight() {
        return this.height * this.sizeFactor;
    }

    public EnumHudAnchor getHorizontalAnchor() {
        return this.xAnchor;
    }

    public EnumHudAnchor getVerticalAnchor() {
        return this.yAnchor;
    }

    public NBTTagCompound serialize() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74780_a("x", this.xData);
        tag.func_74780_a("y", this.yData);
        tag.func_74768_a("ha", this.xAnchor.ordinal());
        tag.func_74768_a("va", this.yAnchor.ordinal());
        tag.func_74768_a("s", this.sizeFactor);
        tag.func_74757_a("vis", this.enabled);
        return tag;
    }

    public void deserialize(NBTTagCompound tag) {
        this.setPosition(tag.func_74769_h("x"), tag.func_74769_h("y"), EnumHudAnchor.values()[tag.func_74762_e("ha")], EnumHudAnchor.values()[tag.func_74762_e("va")]);
        this.setSizeFactor(tag.func_74762_e("s"));
        this.setEnabledStatus(tag.func_74767_n("vis"));
    }

    public void scaleUp() {
        ++this.sizeFactor;
        if (this.sizeFactor > 5) {
            this.sizeFactor = 1;
        }
    }

    public void scaleDown() {
        --this.sizeFactor;
        if (this.sizeFactor < 1) {
            this.sizeFactor = 5;
        }
    }
}

