/*
 * Decompiled with CFR 0.152.
 */
package net.samtrion.compactdrawers.core;

import com.jaquadro.minecraft.chameleon.Chameleon;
import com.jaquadro.minecraft.chameleon.resources.ModelRegistry;
import com.jaquadro.minecraft.chameleon.resources.register.IUnifiedRegister;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.samtrion.compactdrawers.block.BlockCompactDrawer2By1;
import net.samtrion.compactdrawers.block.BlockCompactDrawer2By1Half;
import net.samtrion.compactdrawers.block.BlockCompactDrawerBase;
import net.samtrion.compactdrawers.block.BlockCompactDrawerHalf;
import net.samtrion.compactdrawers.block.EnumCompactDrawer2By1;
import net.samtrion.compactdrawers.block.EnumCompactDrawer2By1Half;
import net.samtrion.compactdrawers.block.EnumCompactDrawerHalf;
import net.samtrion.compactdrawers.block.IDrawerSerializable;
import net.samtrion.compactdrawers.client.model.CompactDrawer2By1HalfModel;
import net.samtrion.compactdrawers.client.model.CompactDrawer2By1Model;
import net.samtrion.compactdrawers.client.model.CompactDrawerHalfModel;
import net.samtrion.compactdrawers.client.renderer.TileEntityCompactDrawerRenderer;
import net.samtrion.compactdrawers.core.ModConfig;
import net.samtrion.compactdrawers.item.ItemCompactDrawer;
import net.samtrion.compactdrawers.tile.TileEntityCompactDrawer2By1;
import net.samtrion.compactdrawers.tile.TileEntityCompactDrawer2By1Half;
import net.samtrion.compactdrawers.tile.TileEntityCompactDrawerHalf;

@GameRegistry.ObjectHolder(value="compactdrawers")
public class ModBlocks {
    @GameRegistry.ObjectHolder(value="compact_drawer_2by1")
    public static final BlockCompactDrawer2By1 compactDrawer2By1 = null;
    @GameRegistry.ObjectHolder(value="compact_drawer_2by1_half")
    public static final BlockCompactDrawer2By1Half compactDrawer2By1Half = null;
    @GameRegistry.ObjectHolder(value="compact_drawer_half")
    public static final BlockCompactDrawerHalf compactDrawerHalf = null;

    @Mod.EventBusSubscriber(modid="compactdrawers")
    public static class Registration {
        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            IForgeRegistry registry = event.getRegistry();
            if (ModConfig.drawer2By1.enabled) {
                registry.register((IForgeRegistryEntry)new BlockCompactDrawer2By1("compact_drawer_2by1", "compactDrawer2By1"));
                Registration.registerTileEntity(TileEntityCompactDrawer2By1.class, "compact_drawer_2by1");
            }
            if (ModConfig.drawer2By1Half.enabled) {
                registry.register((IForgeRegistryEntry)new BlockCompactDrawer2By1Half("compact_drawer_2by1_half", "compactDrawer2By1Half"));
                Registration.registerTileEntity(TileEntityCompactDrawer2By1Half.class, "compact_drawer_2by1_half");
            }
            if (ModConfig.drawerHalf.enabled) {
                registry.register((IForgeRegistryEntry)new BlockCompactDrawerHalf("compact_drawer_half", "compactDrawerHalf"));
                Registration.registerTileEntity(TileEntityCompactDrawerHalf.class, "compact_drawer_half");
            }
        }

        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            IForgeRegistry registry = event.getRegistry();
            Registration.registerCompactDrawerItem((IForgeRegistry<Item>)registry, EnumCompactDrawer2By1.values(), compactDrawer2By1);
            Registration.registerCompactDrawerItem((IForgeRegistry<Item>)registry, EnumCompactDrawer2By1Half.values(), compactDrawer2By1Half);
            Registration.registerCompactDrawerItem((IForgeRegistry<Item>)registry, EnumCompactDrawerHalf.values(), compactDrawerHalf);
        }

        private static void registerTileEntity(Class<? extends TileEntity> tileEntityClass, String name) {
            GameRegistry.registerTileEntity(tileEntityClass, (ResourceLocation)new ResourceLocation("compactdrawers", name));
        }

        private static void registerCompactDrawerItem(IForgeRegistry<Item> registry, IDrawerSerializable[] drawerValues, BlockCompactDrawerBase block) {
            if (block != null) {
                registry.register(new ItemCompactDrawer(block, drawerValues).setRegistryName(block.getRegistryName()));
            }
        }

        @SubscribeEvent
        @SideOnly(value=Side.CLIENT)
        public static void registerModels(ModelRegistryEvent event) {
            ModelRegistry modelRegistry = Chameleon.instance.modelRegistry;
            if (compactDrawer2By1 != null) {
                compactDrawer2By1.initDynamic();
                modelRegistry.registerModel((IUnifiedRegister)new CompactDrawer2By1Model.Register());
                ClientRegistry.bindTileEntitySpecialRenderer(TileEntityCompactDrawer2By1.class, (TileEntitySpecialRenderer)new TileEntityCompactDrawerRenderer());
            }
            if (compactDrawer2By1Half != null) {
                compactDrawer2By1Half.initDynamic();
                modelRegistry.registerModel((IUnifiedRegister)new CompactDrawer2By1HalfModel.Register());
                ClientRegistry.bindTileEntitySpecialRenderer(TileEntityCompactDrawer2By1Half.class, (TileEntitySpecialRenderer)new TileEntityCompactDrawerRenderer());
            }
            if (compactDrawerHalf != null) {
                compactDrawerHalf.initDynamic();
                modelRegistry.registerModel((IUnifiedRegister)new CompactDrawerHalfModel.Register());
                ClientRegistry.bindTileEntitySpecialRenderer(TileEntityCompactDrawerHalf.class, (TileEntitySpecialRenderer)new TileEntityCompactDrawerRenderer());
            }
        }
    }
}

